/*
 * Decompiled with CFR 0.152.
 */
package org.spin.app.form;

import java.math.BigDecimal;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.spin.model.MADAppRegistration;
import org.spin.util.event.WeightScaleEvent;
import org.spin.util.event.WeightScaleEventListener;
import org.spin.util.support.AppSupportHandler;
import org.spin.util.support.IAppSupport;
import org.spin.ws.support.IWeightScale;
import org.spin.ws.support.WeightScaleMeasure;

public abstract class GetWeight
implements WeightScaleEventListener {
    private final String WEIGHT_SCALE = "WSR";
    public CLogger log = CLogger.getCLogger(this.getClass());
    private boolean started = false;
    private List<MADAppRegistration> weightScaleList = null;
    private MADAppRegistration currentDevice = null;
    private IWeightScale handler = null;
    private PO currentEntity = null;
    private BigDecimal weight = Env.ZERO;
    private StringBuffer message = new StringBuffer();

    public GetWeight() {
        this.log.info("");
        this.weight = Env.ZERO;
    }

    public String getDefaultText() {
        return "- - - - - - - - - - -";
    }

    public void setFromPO(ProcessInfo processInfo) {
        if (processInfo != null && processInfo.getTable_ID() > 0 && processInfo.getRecord_ID() > 0) {
            this.currentEntity = MTable.get((Properties)Env.getCtx(), (int)processInfo.getTable_ID()).getPO(processInfo.getRecord_ID(), null);
        }
    }

    public abstract boolean dynInit() throws Exception;

    public abstract void refreshDisplay(String var1);

    public boolean startService() {
        this.log.fine("startService()");
        if (this.currentDevice == null) {
            this.message.append(Msg.translate((Properties)Env.getCtx(), (String)"@PortNotConfiguredForUser@"));
            return false;
        }
        if (this.started) {
            return true;
        }
        try {
            this.loadHandler();
            this.started = true;
        }
        catch (Exception e) {
            this.message.append(e.getMessage());
        }
        return this.started;
    }

    private void wipeDisplay() {
        this.weight = null;
        this.refreshDisplay(this.getDefaultText());
    }

    private void loadHandler() throws Exception {
        IAppSupport supportedApplication;
        if (this.currentDevice != null && this.handler != null) {
            this.handler.stop();
            this.handler = null;
        }
        Thread.sleep(500L);
        this.wipeDisplay();
        if ((this.handler == null || this.currentDevice.getAD_AppRegistration_ID() != this.handler.getAppRegistrationId()) && (supportedApplication = AppSupportHandler.getInstance().getAppSupport(this.currentDevice)) != null && IWeightScale.class.isAssignableFrom(supportedApplication.getClass())) {
            this.handler = (IWeightScale)supportedApplication;
            this.handler.addListener(this);
        }
        if (this.handler != null) {
            this.handler.start();
        }
    }

    public String getMessage() {
        if (this.message.length() == 0) {
            return null;
        }
        return this.message.toString();
    }

    public void addMessage(String message) {
        if (Util.isEmpty((String)message)) {
            return;
        }
        if (this.message.length() > 0) {
            this.message.append(Env.NL);
        }
        this.message.append(message);
    }

    public void loadWeightScale() throws Exception {
        this.log.fine("loadSerialPortConfig()");
        this.weightScaleList = MADAppRegistration.getAll((Properties)Env.getCtx(), (boolean)true, null).stream().filter(applicationRegistration -> applicationRegistration.isActive()).filter(applicationRegistration -> applicationRegistration.getApplicationType().equals("WSR")).filter(applicationRegistration -> applicationRegistration.getAD_User_ID() == Env.getAD_User_ID((Properties)Env.getCtx()) || applicationRegistration.getAD_User_ID() <= 0).collect(Collectors.toList());
        this.setDevice(null);
    }

    private void setDevice(String deviceUuid) {
        if (this.weightScaleList != null && !this.weightScaleList.isEmpty()) {
            this.currentDevice = Util.isEmpty((String)deviceUuid) ? (MADAppRegistration)this.weightScaleList.stream().findFirst().get() : this.weightScaleList.stream().filter(weightScale -> !Util.isEmpty((String)weightScale.get_UUID()) && weightScale.get_UUID().equals(deviceUuid)).findFirst().get();
        }
    }

    public void setCurrentWeightScale(String deviceUuid) {
        this.setDevice(deviceUuid);
        Env.setContext((Properties)this.currentDevice.getCtx(), (String)"AD_Device_ID", (int)this.currentDevice.getAD_AppRegistration_ID());
        Env.setContext((Properties)this.currentDevice.getCtx(), (String)"ScaleReference_ID", (int)this.currentDevice.getAD_AppRegistration_ID());
    }

    public List<ValueNamePair> getWeightScaleList() {
        return this.weightScaleList.stream().map(weightScale -> new ValueNamePair(weightScale.getUUID(), weightScale.getName())).collect(Collectors.toList());
    }

    public MADAppRegistration getCurrentWeightScale() {
        return this.currentDevice;
    }

    public boolean stopService() {
        this.log.fine("stopService()");
        if (this.started) {
            this.log.fine("Port Started " + this.started);
            try {
                this.handler.stop();
                this.handler.removeListener(this);
                this.started = false;
                this.log.fine("Port Started " + this.started);
            }
            catch (Exception e) {
                this.message.append(e.getMessage());
                e.printStackTrace();
            }
        }
        return !this.started;
    }

    @Override
    public void messageReceived(WeightScaleEvent ev) {
        if (ev.getEventType() == 1) {
            try {
                WeightScaleMeasure measure = (WeightScaleMeasure)ev.getSource();
                if (this.getCurrentWeightScale().getValue().equals(measure.getScaleName())) {
                    this.weight = measure.getWeight();
                    this.refreshDisplay(measure.getDisplayWeight());
                }
            }
            catch (Exception e) {
                this.log.severe(e.getMessage());
            }
        }
    }

    public BigDecimal getWeight() {
        return this.weight;
    }

    public void processValue() {
        if (this.currentEntity != null) {
            this.currentEntity.set_ValueOfColumn("WeightRegistered", (Object)this.getWeight());
            if (this.currentDevice != null && this.currentDevice.getAD_AppRegistration_ID() != 0) {
                this.currentEntity.set_ValueOfColumn("ScaleReference_ID", (Object)this.currentDevice.getAD_AppRegistration_ID());
            }
            this.currentEntity.saveEx();
        }
    }
}

