/*
 * Decompiled with CFR 0.152.
 */
package org.spin.process;

import java.sql.Timestamp;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.TimeUtil;
import org.eevolution.process.GenerateCostDetail;
import org.eevolution.service.dsl.ProcessBuilder;
import org.spin.process.CheckProductCostAbstract;

public class CheckProductCost
extends CheckProductCostAbstract {
    private AtomicInteger counter = new AtomicInteger();
    private AtomicInteger errors = new AtomicInteger();

    protected String doIt() throws Exception {
        if (this.getMaxQuantityProducts() > 0) {
            new Query(this.getCtx(), "M_Product", "EXISTS(SELECT 1 FROM M_Storage s WHERE s.M_Product_ID = M_Product.M_Product_ID AND COALESCE(s.QtyOnHand, 0) <> 0 AND NOT EXISTS(SELECT 1 FROM M_Cost c \t\t\tWHERE c.M_Product_ID = s.M_Product_ID \t\t\tAND COALESCE(c.CurrentQty, 0) = COALESCE(s.QtyOnHand, 0)))", this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).setLimit(this.getMaxQuantityProducts()).getIDsAsList().forEach(productId -> {
                MProduct product = MProduct.get((Properties)this.getCtx(), (int)productId);
                try {
                    ProcessBuilder.create((Properties)this.getCtx()).process(Integer.valueOf(GenerateCostDetail.getProcessId())).withParameter("M_Product_ID", (Object)product.getM_Product_ID()).withParameter("DateAcct", (Object)TimeUtil.addDays((Timestamp)TimeUtil.getDay((long)System.currentTimeMillis()), (int)-30), (Object)TimeUtil.getDay((long)System.currentTimeMillis())).withClientId(Integer.valueOf(this.getAD_Client_ID())).execute(this.get_TrxName());
                    this.counter.incrementAndGet();
                    this.addLog(product.getValue() + " - " + product.getName() + ": @Processed@");
                    this.log.fine(product.getValue() + " - " + product.getName() + ": @Processed@");
                }
                catch (Exception e) {
                    this.errors.incrementAndGet();
                    this.addLog(product.getValue() + " - " + product.getName() + ": " + e.getLocalizedMessage());
                    this.log.severe(product.getValue() + " - " + product.getName() + ": " + e.getLocalizedMessage());
                }
            });
        }
        return "@Processed@: " + this.counter + " @Errors@: " + this.errors;
    }
}

