/*
 * Decompiled with CFR 0.152.
 */
package org.spin.sfm.util;

import java.math.BigDecimal;
import java.util.Properties;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MUOMConversion;

public class SalesForceManagementUtil {
    public static final String COLUMNNAME_DefaultPurchaseUOM_ID = "DefaultPurchaseUOM_ID";
    public static final String COLUMNNAME_DefaultSalesUOM_ID = "DefaultSalesUOM_ID";
    public static final String PriceListVisitScheduled_TableName = "SFM_VSPriceList";

    public static void setDefaultSalesUnitOfMeasure(MOrderLine orderLine) {
        if (orderLine.getM_Product_ID() <= 0) {
            return;
        }
        MOrder order = orderLine.getParent();
        if (order.get_ValueAsInt("W_Store_ID") > 0 || order.get_ValueAsInt("C_POS_ID") > 0) {
            MProduct product = MProduct.get((Properties)orderLine.getCtx(), (int)orderLine.getM_Product_ID());
            if (product.get_ValueAsInt(COLUMNNAME_DefaultSalesUOM_ID) <= 0) {
                return;
            }
            if (product.get_ValueAsInt(COLUMNNAME_DefaultSalesUOM_ID) == orderLine.getC_UOM_ID()) {
                return;
            }
            BigDecimal quantityEntered = orderLine.getQtyEntered();
            BigDecimal convertedQuantity = MUOMConversion.convertProductFrom((Properties)orderLine.getCtx(), (int)orderLine.getM_Product_ID(), (int)product.get_ValueAsInt(COLUMNNAME_DefaultSalesUOM_ID), (BigDecimal)quantityEntered);
            BigDecimal convertedPrice = MUOMConversion.convertProductFrom((Properties)orderLine.getCtx(), (int)orderLine.getM_Product_ID(), (int)product.get_ValueAsInt(COLUMNNAME_DefaultSalesUOM_ID), (BigDecimal)orderLine.getPriceActual());
            orderLine.setC_UOM_ID(product.get_ValueAsInt(COLUMNNAME_DefaultSalesUOM_ID));
            orderLine.setQtyOrdered(convertedQuantity);
            orderLine.setPriceEntered(convertedPrice);
            orderLine.setLineNetAmt();
        }
    }
}

