/*
 * Decompiled with CFR 0.152.
 */
package org.spin.sfm.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.spin.sfm.model.MSFMVisitSchedule;
import org.spin.sfm.model.MSFMVisitScheduleLine;
import org.spin.sfm.process.VisitScheduleCreateFromCustomerDataAbstract;

public class VisitScheduleCreateFromCustomerData
extends VisitScheduleCreateFromCustomerDataAbstract {
    private AtomicInteger counter = new AtomicInteger();
    private MSFMVisitSchedule visitSchedule;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() <= 0) {
            throw new AdempiereException("@SFM_VisitSchedule_ID@ @NotFound@");
        }
        this.visitSchedule = new MSFMVisitSchedule(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (this.visitSchedule.getSalesRep_ID() <= 0) {
            throw new AdempiereException("@SalesRep_ID@ @IsMandatory@");
        }
    }

    protected String doIt() throws Exception {
        AtomicInteger sequence = new AtomicInteger();
        sequence.set(DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(vsl.SeqNo) FROM SFM_VisitScheduleLine vsl WHERE vsl.SFM_VisitSchedule_ID = ?", (int)this.visitSchedule.getSFM_VisitSchedule_ID()));
        if (sequence.get() < 0) {
            sequence.set(10);
        } else {
            sequence.addAndGet(10);
        }
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        if (!this.isAllCustomers()) {
            whereClause.append("SalesRep_ID = ? AND ");
            parameters.add(this.visitSchedule.getSalesRep_ID());
        }
        parameters.add(this.visitSchedule.getSFM_VisitSchedule_ID());
        new Query(this.getCtx(), "C_BPartner", whereClause.toString() + "C_BPartner.IsCustomer = 'Y' AND NOT EXISTS(SELECT 1 FROM SFM_VisitScheduleLine vsl WHERE vsl.C_BPartner_ID = C_BPartner.C_BPartner_ID AND vsl.SFM_VisitSchedule_ID = ?)", this.get_TrxName()).setParameters(parameters).setClient_ID().setOnlyActiveRecords(true).getIDsAsList().forEach(customerId -> {
            MBPartner customer = new MBPartner(Env.getCtx(), customerId.intValue(), this.get_TrxName());
            List<MBPartnerLocation> locations = Arrays.asList(customer.getLocations(false));
            locations.stream().filter(shipmentLocation -> shipmentLocation.isShipTo()).forEach(shipmentLocation -> {
                MSFMVisitScheduleLine visitScheduleLine = new MSFMVisitScheduleLine(this.getCtx(), 0, this.get_TrxName());
                visitScheduleLine.setSFM_VisitSchedule_ID(this.visitSchedule.getSFM_VisitSchedule_ID());
                visitScheduleLine.setC_BPartner_ID(customer.getC_BPartner_ID());
                visitScheduleLine.setC_BPartner_Location_ID(shipmentLocation.getC_BPartner_Location_ID());
                if (shipmentLocation.getC_SalesRegion_ID() > 0) {
                    visitScheduleLine.setC_SalesRegion_ID(shipmentLocation.getC_SalesRegion_ID());
                }
                locations.stream().filter(location -> location.isBillTo()).findFirst().ifPresent(location -> visitScheduleLine.setBill_Location_ID(location.getC_BPartner_Location_ID()));
                if (!Util.isEmpty((String)customer.getSO_Description())) {
                    visitScheduleLine.setDescription(customer.getSO_Description());
                }
                visitScheduleLine.setSeqNo(sequence.getAndAdd(10));
                visitScheduleLine.setSFM_AllDays(this.isAllDays());
                visitScheduleLine.saveEx();
            });
            if (locations.size() > 0 && this.isDeallocateSeller()) {
                customer.setSalesRep_ID(-1);
                customer.saveEx();
            }
        });
        return "@Created@: " + this.counter.get();
    }
}

