/*
 * Decompiled with CFR 0.152.
 */
package org.spin.sfm.model.validator;

import java.util.Optional;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.spin.sfm.model.MSFMVisitSchedule;
import org.spin.sfm.model.MSFMVisitScheduleLine;

public class SalesForce
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(SalesForce.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Order", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        if ((type == 1 || type == 2) && entity.get_TableName().equals("C_Order") && entity.is_new() && (entity.get_ValueAsInt("SFM_VisitSchedule_ID") > 0 || entity.get_ValueAsInt("SFM_VisitScheduleLine_ID") > 0)) {
            this.setValuesfromVisitSchedule(entity);
        }
        return null;
    }

    public String docValidate(PO entity, int timing) {
        return null;
    }

    void setValuesfromVisitSchedule(PO document) {
        Optional<Object> source = Optional.empty();
        if (document.get_ValueAsInt("SFM_VisitScheduleLine_ID") > 0) {
            source = Optional.ofNullable(new MSFMVisitScheduleLine(document.getCtx(), document.get_ValueAsInt("SFM_VisitScheduleLine_ID"), document.get_TrxName()));
        } else if (document.get_ValueAsInt("SFM_VisitSchedule_ID") > 0) {
            source = Optional.ofNullable(new MSFMVisitSchedule(document.getCtx(), document.get_ValueAsInt("SFM_VisitSchedule_ID"), document.get_TrxName()));
        }
        source.ifPresent(sourceDocument -> {
            int docTypeId;
            if (sourceDocument.get_ValueAsInt("AD_OrgTrx_ID") > 0) {
                document.set_ValueOfColumn("AD_OrgTrx_ID", (Object)sourceDocument.get_ValueAsInt("AD_OrgTrx_ID"));
            }
            if (sourceDocument.get_ValueAsInt("C_Activity_ID") > 0) {
                document.set_ValueOfColumn("C_Activity_ID", (Object)sourceDocument.get_ValueAsInt("C_Activity_ID"));
            }
            if (sourceDocument.get_ValueAsInt("C_Campaign_ID") > 0) {
                document.set_ValueOfColumn("C_Campaign_ID", (Object)sourceDocument.get_ValueAsInt("C_Campaign_ID"));
            }
            if (sourceDocument.get_ValueAsInt("C_Project_ID") > 0) {
                document.set_ValueOfColumn("C_Project_ID", (Object)sourceDocument.get_ValueAsInt("C_Project_ID"));
            }
            if (sourceDocument.get_ValueAsInt("User1_ID") > 0) {
                document.set_ValueOfColumn("User1_ID", (Object)sourceDocument.get_ValueAsInt("User1_ID"));
            }
            if (sourceDocument.get_ValueAsInt("User2_ID") > 0) {
                document.set_ValueOfColumn("User2_ID", (Object)sourceDocument.get_ValueAsInt("User2_ID"));
            }
            if (sourceDocument.get_ValueAsInt("User3_ID") > 0) {
                document.set_ValueOfColumn("User3_ID", (Object)sourceDocument.get_ValueAsInt("User3_ID"));
            }
            if (sourceDocument.get_ValueAsInt("User4_ID") > 0) {
                document.set_ValueOfColumn("User4_ID", (Object)sourceDocument.get_ValueAsInt("User4_ID"));
            }
            if (document instanceof MOrder && (docTypeId = sourceDocument.get_ValueAsInt("C_DocType_ID")) > 0) {
                document.set_ValueOfColumn("C_DocType_ID", (Object)docTypeId);
            }
        });
    }
}

