/*
 * Decompiled with CFR 0.152.
 */
package org.spin.sfm.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.spin.sfm.model.X_SFM_VisitScheduleLine;

public class MSFMVisitScheduleLine
extends X_SFM_VisitScheduleLine {
    private static final long serialVersionUID = 5448641333159848635L;
    private static CCache<Integer, MSFMVisitScheduleLine> visitScheduleLineCacheIds = new CCache("SFM_VisitScheduleLine", 30);

    public MSFMVisitScheduleLine(Properties ctx, int visitScheduleLineId, String trxName) {
        super(ctx, visitScheduleLineId, trxName);
    }

    public MSFMVisitScheduleLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MSFMVisitScheduleLine getById(Properties ctx, int taxId, String trxName) {
        if (taxId <= 0) {
            return null;
        }
        MSFMVisitScheduleLine visitScheduleLine = (MSFMVisitScheduleLine)visitScheduleLineCacheIds.get((Object)taxId);
        if (visitScheduleLine != null && visitScheduleLine.get_ID() > 0) {
            return visitScheduleLine;
        }
        visitScheduleLine = (MSFMVisitScheduleLine)new Query(ctx, "SFM_VisitScheduleLine", "SFM_VisitScheduleLine_ID=?", trxName).setParameters(new Object[]{taxId}).first();
        if (visitScheduleLine != null && visitScheduleLine.get_ID() > 0) {
            visitScheduleLineCacheIds.put((Object)visitScheduleLine.get_ID(), (Object)visitScheduleLine);
        }
        return visitScheduleLine;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.isSFM_AllDays()) {
            this.setOnSunday(true);
            this.setOnMonday(true);
            this.setOnTuesday(true);
            this.setOnWednesday(true);
            this.setOnThursday(true);
            this.setOnFriday(true);
            this.setOnSaturday(true);
        }
        return super.beforeSave(newRecord);
    }

    public static List<MSFMVisitScheduleLine> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || visitScheduleLineCacheIds.size() > 0) {
            List ticketTypeList = new Query(Env.getCtx(), "SFM_VisitScheduleLine", null, trxName).setClient_ID().list();
            ticketTypeList.stream().forEach(airport -> visitScheduleLineCacheIds.put((Object)airport.getSFM_VisitScheduleLine_ID(), airport));
            return ticketTypeList;
        }
        List<MSFMVisitScheduleLine> ticketTypeList = visitScheduleLineCacheIds.entrySet().stream().map(applicationType -> (MSFMVisitScheduleLine)applicationType.getValue()).collect(Collectors.toList());
        return ticketTypeList;
    }

    @Override
    public String toString() {
        return "MSFMVisitScheduleLine [getC_BPartner_ID()=" + this.getC_BPartner_ID() + ", getFrequencyType()=" + this.getFrequencyType() + ", isOnFriday()=" + this.isOnFriday() + ", isOnMonday()=" + this.isOnMonday() + ", isOnSaturday()=" + this.isOnSaturday() + ", isOnSunday()=" + this.isOnSunday() + ", isOnThursday()=" + this.isOnThursday() + ", isOnTuesday()=" + this.isOnTuesday() + ", isOnWednesday()=" + this.isOnWednesday() + ", getSeqNo()=" + this.getSeqNo() + ", getSFM_VisitScheduleLine_ID()=" + this.getSFM_VisitScheduleLine_ID() + ", getUUID()=" + this.getUUID() + "]";
    }
}

