/*
 * Decompiled with CFR 0.152.
 */
package org.spin.sfm.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.spin.sfm.model.MSFMVisitScheduleLine;
import org.spin.sfm.model.X_SFM_VisitSchedule;

public class MSFMVisitSchedule
extends X_SFM_VisitSchedule {
    private static final long serialVersionUID = 5448641333159848635L;
    private static CCache<Integer, MSFMVisitSchedule> visitScheduleCacheIds = new CCache("SFM_VisitSchedule", 30);
    private static CCache<String, MSFMVisitSchedule> visitScheduleCodes = new CCache("SFM_VisitSchedule", 30);
    private List<MSFMVisitScheduleLine> visitScheduleLineList = null;

    public MSFMVisitSchedule(Properties ctx, int ticketTypeId, String trxName) {
        super(ctx, ticketTypeId, trxName);
    }

    public MSFMVisitSchedule(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getLineDescription(String message, Object ... parameters) {
        return Msg.getMsg((Properties)this.getCtx(), (String)message, (Object[])parameters);
    }

    public static MSFMVisitSchedule getById(Properties ctx, int visitScheduleId, String trxName) {
        if (visitScheduleId <= 0) {
            return null;
        }
        MSFMVisitSchedule visitSchedule = (MSFMVisitSchedule)visitScheduleCacheIds.get((Object)visitScheduleId);
        if (visitSchedule != null && visitSchedule.get_ID() > 0) {
            return visitSchedule;
        }
        visitSchedule = (MSFMVisitSchedule)new Query(ctx, "SFM_VisitSchedule", "SFM_VisitSchedule_ID=?", trxName).setParameters(new Object[]{visitScheduleId}).first();
        if (visitSchedule != null && visitSchedule.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + visitSchedule.getValue();
            visitScheduleCodes.put((Object)key, (Object)visitSchedule);
            visitScheduleCacheIds.put((Object)visitSchedule.get_ID(), (Object)visitSchedule);
        }
        return visitSchedule;
    }

    public static MSFMVisitSchedule getByValue(Properties ctx, String value, String trxName) {
        String key;
        MSFMVisitSchedule vistSchedule;
        if (value == null) {
            return null;
        }
        if (visitScheduleCodes.size() == 0) {
            MSFMVisitSchedule.getAll(ctx, true, trxName);
        }
        if ((vistSchedule = (MSFMVisitSchedule)visitScheduleCodes.get((Object)(key = value))) != null && vistSchedule.get_ID() > 0) {
            return vistSchedule;
        }
        vistSchedule = (MSFMVisitSchedule)new Query(ctx, "SFM_VisitSchedule", "Value=?", trxName).setParameters(new Object[]{value}).first();
        if (vistSchedule != null && vistSchedule.get_ID() > 0) {
            visitScheduleCodes.put((Object)key, (Object)vistSchedule);
            visitScheduleCacheIds.put((Object)vistSchedule.get_ID(), (Object)vistSchedule);
        }
        return vistSchedule;
    }

    public static List<MSFMVisitSchedule> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || visitScheduleCacheIds.size() > 0) {
            List vistScheduleList = new Query(Env.getCtx(), "SFM_VisitSchedule", null, trxName).setClient_ID().list();
            vistScheduleList.stream().forEach(airport -> {
                String key = airport.getValue();
                visitScheduleCacheIds.put((Object)airport.getSFM_VisitSchedule_ID(), airport);
                visitScheduleCodes.put((Object)key, airport);
            });
            return vistScheduleList;
        }
        List<MSFMVisitSchedule> vistScheduleList = visitScheduleCacheIds.entrySet().stream().map(applicationType -> (MSFMVisitSchedule)applicationType.getValue()).collect(Collectors.toList());
        return vistScheduleList;
    }

    public List<MSFMVisitScheduleLine> getLines(boolean requery) {
        if (this.visitScheduleLineList == null || requery) {
            this.visitScheduleLineList = new Query(this.getCtx(), "SFM_VisitScheduleLine", "SFM_VisitSchedule_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getSFM_VisitSchedule_ID()}).setOnlyActiveRecords(true).list();
        }
        return this.visitScheduleLineList;
    }

    @Override
    public String toString() {
        return "MSFMVisitSchedule [getC_SalesRegion_ID()=" + this.getC_SalesRegion_ID() + ", getSalesRep_ID()=" + this.getSalesRep_ID() + ", getSFM_VisitSchedule_ID()=" + this.getSFM_VisitSchedule_ID() + ", getUUID()=" + this.getUUID() + ", getValidFrom()=" + this.getValidFrom() + ", getValue()=" + this.getValue() + "]";
    }
}

