/*
 * Decompiled with CFR 0.152.
 */
package org.spin.sfm.appwrite120.process;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MProduct;
import org.compiere.model.MStore;
import org.compiere.model.MTax;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.spin.appwrite120.utils.AppWrite;
import org.spin.model.MADAppRegistration;
import org.spin.queue.store.support.IECommerceEntity;
import org.spin.sfm.appwrite120.process.SendDataAbstract;
import org.spin.sfm.appwrite120.util.SalesForceApi;
import org.spin.util.support.AppSupportHandler;
import org.spin.util.support.IAppSupport;

public class SendData
extends SendDataAbstract {
    private String whereClauseSalesRep = "";

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        if (this.getStoreId() == 0) {
            new AdempiereException("@FillMandatory@ @W_Store_ID@ ");
        }
        if (this.getSalesRepId() > 0) {
            this.whereClauseSalesRep = " AND vs.SalesRep_ID = ".concat(String.valueOf(this.getSalesRepId()));
        }
        MStore webStore = MStore.get((Properties)this.getCtx(), (int)this.getStoreId());
        MADAppRegistration registration = MADAppRegistration.getById((Properties)this.getCtx(), (int)webStore.get_ValueAsInt("CacheServerProvider_ID"), (String)this.get_TrxName());
        if (registration.get_ID() > 0) {
            this.sendData(registration, webStore);
        }
        return "@OK@";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendData(MADAppRegistration appRegistration, MStore store) throws Exception {
        IAppSupport supportedApplication = AppSupportHandler.getInstance().getAppSupport(appRegistration);
        if (supportedApplication != null && AppWrite.class.isAssignableFrom(supportedApplication.getClass())) {
            SalesForceApi appWrite = (SalesForceApi)supportedApplication;
            try {
                if (this.isCreateUsers()) {
                    this.createUsers(appWrite);
                }
                if (this.isCreateCurrencies()) {
                    this.createCurrencies(appWrite);
                }
                if (this.isCreatePriceLists()) {
                    this.createPriceLists(appWrite);
                }
                if (this.isCreateCustomers()) {
                    this.createBPartners(appWrite);
                }
                if (this.isCreateVisitScheduled()) {
                    this.createVisitScheduleLine(appWrite);
                }
            }
            catch (Exception e) {
                this.addLog(e.getMessage());
            }
            finally {
                appWrite.clearParameters();
            }
        }
    }

    private void createUsers(AppWrite api) {
        String whereClause = "EXISTS(SELECT 1 FROM SFM_VisitSchedule vs WHERE vs.SalesRep_ID = AD_User.AD_User_ID ".concat(this.whereClauseSalesRep).concat(")");
        new Query(this.getCtx(), "AD_User", whereClause, this.get_TrxName()).setOnlyActiveRecords(true).setClient_ID().list().forEach(user -> {
            try {
                this.exportEntity((PO)user, api);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void createCurrencies(AppWrite api) {
        String whereClause = "EXISTS (SELECT 1 FROM M_PriceList pl WHERE pl.C_Currency_ID = C_Currency.C_Currency_ID AND pl.IsActive = 'Y')";
        new Query(this.getCtx(), "C_Currency", whereClause, this.get_TrxName()).setOnlyActiveRecords(true).list().forEach(currency -> {
            try {
                this.exportEntity((PO)currency, api);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void createPriceLists(AppWrite api) {
        HashMap productsCreated = new HashMap();
        HashMap taxCreated = new HashMap();
        List<MTax> allTaxes = Arrays.asList(MTax.getAll((Properties)this.getCtx()));
        String whereClause = "EXISTS (SELECT 1 FROM SFM_VisitSchedule vs INNER JOIN SFM_VSPriceList vpl ON (vs.SFM_VisitSchedule_ID = vpl.SFM_VisitSchedule_ID) WHERE vs.IsActive = 'Y' AND vpl.IsActive = 'Y' " + "AND vpl.M_PriceList_ID = M_PriceList.M_PriceList_ID ".concat(this.whereClauseSalesRep).concat(")");
        new Query(this.getCtx(), "M_PriceList", whereClause, this.get_TrxName()).setOnlyActiveRecords(true).list().forEach(priceList -> {
            try {
                this.exportEntity((PO)priceList, api);
                Optional.ofNullable(priceList.getPriceListVersion(null)).ifPresent(priceListVersion -> new Query(this.getCtx(), "M_ProductPrice", "M_PriceList_Version_ID =? ", this.get_TrxName()).setParameters(new Object[]{priceListVersion.get_ID()}).setOnlyActiveRecords(true).list().forEach(productPrice -> {
                    try {
                        this.exportEntity((PO)productPrice, api);
                        Optional.ofNullable(productsCreated.get(productPrice.getM_Product_ID())).orElseGet(() -> {
                            Optional.ofNullable(MProduct.get((Properties)this.getCtx(), (int)productPrice.getM_Product_ID())).ifPresent(product -> {
                                try {
                                    this.exportEntity((PO)product, api);
                                    productsCreated.put(product.get_ID(), product);
                                    allTaxes.stream().filter(tax -> tax.getC_TaxCategory_ID() == product.getC_TaxCategory_ID()).forEach(tax -> {
                                        try {
                                            if (taxCreated.get(tax.getC_Tax_ID()) == null) {
                                                this.exportEntity((PO)tax, api);
                                                taxCreated.put(tax.get_ID(), tax);
                                            }
                                        }
                                        catch (Exception e) {
                                            this.addLog(e.getMessage());
                                        }
                                    });
                                }
                                catch (Exception e) {
                                    this.addLog(e.getMessage());
                                }
                            });
                            return null;
                        });
                    }
                    catch (Exception e) {
                        this.addLog(e.getMessage());
                    }
                }));
            }
            catch (Exception e) {
                this.addLog(e.getMessage());
            }
        });
    }

    private void createBPartners(AppWrite api) {
        String whereClause = "EXISTS (SELECT 1 FROM SFM_VisitScheduleLine vsl INNER JOIN SFM_VisitSchedule vs ON (vsl.SFM_VisitSchedule_ID = vs.SFM_VisitSchedule_ID) WHERE vsl.IsActive = 'Y' " + "AND C_BPartner.C_BPartner_ID = vsl.C_BPartner_ID ".concat(this.whereClauseSalesRep).concat(")");
        new Query(this.getCtx(), "C_BPartner", whereClause, this.get_TrxName()).setOnlyActiveRecords(true).list().forEach(bPartner -> {
            try {
                this.exportEntity((PO)bPartner, api);
                String whereClauseLocations = "EXISTS (SELECT 1 FROM SFM_VisitScheduleLine vsl WHERE vsl.IsActive = 'Y' AND C_BPartner_Location.C_BPartner_Location_ID IN (vsl.C_BPartner_Location_ID, vsl.Bill_Location_ID)) AND C_BPartner_ID = ? ";
                new Query(this.getCtx(), "C_BPartner_Location", whereClauseLocations, this.get_TrxName()).setOnlyActiveRecords(true).setParameters(new Object[]{bPartner.get_ID()}).list().forEach(bPartnerLocation -> {
                    try {
                        this.exportEntity((PO)bPartnerLocation, api);
                    }
                    catch (Exception e) {
                        this.addLog(e.getMessage());
                    }
                });
                String whereClauseInvoiceOpen = "IsPaid = 'N' AND IsSOTrx='Y' AND C_BPartner_ID=? AND DocStatus = ? ";
                new Query(this.getCtx(), "C_Invoice", whereClauseInvoiceOpen, this.get_TrxName()).setOnlyActiveRecords(true).setParameters(new Object[]{bPartner.get_ID(), "CO"}).list().forEach(invoiceOpen -> {
                    try {
                        this.exportEntity((PO)invoiceOpen, api);
                    }
                    catch (Exception e) {
                        this.addLog(e.getMessage());
                    }
                });
            }
            catch (Exception e) {
                this.addLog(e.getMessage());
            }
        });
    }

    private void createVisitScheduleLine(AppWrite api) {
        String whereClause = "EXISTS(SELECT 1 FROM SFM_VisitSchedule vs WHERE SFM_VisitScheduleLine.SFM_VisitSchedule_ID = vs.SFM_VisitSchedule_ID ".concat(this.whereClauseSalesRep).concat(")");
        new Query(this.getCtx(), "SFM_VisitScheduleLine", whereClause, this.get_TrxName()).setOnlyActiveRecords(true).setClient_ID().list().forEach(visitScheduleLine -> {
            try {
                this.exportEntity((PO)visitScheduleLine, api);
            }
            catch (Exception e) {
                this.addLog(e.getMessage());
            }
        });
    }

    private void exportEntity(PO entity, AppWrite appWrite) throws Exception {
        IECommerceEntity wrapper = appWrite.getPersistenceWrapper(entity);
        if (wrapper == null) {
            return;
        }
        appWrite.create(wrapper);
    }
}

