/*
 * Decompiled with CFR 0.152.
 */
package org.spin.sfm.appwrite120.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ws.rs.core.MultivaluedHashMap;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo.IDFinder;
import org.compiere.model.MConversionType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MStore;
import org.spin.appwrite120.utils.AppWrite;
import org.spin.appwrite120.utils.IAppWriteData;
import org.spin.model.MADAppRegistration;
import org.spin.sfm.appwrite120.MOrderCollection;
import org.spin.sfm.appwrite120.MOrderDocument;
import org.spin.sfm.appwrite120.process.GetDataAbstract;
import org.spin.sfm.appwrite120.util.SalesForceApi;
import org.spin.sfm.model.MSFMVisitSchedule;
import org.spin.sfm.model.MSFMVisitScheduleLine;
import org.spin.util.support.AppSupportHandler;
import org.spin.util.support.IAppSupport;

public class GetData
extends GetDataAbstract {
    private AtomicInteger countOrdersCreated = new AtomicInteger(0);
    private AtomicInteger countOrdersUpdated = new AtomicInteger(0);

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        if (this.getStoreId() == 0) {
            new AdempiereException("@FillMandatory@ @W_Store_ID@ ");
        }
        MStore webStore = MStore.get((Properties)this.getCtx(), (int)this.getStoreId());
        MADAppRegistration registration = MADAppRegistration.getById((Properties)this.getCtx(), (int)webStore.get_ValueAsInt("CacheServerProvider_ID"), (String)this.get_TrxName());
        if (registration.get_ID() > 0) {
            this.getData(registration, webStore);
        }
        return "@C_Order_ID@ @Created@ -> " + this.countOrdersCreated.get() + " @Updated@ ->" + this.countOrdersUpdated.get();
    }

    private void getData(MADAppRegistration appRegistration, MStore store) throws Exception {
        IAppSupport supportedApplication = AppSupportHandler.getInstance().getAppSupport(appRegistration);
        if (supportedApplication != null && AppWrite.class.isAssignableFrom(supportedApplication.getClass())) {
            SalesForceApi appWrite = (SalesForceApi)supportedApplication;
            try {
                appWrite.clearPaths();
                IAppWriteData wrapper = MOrderDocument.newInstance().withOrder(null).withAppWriteApi(appWrite);
                Optional.ofNullable(wrapper.list()).ifPresent(ordersApi -> ordersApi.entrySet().forEach(orderApi -> {
                    MOrder order;
                    Map data = (Map)orderApi.getValue();
                    System.out.println(data.get("DocumentNo").toString());
                    String orderUUID = data.get(MOrderCollection.ORDER_UUID).toString();
                    String orderLineUUID = data.get(MOrderCollection.ORDERLINE_UUID).toString();
                    int orderId = IDFinder.getIdFromUUID((Properties)this.getCtx(), (String)"C_Order", (String)orderUUID, (int)this.getAD_Client_ID(), (String)this.get_TrxName());
                    int orderLineId = IDFinder.getIdFromUUID((Properties)this.getCtx(), (String)"C_OrderLine", (String)orderLineUUID, (int)this.getAD_Client_ID(), (String)this.get_TrxName());
                    int bPartnerId = IDFinder.getIdFromUUID((Properties)this.getCtx(), (String)"C_BPartner", (String)data.get(MOrderCollection.BPARTNER_UUID).toString(), (int)this.getAD_Client_ID(), (String)this.get_TrxName());
                    int bPartnerLocationId = IDFinder.getIdFromUUID((Properties)this.getCtx(), (String)"C_BPartner_Location", (String)data.get(MOrderCollection.BPARTNERLOCATION_UUID).toString(), (int)this.getAD_Client_ID(), (String)this.get_TrxName());
                    int billBPartnerLocationId = IDFinder.getIdFromUUID((Properties)this.getCtx(), (String)"C_BPartner_Location", (String)data.get(MOrderCollection.BILLLOCATION_UUID).toString(), (int)this.getAD_Client_ID(), (String)this.get_TrxName());
                    int priceListId = IDFinder.getIdFromUUID((Properties)this.getCtx(), (String)"M_PriceList", (String)data.get(MOrderCollection.PRICELIST_UUID).toString(), (int)this.getAD_Client_ID(), (String)this.get_TrxName());
                    int productId = IDFinder.getIdFromUUID((Properties)this.getCtx(), (String)"M_Product", (String)data.get(MOrderCollection.PRODUCT_UUID).toString(), (int)this.getAD_Client_ID(), (String)this.get_TrxName());
                    int visitScheduleLineId = IDFinder.getIdFromUUID((Properties)this.getCtx(), (String)"SFM_VisitScheduleLine", (String)data.get(MOrderCollection.VISITSCHEDULELINE_UUID).toString(), (int)this.getAD_Client_ID(), (String)this.get_TrxName());
                    if (orderId == 0) {
                        order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                        order.setUUID(orderUUID);
                        order.setDocumentNo(data.get("DocumentNo").toString());
                        order.setPOReference(order.getDocumentNo());
                        order.setC_DocTypeTarget_ID("SO");
                        order.setC_DocType_ID(order.getC_DocTypeTarget_ID());
                        order.setC_BPartner_ID(bPartnerId);
                        order.setC_BPartner_Location_ID(bPartnerLocationId);
                        order.setBill_Location_ID(billBPartnerLocationId);
                        order.setDescription(data.get("Description").toString());
                        order.setDateOrdered((Timestamp)data.get("DateOrdered"));
                        order.setM_PriceList_ID(priceListId);
                        order.set_ValueOfColumn("IsPrepayment", data.get("IsPrepayment"));
                        order.setM_Warehouse_ID(store.getM_Warehouse_ID());
                        order.setC_ConversionType_ID(MConversionType.getDefault((int)order.getAD_Client_ID()));
                        if (visitScheduleLineId > 0) {
                            Optional<MSFMVisitScheduleLine> maybeScheduleLine = Optional.ofNullable(new MSFMVisitScheduleLine(this.getCtx(), visitScheduleLineId, this.get_TrxName()));
                            maybeScheduleLine.ifPresent(scheduleLine -> {
                                Optional<MSFMVisitSchedule> maybeSchedule = Optional.ofNullable(MSFMVisitSchedule.getById(this.getCtx(), scheduleLine.getSFM_VisitSchedule_ID(), this.get_TrxName()));
                                maybeSchedule.ifPresent(schedule -> {
                                    order.set_ValueOfColumn("SFM_VisitScheduleLine_ID", (Object)visitScheduleLineId);
                                    order.set_ValueOfColumn("SFM_VisitSchedule_ID", (Object)schedule.get_ID());
                                    order.setSalesRep_ID(schedule.getSalesRep_ID());
                                });
                            });
                        }
                        order.saveEx();
                        this.addLog("@Created@ @C_Order_ID@ -> ".concat(order.getDocumentNo()));
                        order.setUUID(orderUUID);
                        order.saveEx();
                        this.countOrdersCreated.incrementAndGet();
                    } else {
                        order = new MOrder(this.getCtx(), orderId, this.get_TrxName());
                        this.addLog("@Updated@ @C_Order_ID@ -> ".concat(Optional.ofNullable(order.getDocumentNo()).orElse("")));
                        this.countOrdersUpdated.incrementAndGet();
                    }
                    if (orderLineId == 0) {
                        if (!order.isProcessed()) {
                            MOrderLine orderLine = new MOrderLine(order);
                            orderLine.setProduct(MProduct.get((Properties)this.getCtx(), (int)productId));
                            orderLine.setQty((BigDecimal)data.get("QtyEntered"));
                            orderLine.setPrice((BigDecimal)data.get("PriceEntered"));
                            orderLine.setUUID(orderLineUUID);
                            orderLine.setTax();
                            orderLine.saveEx();
                            orderLine.setUUID(orderLineUUID);
                            orderLine.saveEx();
                        } else {
                            this.addLog("@C_Order_ID@ -> ".concat(order.getDocumentNo()).concat(" @Processed@"));
                        }
                    } else {
                        wrapper.setValue("data", Collections.singletonMap("IsSyncDatabase", true));
                        wrapper.setValue("$id", (Object)orderLineUUID);
                        appWrite.setParameters(new MultivaluedHashMap());
                        wrapper.update();
                        appWrite.setOutputData(null);
                    }
                }));
            }
            catch (Exception e) {
                throw new AdempiereException(e.getMessage());
            }
            finally {
                appWrite.clearParameters();
            }
        }
    }
}

