/*
 * Decompiled with CFR 0.152.
 */
package org.spin.sfm.appwrite120.process;

import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MStore;
import org.spin.model.MADAppRegistration;
import org.spin.sfm.appwrite120.MBPartnerCollection;
import org.spin.sfm.appwrite120.MBPartnerLocationCollection;
import org.spin.sfm.appwrite120.MCurrencyCollection;
import org.spin.sfm.appwrite120.MDatabase;
import org.spin.sfm.appwrite120.MInvoiceCollection;
import org.spin.sfm.appwrite120.MIssueCollection;
import org.spin.sfm.appwrite120.MIssueTypeCollection;
import org.spin.sfm.appwrite120.MOrderCollection;
import org.spin.sfm.appwrite120.MPaymentCollection;
import org.spin.sfm.appwrite120.MPriceListCollection;
import org.spin.sfm.appwrite120.MProductCollection;
import org.spin.sfm.appwrite120.MProductPriceCollection;
import org.spin.sfm.appwrite120.MTaxCollection;
import org.spin.sfm.appwrite120.MVisitCollection;
import org.spin.sfm.appwrite120.MVisitScheduleLineCollection;
import org.spin.sfm.appwrite120.process.CreateStructureAbstract;
import org.spin.sfm.appwrite120.util.SalesForceApi;
import org.spin.util.support.AppSupportHandler;
import org.spin.util.support.IAppSupport;

public class CreateStructure
extends CreateStructureAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        if (this.getStoreId() == 0) {
            new AdempiereException("@FillMandatory@ @W_Store_ID@ ");
        }
        MStore webStore = MStore.get((Properties)this.getCtx(), (int)this.getStoreId());
        MADAppRegistration registration = MADAppRegistration.getById((Properties)this.getCtx(), (int)webStore.get_ValueAsInt("CacheServerProvider_ID"), (String)this.get_TrxName());
        if (registration.get_ID() > 0) {
            this.manageStructure(registration, webStore);
        }
        return "@OK@";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageStructure(MADAppRegistration appRegistration, MStore store) throws Exception {
        IAppSupport supportedApplication = AppSupportHandler.getInstance().getAppSupport(appRegistration);
        if (supportedApplication != null && SalesForceApi.class.isAssignableFrom(supportedApplication.getClass())) {
            SalesForceApi appWrite = (SalesForceApi)supportedApplication;
            try {
                MDatabase database = new MDatabase();
                database.withAppWriteApi(appWrite);
                database.create();
                appWrite.clearPaths();
                MCurrencyCollection currencyCollection = new MCurrencyCollection(appWrite, database.getIdentifier());
                MPriceListCollection priceListCollection = new MPriceListCollection(appWrite, database.getIdentifier());
                MProductPriceCollection productPriceCollection = new MProductPriceCollection(appWrite, database.getIdentifier());
                MBPartnerCollection bPartnerCollection = new MBPartnerCollection(appWrite, database.getIdentifier());
                MBPartnerLocationCollection bPartnerLocationCollection = new MBPartnerLocationCollection(appWrite, database.getIdentifier());
                MProductCollection productCollection = new MProductCollection(appWrite, database.getIdentifier());
                MVisitScheduleLineCollection visitScheduleLineCollection = new MVisitScheduleLineCollection(appWrite, database.getIdentifier());
                MOrderCollection orderCollection = new MOrderCollection(appWrite, database.getIdentifier());
                MTaxCollection taxCollection = new MTaxCollection(appWrite, database.getIdentifier());
                MInvoiceCollection invoiceCollection = new MInvoiceCollection(appWrite, database.getIdentifier());
                MPaymentCollection paymentCollection = new MPaymentCollection(appWrite, database.getIdentifier());
                MVisitCollection visitCollection = new MVisitCollection(appWrite, database.getIdentifier());
                MIssueCollection issueCollection = new MIssueCollection(appWrite, database.getIdentifier());
                MIssueTypeCollection issueTypeCollection = new MIssueTypeCollection(appWrite, database.getIdentifier());
                if (this.isCreateStructure()) {
                    currencyCollection.createCollection();
                    priceListCollection.createCollection();
                    productPriceCollection.createCollection();
                    bPartnerCollection.createCollection();
                    bPartnerLocationCollection.createCollection();
                    taxCollection.createCollection();
                    productCollection.createCollection();
                    visitScheduleLineCollection.createCollection();
                    orderCollection.createCollection();
                    invoiceCollection.createCollection();
                    paymentCollection.createCollection();
                    visitCollection.createCollection();
                    issueCollection.createCollection();
                    issueTypeCollection.createCollection();
                } else if (this.isReCreateStructure()) {
                    currencyCollection.dropCollection().createCollection();
                    priceListCollection.dropCollection().createCollection();
                    productPriceCollection.dropCollection().createCollection();
                    bPartnerCollection.dropCollection().createCollection();
                    bPartnerLocationCollection.dropCollection().createCollection();
                    taxCollection.dropCollection().createCollection();
                    productCollection.dropCollection().createCollection();
                    visitScheduleLineCollection.dropCollection().createCollection();
                    invoiceCollection.dropCollection().createCollection();
                    paymentCollection.dropCollection().createCollection();
                    visitCollection.dropCollection().createCollection();
                    issueCollection.dropCollection().createCollection();
                    issueTypeCollection.dropCollection().createCollection();
                } else if (this.isDropStructure()) {
                    currencyCollection.dropCollection();
                    priceListCollection.dropCollection();
                    productPriceCollection.dropCollection();
                    bPartnerCollection.dropCollection();
                    bPartnerLocationCollection.dropCollection();
                    taxCollection.dropCollection();
                    productCollection.dropCollection();
                    visitScheduleLineCollection.dropCollection();
                    orderCollection.dropCollection();
                    invoiceCollection.dropCollection();
                    paymentCollection.dropCollection();
                    visitCollection.dropCollection();
                    issueCollection.dropCollection();
                    issueTypeCollection.dropCollection();
                }
            }
            catch (Exception e) {
                this.addLog(e.getMessage());
            }
            finally {
                appWrite.clearParameters();
            }
        }
    }
}

