/*
 * Decompiled with CFR 0.152.
 */
package org.spin.sfm.appwrite120;

import java.util.HashMap;
import java.util.Optional;
import org.compiere.model.MTax;
import org.json.JSONObject;
import org.spin.appwrite120.utils.Document;

public class MTaxDocument
extends Document {
    public static MTaxDocument newInstance() {
        return new MTaxDocument();
    }

    public MTaxDocument withTax(MTax tax) {
        this.setDatabaseId("movil-e");
        this.setCollectionId("C_Tax");
        HashMap taxData = new HashMap();
        Optional.ofNullable(tax).ifPresent(currentTax -> {
            this.setId(currentTax.getUUID());
            taxData.put("C_Tax_ID", currentTax.get_ID());
            taxData.put("Name", currentTax.getName());
            taxData.put("Description", currentTax.getDescription());
            taxData.put("TaxIndicator", currentTax.getTaxIndicator());
            taxData.put("Rate", currentTax.getRate());
            taxData.put("IsDefault", currentTax.isDefault());
            this.setData(taxData);
        });
        return this;
    }

    public HashMap<String, Object> parseDataFromJson(JSONObject data) {
        HashMap item = super.parseDataFromJson(data);
        item.put("C_Tax_ID", data.getInt("C_Tax_ID"));
        item.put("Name", data.getString("Name"));
        item.put("Description", data.optString("Description", ""));
        item.put("TaxIndicator", data.optString("TaxIndicator", ""));
        item.put("Rate", data.optDouble("Rate", 0.0));
        item.put("IsDefault", data.optString("IsDefault", "N"));
        System.out.println(item);
        return item;
    }
}

