/*
 * Decompiled with CFR 0.152.
 */
package org.spin.sfm.appwrite120;

import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.json.JSONObject;
import org.spin.appwrite120.utils.Document;
import org.spin.sfm.appwrite120.MBPartnerCollection;
import org.spin.sfm.appwrite120.MProductPriceCollection;

public class MProductPriceDocument
extends Document {
    public static MProductPriceDocument newInstance() {
        return new MProductPriceDocument();
    }

    public MProductPriceDocument withProductPrice(MProductPrice productPrice) {
        this.setDatabaseId("movil-e");
        this.setCollectionId("M_ProductPrice");
        HashMap data = new HashMap();
        Optional.ofNullable(productPrice).ifPresent(currentProductPrice -> {
            this.setId(currentProductPrice.getUUID());
            data.put("M_ProductPrice_ID", currentProductPrice.get_ID());
            data.put("PriceList", Float.valueOf(currentProductPrice.getPriceList().floatValue()));
            data.put("PriceStd", Float.valueOf(currentProductPrice.getPriceStd().floatValue()));
            data.put("PriceLimit", Float.valueOf(currentProductPrice.getPriceLimit().floatValue()));
            Optional.ofNullable(MProduct.get((Properties)currentProductPrice.getCtx(), (int)currentProductPrice.getM_Product_ID())).ifPresent(product -> data.put(MProductPriceCollection.PRODUCT_UUID, product.getUUID()));
            Optional.ofNullable(MPriceList.get((Properties)currentProductPrice.getCtx(), (int)currentProductPrice.getM_PriceList_Version().getM_PriceList_ID(), (String)currentProductPrice.get_TrxName())).ifPresent(priceList -> data.put(MBPartnerCollection.PRICELIST_UUID, priceList.getUUID()));
            this.setData(data);
        });
        return this;
    }

    public HashMap<String, Object> parseDataFromJson(JSONObject data) {
        HashMap item = super.parseDataFromJson(data);
        item.put("M_ProductPrice_ID", data.getInt("M_ProductPrice_ID"));
        item.put("PriceList", Float.valueOf(data.getFloat("PriceList")));
        item.put("PriceStd", Float.valueOf(data.getFloat("PriceStd")));
        item.put("PriceLimit", Float.valueOf(data.getFloat("PriceLimit")));
        item.put(MProductPriceCollection.PRODUCT_UUID, data.getString(MProductPriceCollection.PRODUCT_UUID));
        item.put(MProductPriceCollection.PRICELIST_UUID, data.getString(MProductPriceCollection.PRICELIST_UUID));
        System.out.println(item);
        return item;
    }
}

