/*
 * Decompiled with CFR 0.152.
 */
package org.spin.sfm.appwrite120;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MProduct;
import org.compiere.model.MTax;
import org.json.JSONArray;
import org.json.JSONObject;
import org.spin.appwrite120.utils.Document;
import org.spin.sfm.appwrite120.MProductCollection;

public class MProductDocument
extends Document {
    public static MProductDocument newInstance() {
        return new MProductDocument();
    }

    public MProductDocument withProduct(MProduct product) {
        this.setDatabaseId("movil-e");
        this.setCollectionId("M_Product");
        List<MTax> allTaxes = Arrays.asList(MTax.getAll((Properties)product.getCtx()));
        HashMap data = new HashMap();
        Optional.ofNullable(product).ifPresent(currentProduct -> {
            this.setId(currentProduct.getUUID());
            data.put("M_Product_ID", currentProduct.get_ID());
            data.put("Value", currentProduct.getValue());
            data.put("Name", currentProduct.getName());
            data.put("SKU", currentProduct.getSKU());
            data.put("UPC", currentProduct.getUPC());
            data.put("Description", currentProduct.getDescription());
            JSONArray taxArray = new JSONArray();
            allTaxes.stream().filter(tax -> tax.getC_TaxCategory_ID() == currentProduct.getC_TaxCategory_ID()).forEach(tax -> taxArray.put((Object)tax.getUUID()));
            data.put(MProductCollection.TAX_UUID_LIST, taxArray);
            this.setData(data);
        });
        return this;
    }

    public HashMap<String, Object> parseDataFromJson(JSONObject data) {
        HashMap item = super.parseDataFromJson(data);
        item.put("M_Product_ID", data.getInt("M_Product_ID"));
        item.put("Value", data.getString("Value"));
        item.put("Name", data.getString("Name"));
        item.put("SKU", data.optString("SKU", ""));
        item.put("UPC", data.optString("UPC", ""));
        item.put("Description", data.optString("Description", ""));
        System.out.println(item);
        return item;
    }
}

