/*
 * Decompiled with CFR 0.152.
 */
package org.spin.sfm.appwrite120;

import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MCurrency;
import org.compiere.model.MPriceList;
import org.json.JSONObject;
import org.spin.appwrite120.utils.Document;
import org.spin.sfm.appwrite120.MPriceListCollection;

public class MPriceListDocument
extends Document {
    public static MPriceListDocument newInstance() {
        return new MPriceListDocument();
    }

    public MPriceListDocument withPriceList(MPriceList priceList) {
        this.setDatabaseId("movil-e");
        this.setCollectionId("M_PriceList");
        HashMap priceListData = new HashMap();
        Optional.ofNullable(priceList).ifPresent(currentpriceList -> {
            this.setId(currentpriceList.getUUID());
            priceListData.put("M_PriceList_ID", currentpriceList.get_ID());
            priceListData.put("Name", currentpriceList.getName());
            priceListData.put("Description", currentpriceList.getDescription());
            priceListData.put("PricePrecision", currentpriceList.getPricePrecision());
            Optional.ofNullable(MCurrency.get((Properties)currentpriceList.getCtx(), (int)currentpriceList.getC_Currency_ID())).ifPresent(currency -> priceListData.put(MPriceListCollection.CURRENCY_UUID, currency.getUUID()));
            this.setData(priceListData);
        });
        return this;
    }

    public HashMap<String, Object> parseDataFromJson(JSONObject data) {
        HashMap item = super.parseDataFromJson(data);
        item.put("M_PriceList_ID", data.getInt("M_PriceList_ID"));
        item.put("Name", data.getString("Name"));
        item.put("Description", data.optString("Description", ""));
        item.put("PricePrecision", data.getInt("PricePrecision"));
        item.put(MPriceListCollection.CURRENCY_UUID, data.getString(MPriceListCollection.CURRENCY_UUID));
        System.out.println(item);
        return item;
    }
}

