/*
 * Decompiled with CFR 0.152.
 */
package org.spin.sfm.appwrite120;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import org.compiere.model.MOrder;
import org.json.JSONException;
import org.json.JSONObject;
import org.spin.appwrite120.utils.AppWrite;
import org.spin.appwrite120.utils.Document;
import org.spin.appwrite120.utils.IAppWriteData;
import org.spin.sfm.appwrite120.MOrderCollection;

public class MOrderDocument
extends Document {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");

    public static MOrderDocument newInstance() {
        return new MOrderDocument();
    }

    public IAppWriteData withAppWriteApi(AppWrite api) {
        String filter = "equal(".concat("IsSyncDatabase").concat(",false)");
        api.withParameter("queries[]", (Object)filter);
        return super.withAppWriteApi(api);
    }

    public MOrderDocument withOrder(MOrder order) {
        this.setDatabaseId("movil-e");
        this.setCollectionId("C_Order");
        return this;
    }

    public HashMap<String, Object> parseDataFromJson(JSONObject data) {
        HashMap item = super.parseDataFromJson(data);
        try {
            item.put(MOrderCollection.ORDERLINE_UUID, data.getString("$id"));
            item.put("C_OrderLine_ID", data.getInt("C_OrderLine_ID"));
            item.put(MOrderCollection.PRODUCT_UUID, data.getString(MOrderCollection.PRODUCT_UUID));
            item.put("QtyEntered", data.getBigDecimal("QtyEntered"));
            item.put("PriceEntered", data.getBigDecimal("PriceEntered"));
            item.put("LineNetAmt", data.getBigDecimal("LineNetAmt"));
            item.put(MOrderCollection.ORDER_UUID, data.getString(MOrderCollection.ORDER_UUID));
            item.put("DocumentNo", data.getString("DocumentNo"));
            item.put(MOrderCollection.BPARTNER_UUID, data.getString(MOrderCollection.BPARTNER_UUID));
            item.put(MOrderCollection.BPARTNERLOCATION_UUID, data.getString(MOrderCollection.BPARTNERLOCATION_UUID));
            item.put(MOrderCollection.BILLLOCATION_UUID, data.getString(MOrderCollection.BILLLOCATION_UUID));
            item.put(MOrderCollection.CURRENCY_UUID, data.getString(MOrderCollection.CURRENCY_UUID));
            item.put(MOrderCollection.PRICELIST_UUID, data.getString(MOrderCollection.PRICELIST_UUID));
            item.put(MOrderCollection.VISITSCHEDULELINE_UUID, data.getString(MOrderCollection.VISITSCHEDULELINE_UUID));
            item.put("DateOrdered", new Timestamp(DATE_FORMAT.parse(data.getString("DateOrdered")).getTime()));
            item.put("Description", data.optString("Description", ""));
            item.put("POReference", data.optString("POReference", ""));
            item.put("TotalLines", data.getBigDecimal("TotalLines"));
            item.put("GrandTotal", data.getBigDecimal("GrandTotal"));
            item.put("IsPrepayment", data.getBoolean("IsPrepayment"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return item;
    }
}

