/*
 * Decompiled with CFR 0.152.
 */
package org.spin.sfm.appwrite120;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.compiere.model.MBPartner;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.spin.appwrite120.utils.Document;
import org.spin.sfm.appwrite120.MInvoiceCollection;

public class MInvoiceDocument
extends Document {
    private static CCache<Integer, MPaymentTerm> s_cache = new CCache("C_PaymentTerm", 40, 5);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");

    public static MInvoiceDocument newInstance() {
        return new MInvoiceDocument();
    }

    public MInvoiceDocument withInvoice(MInvoice invoice) {
        this.setDatabaseId("movil-e");
        this.setCollectionId("C_Invoice");
        HashMap data = new HashMap();
        Optional.ofNullable(invoice).ifPresent(currentInvoice -> {
            JSONArray permission = new JSONArray();
            this.setId(currentInvoice.getUUID());
            data.put("DocumentNo", currentInvoice.getDocumentNo());
            data.put("Description", currentInvoice.getDescription());
            data.put("DateInvoiced", currentInvoice.getDateInvoiced());
            data.put("TotalLines", currentInvoice.getTotalLines());
            data.put("GrandTotal", currentInvoice.getGrandTotal());
            data.put("OpenAmt", currentInvoice.getOpenAmt());
            data.put(MInvoiceCollection.BPARTNER_UUID, MBPartner.get((Properties)currentInvoice.getCtx(), (int)currentInvoice.getC_BPartner_ID()).getUUID());
            data.put(MInvoiceCollection.CURRENCY_UUID, MCurrency.get((Properties)currentInvoice.getCtx(), (int)currentInvoice.getC_Currency_ID()).getUUID());
            data.put("PaidAmt", Env.ZERO);
            data.put("TaxAmt", currentInvoice.getGrandTotal().subtract(currentInvoice.getTotalLines()));
            AtomicReference<Object> invoiceDueDate = new AtomicReference<Object>(null);
            Optional.ofNullable(MInvoiceDocument.getPaymentTerm(currentInvoice.getCtx(), currentInvoice.getC_PaymentTerm_ID(), currentInvoice.get_TrxName())).ifPresent(paymentTerm -> {
                if (paymentTerm.isDueFixed()) {
                    Timestamp firstDay = TimeUtil.getMonthFirstDay((Timestamp)currentInvoice.getDateInvoiced());
                    int daysNumber = TimeUtil.getDaysBetween((Timestamp)firstDay, (Timestamp)currentInvoice.getDateInvoiced(), (boolean)true, (int[])new int[0]);
                    Timestamp dueDate = TimeUtil.addDays((Timestamp)firstDay, (int)(paymentTerm.getFixMonthDay() - 1));
                    dueDate = TimeUtil.addMonths((Timestamp)dueDate, (int)paymentTerm.getFixMonthOffset());
                    if (daysNumber > paymentTerm.getFixMonthCutoff()) {
                        dueDate = TimeUtil.addMonths((Timestamp)dueDate, (int)1);
                    }
                    invoiceDueDate.set(dueDate);
                } else {
                    invoiceDueDate.set(TimeUtil.addDays((Timestamp)currentInvoice.getDateInvoiced(), (int)paymentTerm.getNetDays()));
                }
            });
            Optional.ofNullable(invoiceDueDate.get()).ifPresent(dueDate -> data.put("DueDate", dueDate));
            this.getSalesRepForBussinessPartner(currentInvoice.getC_BPartner_ID()).forEach(salesRep -> permission.put((Object)"read(\"user:".concat(salesRep.getUUID()).concat("\")")));
            this.setPermisions(permission);
            this.setData(data);
        });
        return this;
    }

    private List<MUser> getSalesRepForBussinessPartner(int bPartnerId) {
        String whereClause = "EXISTS (SELECT 1 FROM SFM_VisitSchedule vs INNER JOIN SFM_VisitScheduleLine vsl ON (vs.SFM_VisitSchedule_ID = vsl.SFM_VisitSchedule_ID) WHERE vs.SalesRep_ID = AD_User.AD_User_ID AND vsl.C_BPartner_ID = ? )";
        return new Query(Env.getCtx(), "AD_User", whereClause, null).setParameters(new Object[]{bPartnerId}).list();
    }

    public HashMap<String, Object> parseDataFromJson(JSONObject data) {
        HashMap item = super.parseDataFromJson(data);
        try {
            item.put("DocumentNo", data.getString("DocumentNo"));
            item.put("Description", data.optString("Description", ""));
            item.put("DateInvoiced", new Timestamp(DATE_FORMAT.parse(data.getString("DateInvoiced")).getTime()));
            item.put("TotalLines", data.getBigDecimal("TotalLines"));
            item.put("GrandTotal", data.getBigDecimal("GrandTotal"));
            item.put("OpenAmt", data.getBigDecimal("OpenAmt"));
            item.put(MInvoiceCollection.BPARTNER_UUID, data.getString(MInvoiceCollection.BPARTNER_UUID));
            item.put(MInvoiceCollection.CURRENCY_UUID, data.getString(MInvoiceCollection.CURRENCY_UUID));
            item.put("PaidAmt", data.getBigDecimal("OpenAmt"));
            item.put("TaxAmt", data.getBigDecimal("TaxAmt"));
            item.put("DueDate", new Timestamp(DATE_FORMAT.parse(data.getString("DueDate")).getTime()));
        }
        catch (ParseException | JSONException e) {
            e.printStackTrace();
        }
        return item;
    }

    public static MPaymentTerm getPaymentTerm(Properties ctx, int C_PaymentTerm_ID, String trxName) {
        if (C_PaymentTerm_ID <= 0) {
            return null;
        }
        Integer key = new Integer(C_PaymentTerm_ID);
        MPaymentTerm retValue = (MPaymentTerm)s_cache.get((Object)key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MPaymentTerm(ctx, C_PaymentTerm_ID, trxName);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }
}

