/*
 * Decompiled with CFR 0.152.
 */
package org.spin.sfm.appwrite120;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLocation;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.json.JSONArray;
import org.json.JSONObject;
import org.spin.appwrite120.utils.Document;
import org.spin.sfm.appwrite120.MBPartnerLocationCollection;

public class MBPartnerLocationDocument
extends Document {
    public static MBPartnerLocationDocument newInstance() {
        return new MBPartnerLocationDocument();
    }

    public MBPartnerLocationDocument withBPartnerLocation(MBPartnerLocation bPartnerLocation) {
        this.setDatabaseId("movil-e");
        this.setCollectionId("C_BPartner_Location");
        HashMap data = new HashMap();
        Optional.ofNullable(bPartnerLocation).ifPresent(currentbPartnerLocation -> {
            JSONArray permission = new JSONArray();
            this.setId(currentbPartnerLocation.getUUID());
            data.put("C_BPartner_Location_ID", currentbPartnerLocation.get_ID());
            data.put("IsBillTo", currentbPartnerLocation.isBillTo());
            data.put("IsShipTo", currentbPartnerLocation.isShipTo());
            data.put("Phone", currentbPartnerLocation.getPhone());
            data.put("Phone2", currentbPartnerLocation.getPhone2());
            data.put("Name", currentbPartnerLocation.getName());
            Optional.ofNullable(MLocation.get((Properties)bPartnerLocation.getCtx(), (int)bPartnerLocation.getC_Location_ID(), (String)bPartnerLocation.get_TrxName())).ifPresent(location -> {
                data.put("Description", location.toString());
                data.put("Latitude", location.get_Value("Latitude"));
                data.put("Longitude", location.get_Value("Longitude"));
            });
            Optional.ofNullable(MBPartner.get((Properties)currentbPartnerLocation.getCtx(), (int)currentbPartnerLocation.getC_BPartner_ID())).ifPresent(bPartner -> data.put(MBPartnerLocationCollection.BPARTNER_UUID, bPartner.getUUID()));
            this.getSalesRepForBussinessPartnerLocation(currentbPartnerLocation.get_ID()).forEach(salesRep -> permission.put((Object)"read(\"user:".concat(salesRep.getUUID()).concat("\")")));
            this.setPermisions(permission);
            this.setData(data);
        });
        return this;
    }

    private List<MUser> getSalesRepForBussinessPartnerLocation(int bPartnerLocationId) {
        String whereClause = "EXISTS (SELECT 1 FROM SFM_VisitSchedule vs INNER JOIN SFM_VisitScheduleLine vsl ON (vs.SFM_VisitSchedule_ID = vsl.SFM_VisitSchedule_ID) WHERE vs.SalesRep_ID = AD_User.AD_User_ID AND ? IN (vsl.C_BPartner_Location_ID, vsl.Bill_Location_ID) )";
        return new Query(Env.getCtx(), "AD_User", whereClause, null).setParameters(new Object[]{bPartnerLocationId}).list();
    }

    public HashMap<String, Object> parseDataFromJson(JSONObject data) {
        HashMap item = super.parseDataFromJson(data);
        item.put("C_BPartner_Location_ID", data.getInt("C_BPartner_Location_ID"));
        item.put("IsBillTo", data.getBoolean("IsBillTo"));
        item.put("IsShipTo", data.getBoolean("IsShipTo"));
        item.put("Phone", data.optString("Phone"));
        item.put("Phone2", data.optString("Phone2"));
        item.put("Name", data.optString("Name"));
        item.put(MBPartnerLocationCollection.BPARTNER_UUID, data.getString(MBPartnerLocationCollection.BPARTNER_UUID));
        System.out.println(item);
        return item;
    }
}

