/*
 * Decompiled with CFR 0.152.
 */
package org.spin.sfm.appwrite015;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MPriceList;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.json.JSONArray;
import org.json.JSONObject;
import org.spin.appwrite015.utils.Document;
import org.spin.sfm.appwrite015.MVisitScheduleLineCollection;
import org.spin.sfm.model.MSFMVisitSchedule;
import org.spin.sfm.model.MSFMVisitScheduleLine;

public class MVisitScheduleLineDocument
extends Document {
    public static MVisitScheduleLineDocument newInstance() {
        return new MVisitScheduleLineDocument();
    }

    public MVisitScheduleLineDocument withVisitScheduleLine(MSFMVisitScheduleLine visitScheduleLine) {
        HashMap cacheBPlocations = new HashMap();
        HashMap cachePriceLists = new HashMap();
        this.setDatabaseId("movil-e");
        this.setCollectionId("SFM_VisitScheduleLine");
        this.setPermisions("document");
        HashMap data = new HashMap();
        Optional.ofNullable(visitScheduleLine).ifPresent(currentVisitScheduleLine -> Optional.ofNullable(MSFMVisitSchedule.getById(currentVisitScheduleLine.getCtx(), currentVisitScheduleLine.getSFM_VisitSchedule_ID(), currentVisitScheduleLine.get_TrxName())).ifPresent(currentVisitSchedule -> Optional.ofNullable(MBPartner.get((Properties)currentVisitSchedule.getCtx(), (int)currentVisitScheduleLine.getC_BPartner_ID())).ifPresent(currentBPartner -> {
            JSONArray permission = new JSONArray();
            this.setId(currentVisitScheduleLine.getUUID());
            data.put("SFM_VisitScheduleLine_ID", currentVisitScheduleLine.get_ID());
            data.put("Value", currentVisitSchedule.getValue());
            data.put("Name", currentBPartner.getName());
            data.put("Description", Optional.ofNullable(currentVisitScheduleLine.getDescription()).orElse(currentVisitSchedule.getDescription()));
            data.put("OnMonday", currentVisitScheduleLine.isOnMonday());
            data.put("OnTuesday", currentVisitScheduleLine.isOnTuesday());
            data.put("OnWednesday", currentVisitScheduleLine.isOnWednesday());
            data.put("OnThursday", currentVisitScheduleLine.isOnThursday());
            data.put("OnFriday", currentVisitScheduleLine.isOnFriday());
            data.put("OnSaturday", currentVisitScheduleLine.isOnSaturday());
            data.put("OnSunday", currentVisitScheduleLine.isOnSunday());
            data.put("ValidFrom", this.castTimestamp(Optional.ofNullable(currentVisitScheduleLine.getValidFrom()).orElse(currentVisitSchedule.getValidFrom())));
            data.put("StartTime", this.castTimestamp(currentVisitScheduleLine.getStartTime()));
            data.put("EndTime", this.castTimestamp(currentVisitScheduleLine.getEndTime()));
            data.put(MVisitScheduleLineCollection.BPARTNER_UUID, currentBPartner.getUUID());
            Map currentBPLocations = Optional.ofNullable(cacheBPlocations.get(currentBPartner.get_ID())).orElseGet(() -> {
                HashMap locations = new HashMap();
                Arrays.asList(currentBPartner.getLocations(false)).stream().forEach(location -> locations.put(location.get_ID(), location));
                return locations;
            });
            cacheBPlocations.put(currentBPartner.get_ID(), currentBPLocations);
            Optional.ofNullable(currentBPLocations.get(currentVisitScheduleLine.getC_BPartner_Location_ID())).ifPresent(location -> data.put(MVisitScheduleLineCollection.BPARTNERLOCATION_UUID, location.getUUID()));
            Optional.ofNullable(currentBPLocations.get(currentVisitScheduleLine.getBill_Location_ID())).ifPresent(location -> data.put(MVisitScheduleLineCollection.BILLLOCATION_UUID, location.getUUID()));
            JSONArray priceListsArray = new JSONArray();
            List priceLists = Optional.ofNullable(cachePriceLists.get(currentVisitScheduleLine.getSFM_VisitSchedule_ID())).orElseGet(() -> {
                ArrayList visitPriceLists = new ArrayList();
                new Query(Env.getCtx(), "SFM_VSPriceList", "SFM_VisitSchedule_ID".concat("=?"), null).setParameters(new Object[]{currentVisitScheduleLine.getSFM_VisitSchedule_ID()}).setOnlyActiveRecords(true).list().forEach(visitPriceList -> {
                    Optional<MPriceList> maybePriceList = Optional.ofNullable(MPriceList.get((Properties)Env.getCtx(), (int)visitPriceList.get_ValueAsInt("M_PriceList_ID"), null));
                    maybePriceList.ifPresent(priceList -> visitPriceLists.add(priceList.getUUID()));
                });
                return visitPriceLists;
            });
            cachePriceLists.put(currentVisitScheduleLine.getSFM_VisitSchedule_ID(), priceLists);
            priceLists.forEach(priceListUUID -> priceListsArray.put((Object)priceListsArray));
            data.put(MVisitScheduleLineCollection.PRICELIST_UUID_LIST, priceLists);
            data.put("FrequencyType", currentVisitScheduleLine.getFrequencyType());
            data.put("SeqNo", currentVisitScheduleLine.getSeqNo());
            Optional.ofNullable(MUser.get((Properties)Env.getCtx(), (int)currentVisitSchedule.getSalesRep_ID())).ifPresent(salesRep -> permission.put((Object)"user:".concat(salesRep.getUUID())));
            this.setRead(permission);
            this.setData(data);
        })));
        return this;
    }

    public HashMap<String, Object> parseDataFromJson(JSONObject data) {
        HashMap item = super.parseDataFromJson(data);
        item.put("SFM_VisitScheduleLine_ID", data.getInt("SFM_VisitScheduleLine_ID"));
        item.put("Value", data.optString("Value", ""));
        item.put("Name", data.optString("Name", ""));
        item.put("Description", data.optString("Description", ""));
        item.put("OnMonday", data.getBoolean("OnMonday"));
        item.put("OnTuesday", data.getBoolean("OnTuesday"));
        item.put("OnWednesday", data.getBoolean("OnWednesday"));
        item.put("OnThursday", data.getBoolean("OnThursday"));
        item.put("OnFriday", data.getBoolean("OnFriday"));
        item.put("OnSaturday", data.getBoolean("OnSaturday"));
        item.put("OnSunday", data.getBoolean("OnSunday"));
        item.put("ValidFrom", data.optLong("ValidFrom", Long.parseLong("0")));
        item.put("StartTime", data.optLong("StartTime", Long.parseLong("0")));
        item.put("EndTime", data.optLong("EndTime", Long.parseLong("0")));
        item.put(MVisitScheduleLineCollection.BPARTNER_UUID, data.optString(MVisitScheduleLineCollection.BPARTNER_UUID, ""));
        item.put(MVisitScheduleLineCollection.BPARTNERLOCATION_UUID, data.optString(MVisitScheduleLineCollection.BPARTNERLOCATION_UUID, ""));
        item.put(MVisitScheduleLineCollection.BILLLOCATION_UUID, data.optString(MVisitScheduleLineCollection.BILLLOCATION_UUID, ""));
        item.put("FrequencyType", data.optString("FrequencyType", ""));
        item.put("SeqNo", data.optInt("SeqNo", 0));
        System.out.println(item);
        return item;
    }

    private long castTimestamp(Timestamp dateTime) {
        long timeLong = 0L;
        if (dateTime != null) {
            timeLong = dateTime.getTime();
        }
        return timeLong / 1000L;
    }
}

