/*
 * Decompiled with CFR 0.152.
 */
package org.spin.sfm.appwrite015;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MBPartner;
import org.compiere.model.MPriceList;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.json.JSONArray;
import org.json.JSONObject;
import org.spin.appwrite015.utils.Document;
import org.spin.sfm.appwrite015.MBPartnerCollection;

public class MBPartnerDocument
extends Document {
    public static MBPartnerDocument newInstance() {
        return new MBPartnerDocument();
    }

    public MBPartnerDocument withBPartner(MBPartner bPartner) {
        this.setDatabaseId("movil-e");
        this.setCollectionId("C_BPartner");
        this.setPermisions("document");
        HashMap data = new HashMap();
        Optional.ofNullable(bPartner).ifPresent(currentbPartner -> {
            JSONArray permission = new JSONArray();
            this.setId(currentbPartner.getUUID());
            data.put("C_BPartner_ID", currentbPartner.get_ID());
            data.put("Value", currentbPartner.getValue());
            data.put("Name", currentbPartner.getName());
            data.put("Name2", currentbPartner.getName2());
            data.put("Description", currentbPartner.getDescription());
            data.put("TaxID", currentbPartner.getTaxID());
            Optional.ofNullable(MPriceList.get((Properties)currentbPartner.getCtx(), (int)currentbPartner.getM_PriceList_ID(), (String)currentbPartner.get_TrxName())).ifPresent(priceList -> data.put(MBPartnerCollection.PRICELIST_UUID, priceList.getUUID()));
            this.getSalesRepForBussinessPartner(currentbPartner.get_ID()).forEach(salesRep -> permission.put((Object)"user:".concat(salesRep.getUUID())));
            this.setRead(permission);
            this.setData(data);
        });
        return this;
    }

    private List<MUser> getSalesRepForBussinessPartner(int bPartnerId) {
        String whereClause = "EXISTS (SELECT 1 FROM SFM_VisitSchedule vs INNER JOIN SFM_VisitScheduleLine vsl ON (vs.SFM_VisitSchedule_ID = vsl.SFM_VisitSchedule_ID) WHERE vs.SalesRep_ID = AD_User.AD_User_ID AND vsl.C_BPartner_ID = ? )";
        return new Query(Env.getCtx(), "AD_User", whereClause, null).setParameters(new Object[]{bPartnerId}).list();
    }

    public HashMap<String, Object> parseDataFromJson(JSONObject data) {
        HashMap item = super.parseDataFromJson(data);
        item.put("C_BPartner_ID", data.getInt("C_BPartner_ID"));
        item.put("Value", data.getString("Value"));
        item.put("Name", data.getString("Name"));
        item.put("Name2", data.optString("Name2", ""));
        item.put("Description", data.optString("Description", ""));
        item.put("TaxID", data.optString("TaxID", ""));
        item.put(MBPartnerCollection.PRICELIST_UUID, data.optString(MBPartnerCollection.PRICELIST_UUID, ""));
        System.out.println(item);
        return item;
    }
}

