/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.process;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.compiere.model.Query;
import org.compiere.util.Trx;
import org.spin.queue.model.MADQueue;
import org.spin.queue.process.FlushSystemQueueAbstract;
import org.spin.queue.util.QueueLoader;
import org.spin.queue.util.QueueManager;

public class FlushSystemQueue
extends FlushSystemQueueAbstract {
    private AtomicInteger counter = new AtomicInteger();
    private AtomicInteger errors = new AtomicInteger();

    protected String doIt() throws Exception {
        if (this.getBatchsToProcess() > 0 && this.getRecordsByBatch() > 0) {
            StringBuffer whereClause = new StringBuffer("Processed").append(" = 'N'");
            ArrayList<Integer> parameters = new ArrayList<Integer>();
            if (this.getQueueTypeId() > 0) {
                whereClause.append(" AND ").append("AD_QueueType_ID").append(" = ?");
                parameters.add(this.getQueueTypeId());
            }
            Trx.run(transactionName -> IntStream.range(0, this.getBatchsToProcess()).forEach(page -> new Query(this.getCtx(), "AD_Queue", whereClause.toString(), transactionName).setParameters(parameters).setClient_ID().setLimit(this.getRecordsByBatch()).setOrderBy("Created").getIDsAsList().forEach(queueId -> {
                MADQueue queueToProcess = new MADQueue(this.getCtx(), (int)queueId, transactionName);
                QueueManager queueManager = QueueLoader.getInstance().getQueueManager(queueToProcess.getAD_QueueType_ID()).withContext(this.getCtx()).withTransactionName(transactionName);
                try {
                    queueManager.process(queueToProcess, this.isDeleteAfterProcess());
                    this.counter.incrementAndGet();
                }
                catch (Exception e) {
                    this.errors.incrementAndGet();
                    this.addLog("@AD_Queue_ID@: [" + queueToProcess + "]: " + e.getLocalizedMessage());
                    this.log.severe(queueToProcess + ": " + e.getLocalizedMessage());
                }
            })));
        }
        return "@Processed@: " + this.counter + " @Errors@: " + this.errors;
    }
}

