/*
 * Decompiled with CFR 0.152.
 */
package org.spin.queue.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.spin.queue.model.X_AD_QueueType;

public class MADQueueType
extends X_AD_QueueType {
    private static final long serialVersionUID = -1171525387615789574L;
    private static CCache<Integer, MADQueueType> queueTypeCacheIds = new CCache("AD_QueueType", 30);
    private static CCache<String, MADQueueType> queueTypeCacheValues = new CCache("AD_QueueType", 30);

    public MADQueueType(Properties ctx, int queueTypeId, String trxName) {
        super(ctx, queueTypeId, trxName);
    }

    public MADQueueType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MADQueueType getById(Properties ctx, int definitionId, String trxName) {
        if (definitionId <= 0) {
            return null;
        }
        MADQueueType definition = (MADQueueType)queueTypeCacheIds.get((Object)definitionId);
        if (definition != null && definition.get_ID() > 0) {
            return definition;
        }
        definition = (MADQueueType)new Query(ctx, "AD_QueueType", "AD_QueueType_ID=?", trxName).setParameters(new Object[]{definitionId}).first();
        if (definition != null && definition.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + definition.getValue();
            queueTypeCacheValues.put((Object)key, (Object)definition);
            queueTypeCacheIds.put((Object)definition.get_ID(), (Object)definition);
        }
        return definition;
    }

    public static MADQueueType getByQueueType(Properties ctx, String queueType, String trxName) {
        int clientId;
        String key;
        MADQueueType definition;
        if (queueType == null) {
            return null;
        }
        if (queueTypeCacheValues.size() == 0) {
            MADQueueType.getAll(ctx, true, trxName);
        }
        if ((definition = (MADQueueType)queueTypeCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + queueType))) != null && definition.get_ID() > 0) {
            return definition;
        }
        definition = (MADQueueType)new Query(ctx, "AD_QueueType", "QueueType=? AND AD_Client_ID IN(0, ?)", trxName).setParameters(new Object[]{queueType, clientId}).setOrderBy("AD_Client_ID DESC").first();
        if (definition != null && definition.get_ID() > 0) {
            queueTypeCacheValues.put((Object)key, (Object)definition);
            queueTypeCacheIds.put((Object)definition.get_ID(), (Object)definition);
        }
        return definition;
    }

    public static List<MADQueueType> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || queueTypeCacheIds.size() > 0) {
            List definitionList = new Query(Env.getCtx(), "AD_QueueType", null, trxName).setClient_ID().setOrderBy("Name").list();
            definitionList.stream().forEach(definition -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + definition.getValue();
                queueTypeCacheIds.put((Object)definition.getAD_QueueType_ID(), definition);
                queueTypeCacheValues.put((Object)key, definition);
            });
            return definitionList;
        }
        List<MADQueueType> definitionList = queueTypeCacheIds.entrySet().stream().map(activity -> (MADQueueType)activity.getValue()).collect(Collectors.toList());
        return definitionList;
    }

    @Override
    public String toString() {
        return "MADQueueType [getAD_QueueType_ID()=" + this.getAD_QueueType_ID() + ", getClassname()=" + this.getClassname() + ", getName()=" + this.getName() + ", getQueueType()=" + this.getQueueType() + ", getValue()=" + this.getValue() + "]";
    }
}

