/*
 * Decompiled with CFR 0.152.
 */
package org.spin.restapi.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import org.compiere.util.CLogger;
import org.glassfish.jersey.client.ClientConfig;
import org.json.JSONObject;

public abstract class RestAPIAbstract {
    private String url = "";
    private List<String> paths = new ArrayList<String>();
    private MultivaluedHashMap<String, Object> parameters = new MultivaluedHashMap();
    private MediaType request = null;
    private MultivaluedHashMap<String, Object> headers = new MultivaluedHashMap();
    public static final String RequestType_GET = "GET";
    public static final String RequestType_POST = "POST";
    public static final String RequestType_PUT = "PUT";
    public static final String RequestType_DELETE = "DELETE";
    public static final String RequestType_PATCH = "PATCH";
    public static final String RequestError = "error";
    public static final String RequestErrorCode = "error_code";
    public static final String RequestErrorPhrase = "error_phrase";
    public static final String RequestResponse = "response";
    public static final String RequestResponseCode = "response_code";
    public static final String RequestResponsePhrase = "response_phrase";
    private String requestType = "GET";
    private JSONObject inputData = new JSONObject();
    private JSONObject outputData = null;
    private static final CLogger log = CLogger.getCLogger(RestAPIAbstract.class);

    public RestAPIAbstract withURL(String url) {
        this.url = url;
        return this;
    }

    public RestAPIAbstract withPath(String path) {
        this.paths.add(path);
        return this;
    }

    public RestAPIAbstract withParameter(String key, Object value) {
        this.parameters.add((Object)key, value);
        return this;
    }

    public RestAPIAbstract withRequest(MediaType request) {
        this.request = request;
        return this;
    }

    public RestAPIAbstract withHeader(String key, Object value) {
        this.headers.add((Object)key, value);
        return this;
    }

    public RestAPIAbstract withDataToSend(String key, Object value) {
        this.getInputData().put(key, value);
        return this;
    }

    public RestAPIAbstract withRequestType(String requestType) {
        this.requestType = requestType;
        return this;
    }

    public WebTarget getWebTarget() {
        Client client = (Client)ClientBuilder.newClient((Configuration)new ClientConfig()).property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
        AtomicReference webTarget = new AtomicReference();
        Optional<String> maybeURL = Optional.ofNullable(this.url);
        maybeURL.ifPresent(webURL -> {
            webTarget.set(client.target(webURL));
            Optional<List<String>> maybeURLPaths = Optional.ofNullable(this.paths);
            maybeURLPaths.ifPresent(urlPaths -> urlPaths.forEach(path -> webTarget.set(((WebTarget)webTarget.get()).path(path))));
            Optional<MultivaluedHashMap<String, Object>> maybeWebParams = Optional.ofNullable(this.parameters);
            maybeWebParams.ifPresent(webParams -> webParams.entrySet().forEach(param -> ((List)param.getValue()).forEach(value -> webTarget.set(((WebTarget)webTarget.get()).queryParam((String)param.getKey(), new Object[]{value})))));
        });
        return (WebTarget)webTarget.get();
    }

    public Response getWebResponse() {
        Optional<WebTarget> maybeWebTarget = Optional.ofNullable(this.getWebTarget());
        AtomicReference<Object> response = new AtomicReference<Object>(null);
        maybeWebTarget.ifPresent(webTarget -> {
            AtomicReference<Object> invocationBuilder = new AtomicReference<Object>(null);
            Optional<MediaType> maybeRequest = Optional.ofNullable(this.request);
            maybeRequest.ifPresent(webRequest -> invocationBuilder.set(webTarget.request(new MediaType[]{webRequest}).headers(this.headers)));
            invocationBuilder.set(Optional.ofNullable(invocationBuilder.get()).orElse(webTarget.request().headers(this.headers)));
            Optional<Object> maybeBuilder = Optional.ofNullable(invocationBuilder.get());
            maybeBuilder.ifPresent(builder -> {
                if (this.requestType.equals(RequestType_GET)) {
                    response.set(builder.get());
                } else if (this.requestType.equals(RequestType_POST)) {
                    response.set(builder.post(Entity.json((Object)this.getInputData().toString())));
                } else if (this.requestType.equals(RequestType_PUT)) {
                    response.set(builder.put(Entity.json((Object)this.getInputData().toString())));
                } else if (this.requestType.equals(RequestType_PATCH)) {
                    response.set(builder.method(RequestType_PATCH, Entity.json((Object)this.getInputData().toString())));
                } else if (this.requestType.equals(RequestType_DELETE)) {
                    response.set(builder.delete());
                }
            });
        });
        return response.get();
    }

    public void call() {
        Optional.ofNullable(this.getWebResponse()).ifPresent(response -> {
            if (response.getStatus() == 200 || response.getStatus() == 201) {
                Optional<Object> maybeJson = Optional.ofNullable(response.readEntity(String.class));
                maybeJson.ifPresent(jsonString -> this.setOutputData(new JSONObject(jsonString)));
            } else if (response.getStatus() == 204) {
                JSONObject responseData = new JSONObject();
                Optional<Response.StatusType> maybeStatusInfo = Optional.ofNullable(response.getStatusInfo());
                maybeStatusInfo.ifPresent(statusInfo -> {
                    Optional<Response.Status.Family> maybeFamily = Optional.ofNullable(statusInfo.getFamily());
                    maybeFamily.ifPresent(family -> {
                        responseData.put(RequestResponse, (Object)family.toString());
                        responseData.put(RequestResponseCode, statusInfo.getStatusCode());
                        responseData.put(RequestResponsePhrase, (Object)statusInfo.getReasonPhrase());
                        log.warning(family.toString().concat("_").concat(Integer.valueOf(statusInfo.getStatusCode()).toString()).concat("_").concat(statusInfo.getReasonPhrase()));
                    });
                });
                this.setOutputData(responseData);
            } else {
                JSONObject responseData = new JSONObject();
                Optional<Response.StatusType> maybeStatusInfo = Optional.ofNullable(response.getStatusInfo());
                maybeStatusInfo.ifPresent(statusInfo -> {
                    Optional<Response.Status.Family> maybeFamily = Optional.ofNullable(statusInfo.getFamily());
                    maybeFamily.ifPresent(family -> {
                        responseData.put(RequestError, (Object)family.toString());
                        responseData.put(RequestErrorCode, statusInfo.getStatusCode());
                        responseData.put(RequestErrorPhrase, (Object)statusInfo.getReasonPhrase());
                        log.warning(family.toString().concat("_").concat(Integer.valueOf(statusInfo.getStatusCode()).toString()).concat("_").concat(statusInfo.getReasonPhrase()));
                    });
                });
                this.setOutputData(responseData);
            }
        });
    }

    public void clearParameters() {
        this.url = "";
        this.paths.clear();
        this.parameters.clear();
        this.request = null;
        this.headers.clear();
        this.outputData = null;
        this.inputData = new JSONObject();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setPaths(List<String> paths) {
        this.paths = paths;
    }

    public void setParameters(MultivaluedHashMap<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setRequest(MediaType request) {
        this.request = request;
    }

    public void setHeaders(MultivaluedHashMap<String, Object> headers) {
        this.headers = headers;
    }

    public void setOutputData(JSONObject outputData) {
        this.outputData = outputData;
    }

    public JSONObject getOutputData() {
        Optional.ofNullable(this.outputData).orElseGet(() -> {
            this.call();
            return null;
        });
        return this.outputData;
    }

    public void setInputData(JSONObject inputData) {
        this.inputData = inputData;
    }

    public JSONObject getInputData() {
        return Optional.ofNullable(this.inputData).orElse(new JSONObject());
    }

    public MultivaluedHashMap<String, Object> getParameters() {
        return this.parameters;
    }
}

