/*
 * Decompiled with CFR 0.152.
 */
package org.spin.ie.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.MPackage;
import org.compiere.model.MShipper;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.model.MDDTransportAssignment;
import org.eevolution.model.MDDTransportUnit;
import org.eevolution.model.MDDTransportUnitType;
import org.eevolution.model.MDDVehicle;
import org.eevolution.model.MDDVehicleAssignment;
import org.eevolution.model.MDDVehicleType;
import org.spin.ie.util.ContainerFactory;

public class ImportExportUtil {
    public static final String DocBaseType_TableName = "C_DocBaseType";
    public static final String COLUMNNAME_C_DocBaseType_ID = "C_DocBaseType_ID";
    public static final String DocBaseType_TableName_Trl = "C_DocBaseType_Trl";
    public static final String DocBaseType_ColumnDescription = "Description";
    public static final String DocBaseType_ColumnName = "Name";
    public static final String DocBaseType_ColumnUUID = "UUID";
    public static final String DocBaseType_ColumnAccountingClassName = "AccountingClassName";
    public static final String DocBaseType_ColumnDocBaseType = "DocBaseType";
    public static final String DocBaseType_ColumnEntityType = "EntityType";
    public static final String COLUMNNAME_C_DocType_Trl_PrintName = "PrintName";
    public static final String COLUMNNAME_ECA28_RefInvoice_ID = "ECA28_RefInvoice_ID";
    public static final String COLUMNNAME_ECA28_IsExpedientTax = "ECA28_IsExpedientTax";
    public static final String COLUMNNAME_ECA28_IsAffectsExpedientTax = "ECA28_IsAffectsExpedient";
    public static final String COLUMNNAME_MinimumVolume = "MinimumVolume";
    public static final String COLUMNNAME_MaximumVolume = "MaximumVolume";
    public static final String COLUMNNAME_MinimumWeight = "MinimumWeight";
    public static final String COLUMNNAME_MaximumWeight = "MaximumWeight";
    public static final String COLUMNNAME_TransportWidth = "TransportWidth";
    public static final String COLUMNNAME_TransportHeight = "TransportHeight";
    public static final String COLUMNNAME_TransportLength = "TransportLength";
    public static final String COLUMNNAME_UnladenWeight = "UnladenWeight";
    public static final String COLUMNNAME_AxlesNumber = "AxlesNumber";
    public static final String COLUMNNAME_DD_TransportUnitType_ID = "DD_TransportUnitType_ID";
    public static final String COLUMNNAME_DD_TransportUnit_ID = "DD_TransportUnit_ID";
    public static final String COLUMNNAME_DefaultVehicleType_ID = "DefaultVehicleType_ID";
    public static final String TABLENAME_DD_OrderTransportAssignment = "DD_OrderTransportAssignment";
    public static final String COLUMNNAME_IsAllocatePackages = "IsAllocatePackages";
    public static final String MESSAGE_ContainerValidationError = "ContainerValidationError";
    public static final String MESSAGE_ContainerLineValidationError = "ContainerLineValidationError";

    public static void setTransportUnitValueFromType(MDDTransportUnit transportUnit) {
        MDDTransportUnitType transportUnitType = (MDDTransportUnitType)transportUnit.getDD_TransportUnitType();
        transportUnit.setVolume_UOM_ID(transportUnitType.getVolume_UOM_ID());
        transportUnit.setDimension_UOM_ID(transportUnitType.getDimension_UOM_ID());
        transportUnit.setWeight_UOM_ID(transportUnitType.getWeight_UOM_ID());
        transportUnit.setMinimumVolume((BigDecimal)transportUnitType.get_Value(COLUMNNAME_MinimumVolume));
        transportUnit.setMaximumVolume((BigDecimal)transportUnitType.get_Value(COLUMNNAME_MaximumVolume));
        transportUnit.setMinimumWeight((BigDecimal)transportUnitType.get_Value(COLUMNNAME_MinimumWeight));
        transportUnit.setMaximumWeight((BigDecimal)transportUnitType.get_Value(COLUMNNAME_MaximumWeight));
        transportUnit.setTransportWidth((BigDecimal)transportUnitType.get_Value(COLUMNNAME_TransportWidth));
        transportUnit.setTransportHeight((BigDecimal)transportUnitType.get_Value(COLUMNNAME_TransportHeight));
        transportUnit.setTransportLength((BigDecimal)transportUnitType.get_Value(COLUMNNAME_TransportLength));
        transportUnit.setUnladenWeight((BigDecimal)transportUnitType.get_Value(COLUMNNAME_UnladenWeight));
        transportUnit.setAxlesNumber((BigDecimal)transportUnitType.get_Value(COLUMNNAME_AxlesNumber));
    }

    public static List<PO> getTransportUnitAllocationFromOrder(MOrder order) {
        return new Query(order.getCtx(), TABLENAME_DD_OrderTransportAssignment, "C_Order_ID = ?", order.get_TrxName()).setParameters(new Object[]{order.getC_Order_ID()}).list();
    }

    public static void createAndAllocateTransportUnitFromOrder(MOrder order) {
        if (!order.get_ValueAsBoolean(COLUMNNAME_IsAllocatePackages)) {
            return;
        }
        if (order.getM_Shipper_ID() <= 0) {
            throw new AdempiereException("@M_Shipper_ID@ @IsMandatory@");
        }
        AtomicReference vehicle = new AtomicReference();
        ImportExportUtil.getTransportUnitAllocationFromOrder(order).stream().filter(orderTransportUnit -> orderTransportUnit.get_ValueAsInt(COLUMNNAME_DD_TransportUnit_ID) <= 0).forEach(orderTransportUnit -> {
            if (vehicle.get() == null) {
                vehicle.set(ImportExportUtil.createVehicleFromOrder(order));
            }
            ImportExportUtil.createAndAllocateTransportUnit((MDDVehicle)vehicle.get(), orderTransportUnit, order);
        });
    }

    private static void createAndAllocateTransportUnit(MDDVehicle vehicle, PO orderAllocation, MOrder order) {
        MDDTransportUnitType transportUnitType = new MDDTransportUnitType(order.getCtx(), orderAllocation.get_ValueAsInt(COLUMNNAME_DD_TransportUnitType_ID), order.get_TrxName());
        MDDTransportUnit transportUnit = new MDDTransportUnit(order.getCtx(), 0, order.get_TrxName());
        PO.copyValues((PO)transportUnitType, (PO)transportUnit, (boolean)true);
        transportUnit.setDD_TransportUnitType_ID(transportUnitType.getDD_TransportUnitType_ID());
        transportUnit.setValue(order.getDocumentNo());
        transportUnit.setName(order.getDocumentNo());
        transportUnit.setTransportStatus("AVL");
        transportUnit.saveEx();
        MDDTransportAssignment transportUnitAssignment = new MDDTransportAssignment(order.getCtx(), 0, order.get_TrxName());
        transportUnitAssignment.setDD_Vehicle_ID(vehicle.getDD_Vehicle_ID());
        transportUnitAssignment.setDD_TransportUnit_ID(transportUnit.getDD_TransportUnit_ID());
        transportUnitAssignment.saveEx();
        orderAllocation.set_ValueOfColumn(COLUMNNAME_DD_TransportUnit_ID, (Object)transportUnit.getDD_TransportUnit_ID());
        orderAllocation.saveEx();
    }

    private static MDDVehicle createVehicleFromOrder(MOrder order) {
        MShipper shipper = (MShipper)order.getM_Shipper();
        if (shipper.get_ValueAsInt(COLUMNNAME_DefaultVehicleType_ID) <= 0) {
            throw new AdempiereException("@DefaultVehicleType_ID@ @NotFound@");
        }
        MDDVehicleType defaultVehicleType = new MDDVehicleType(order.getCtx(), shipper.get_ValueAsInt(COLUMNNAME_DefaultVehicleType_ID), order.get_TrxName());
        MDDVehicle vehicle = new MDDVehicle(order.getCtx(), 0, order.get_TrxName());
        PO.copyValues((PO)defaultVehicleType, (PO)vehicle, (boolean)true);
        vehicle.setAD_Org_ID(order.getAD_Org_ID());
        vehicle.setValue(order.getDocumentNo());
        vehicle.setName(order.getDocumentNo());
        vehicle.setDD_VehicleType_ID(defaultVehicleType.getDD_VehicleType_ID());
        vehicle.setVehicleStatus("AVL");
        vehicle.saveEx();
        MDDVehicleAssignment assigment = new MDDVehicleAssignment(order.getCtx(), 0, order.get_TrxName());
        assigment.setDD_Vehicle_ID(vehicle.getDD_Vehicle_ID());
        assigment.setM_Shipper_ID(shipper.getM_Shipper_ID());
        assigment.setAD_Org_ID(order.getAD_Org_ID());
        assigment.setSeqNo(10);
        assigment.saveEx();
        return vehicle;
    }

    public static List<MDDTransportUnit> allocateContainersFromOrder(MOrder order) {
        if (!order.get_ValueAsBoolean(COLUMNNAME_IsAllocatePackages)) {
            return new ArrayList<MDDTransportUnit>();
        }
        ContainerFactory factory = ContainerFactory.newInstance().withContext(order.getCtx()).withTransactionName(order.get_TrxName());
        ImportExportUtil.getValidPackagesFromOrder(order).forEach(packageToAdd -> factory.addPackage((MPackage)packageToAdd));
        ImportExportUtil.getTransportUnitFromOrder(order).forEach(container -> factory.addContainer((MDDTransportUnit)container));
        List<MDDTransportUnit> containers = factory.allocateContainers();
        StringBuffer errors = new StringBuffer();
        containers.forEach(container -> {
            BigDecimal currentContainerWeightCapacity = Optional.ofNullable(container.getMaximumWeight()).orElse(Env.ZERO).subtract(Optional.ofNullable(container.getWeight()).orElse(Env.ZERO));
            BigDecimal currentContainerVolumeCapacity = Optional.ofNullable(container.getMaximumVolume()).orElse(Env.ZERO).subtract(Optional.ofNullable(container.getVolume()).orElse(Env.ZERO));
            if (currentContainerWeightCapacity.compareTo(Env.ZERO) < 0 || currentContainerVolumeCapacity.compareTo(Env.ZERO) < 0) {
                if (errors.length() > 0) {
                    errors.append(Env.NL);
                }
                errors.append(Msg.getMsg((Properties)order.getCtx(), (String)MESSAGE_ContainerLineValidationError, (Object[])new Object[]{container.getName(), Optional.ofNullable(container.getWeight()).orElse(Env.ZERO), Optional.ofNullable(container.getVolume()).orElse(Env.ZERO), Optional.ofNullable(container.getMaximumWeight()).orElse(Env.ZERO), Optional.ofNullable(container.getMaximumVolume()).orElse(Env.ZERO)}));
            }
        });
        if (errors.length() > 0) {
            throw new AdempiereException("@ContainerValidationError@ " + errors.toString());
        }
        return containers;
    }

    public static void unLinkPackagesFromContainer(MOrder order) {
        if (!order.get_ValueAsBoolean(COLUMNNAME_IsAllocatePackages)) {
            return;
        }
        ImportExportUtil.getPackagesFromOrder(order).forEach(packageToSet -> {
            packageToSet.set_ValueOfColumn(COLUMNNAME_DD_TransportUnit_ID, null);
            packageToSet.saveEx();
        });
    }

    public static List<MPackage> getValidPackagesFromOrder(MOrder order) {
        return new Query(order.getCtx(), "M_Package", "M_Package.DocStatus = 'CO' AND EXISTS(SELECT 1 FROM M_PackageLine pl INNER JOIN C_OrderLine ol ON(ol.C_OrderLine_ID = pl.C_OrderLine_ID) WHERE pl.M_Package_ID = M_Package.M_Package_ID AND ol.C_Order_ID = ?)", order.get_TrxName()).setParameters(new Object[]{order.getC_Order_ID()}).list();
    }

    public static List<MPackage> getPackagesFromOrder(MOrder order) {
        return new Query(order.getCtx(), "M_Package", "EXISTS(SELECT 1 FROM M_PackageLine pl INNER JOIN C_OrderLine ol ON(ol.C_OrderLine_ID = pl.C_OrderLine_ID) WHERE pl.M_Package_ID = M_Package.M_Package_ID AND ol.C_Order_ID = ?)", order.get_TrxName()).setParameters(new Object[]{order.getC_Order_ID()}).list();
    }

    public static List<MDDTransportUnit> getTransportUnitFromOrder(MOrder order) {
        if (MTable.getTable_ID((String)TABLENAME_DD_OrderTransportAssignment) <= 0) {
            return new ArrayList<MDDTransportUnit>();
        }
        return new Query(order.getCtx(), "DD_TransportUnit", "EXISTS(SELECT 1 FROM DD_OrderTransportAssignment ta WHERE ta.DD_TransportUnit_ID = DD_TransportUnit.DD_TransportUnit_ID AND ta.C_Order_ID = ?)", order.get_TrxName()).setParameters(new Object[]{order.getC_Order_ID()}).list();
    }

    public static void updateContainerFromOrder(MOrder order) {
        ImportExportUtil.getTransportUnitFromOrder(order).forEach(container -> {
            AtomicReference<BigDecimal> weight = new AtomicReference<BigDecimal>(Env.ZERO);
            AtomicReference<BigDecimal> volume = new AtomicReference<BigDecimal>(Env.ZERO);
            ImportExportUtil.getPackagesFromContainerUnit(container).forEach(packageToProcess -> {
                weight.updateAndGet(value -> value.add(packageToProcess.getWeight()));
                volume.updateAndGet(value -> value.add(packageToProcess.getVolume()));
            });
            container.setWeight(weight.get());
            container.setVolume(volume.get());
            container.saveEx();
        });
    }

    public static void updateContainerFromPackage(MPackage currentPackage) {
        if (currentPackage.get_ValueAsInt(COLUMNNAME_DD_TransportUnit_ID) <= 0) {
            return;
        }
        AtomicReference<BigDecimal> weight = new AtomicReference<BigDecimal>(Env.ZERO);
        AtomicReference<BigDecimal> volume = new AtomicReference<BigDecimal>(Env.ZERO);
        MDDTransportUnit container = new MDDTransportUnit(currentPackage.getCtx(), currentPackage.get_ValueAsInt(COLUMNNAME_DD_TransportUnit_ID), currentPackage.get_TrxName());
        ImportExportUtil.getPackagesFromContainerUnit(container).forEach(packageToProcess -> {
            weight.updateAndGet(value -> value.add(packageToProcess.getWeight()));
            volume.updateAndGet(value -> value.add(packageToProcess.getVolume()));
        });
        container.setWeight(weight.get());
        container.setVolume(volume.get());
        container.saveEx();
    }

    public static List<MPackage> getPackagesFromContainerUnit(MDDTransportUnit container) {
        return new Query(container.getCtx(), "M_Package", "DD_TransportUnit_ID = ? AND DocStatus IN('CO', 'CL')", container.get_TrxName()).setParameters(new Object[]{container.getDD_TransportUnit_ID()}).setOnlyActiveRecords(true).list();
    }
}

