/*
 * Decompiled with CFR 0.152.
 */
package org.spin.ie.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MPackage;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.model.MDDTransportUnit;

public class ContainerFactory {
    private BigDecimal maximumWeight;
    private BigDecimal maximumVolume;
    private BigDecimal maximumWidth;
    private BigDecimal maximumHeight;
    private BigDecimal maximumDepth;
    private String transactionName;
    private Properties context;
    private List<MPackage> packages = new ArrayList<MPackage>();
    private List<MDDTransportUnit> containers = new ArrayList<MDDTransportUnit>();
    private AtomicInteger currentPosition = new AtomicInteger();

    public static ContainerFactory newInstance() {
        return new ContainerFactory();
    }

    public final BigDecimal getMaximumWeight() {
        return this.maximumWeight;
    }

    public final ContainerFactory withMaximumWeight(BigDecimal maximumWeight) {
        this.maximumWeight = Optional.ofNullable(maximumWeight).orElse(Env.ZERO);
        return this;
    }

    public final BigDecimal getMaximumVolume() {
        return this.maximumVolume;
    }

    public final ContainerFactory withMaximumVolume(BigDecimal maximumVolume) {
        this.maximumVolume = Optional.ofNullable(maximumVolume).orElse(Env.ZERO);
        return this;
    }

    private void validateTransactionAndContext() {
        if (Util.isEmpty((String)this.getTransactionName())) {
            throw new AdempiereException("Transaction Name is Mandatory");
        }
        if (this.getContext() == null) {
            throw new AdempiereException("Context is Mandatory");
        }
    }

    public final String getTransactionName() {
        return this.transactionName;
    }

    public final ContainerFactory withTransactionName(String transactionName) {
        this.transactionName = transactionName;
        return this;
    }

    public final Properties getContext() {
        return this.context;
    }

    public final ContainerFactory withContext(Properties context) {
        this.context = context;
        return this;
    }

    public final BigDecimal getMaximumWidth() {
        return this.maximumWidth;
    }

    public final ContainerFactory withMaximumWidth(BigDecimal maximumWidth) {
        this.maximumWidth = Optional.ofNullable(maximumWidth).orElse(Env.ZERO);
        return this;
    }

    public final BigDecimal getMaximumHeight() {
        return this.maximumHeight;
    }

    public final ContainerFactory withMaximumHeight(BigDecimal maximumHeight) {
        this.maximumHeight = Optional.ofNullable(maximumHeight).orElse(Env.ZERO);
        return this;
    }

    public final BigDecimal getMaximumDepth() {
        return this.maximumDepth;
    }

    public final ContainerFactory withMaximumDepth(BigDecimal maximumDepth) {
        this.maximumDepth = Optional.ofNullable(maximumDepth).orElse(Env.ZERO);
        return this;
    }

    public final ContainerFactory addPackage(MPackage packageToProcess) {
        this.packages.add(packageToProcess);
        return this;
    }

    public final ContainerFactory addContainer(MDDTransportUnit container) {
        this.containers.add(container);
        return this;
    }

    private MDDTransportUnit getAvailableContainer(MPackage packageToProcess) {
        if (this.currentPosition.get() >= 0) {
            MDDTransportUnit container = this.containers.get(this.currentPosition.get());
            container.load(this.transactionName);
            BigDecimal currentContainerWeightCapacity = Optional.ofNullable(container.getMaximumWeight()).orElse(Env.ZERO).subtract(Optional.ofNullable(container.getWeight()).orElse(Env.ZERO));
            BigDecimal currentContainerVolumeCapacity = Optional.ofNullable(container.getMaximumVolume()).orElse(Env.ZERO).subtract(Optional.ofNullable(container.getVolume()).orElse(Env.ZERO));
            if (this.isValidForAdd(packageToProcess.getWeight(), packageToProcess.getVolume(), currentContainerWeightCapacity, currentContainerVolumeCapacity)) {
                return container;
            }
            this.currentPosition.decrementAndGet();
            return this.getAvailableContainer(packageToProcess);
        }
        return null;
    }

    public final List<MDDTransportUnit> allocateContainers() {
        this.validateTransactionAndContext();
        this.currentPosition.set(this.containers.size() - 1);
        this.packages.forEach(packageToProcess -> {
            MDDTransportUnit containerToAllocate = this.getAvailableContainer((MPackage)packageToProcess);
            if (containerToAllocate != null) {
                packageToProcess.set_ValueOfColumn("DD_TransportUnit_ID", (Object)containerToAllocate.getDD_TransportUnit_ID());
                packageToProcess.saveEx();
            }
        });
        return this.containers;
    }

    private BigDecimal getUnitsPerPallet(BigDecimal weight, BigDecimal volume, BigDecimal currentContainerWeightCapacity, BigDecimal currentContainerVolumeCapacity) {
        weight = Optional.ofNullable(weight).orElse(Env.ZERO);
        volume = Optional.ofNullable(volume).orElse(Env.ZERO);
        if (weight.compareTo(Env.ZERO) == 0) {
            weight = Env.ONE;
        }
        if (volume.compareTo(Env.ZERO) == 0) {
            volume = Env.ONE;
        }
        BigDecimal weightPerContainer = Optional.ofNullable(currentContainerWeightCapacity).orElse(Optional.ofNullable(this.maximumWeight).orElse(Env.ZERO)).divide(weight, 0, RoundingMode.DOWN);
        BigDecimal volumePerContainer = Optional.ofNullable(currentContainerVolumeCapacity).orElse(Optional.ofNullable(this.maximumVolume).orElse(Env.ZERO)).divide(volume, 0, RoundingMode.DOWN);
        BigDecimal unitPerContainer = weightPerContainer.min(volumePerContainer);
        return unitPerContainer;
    }

    private boolean isValidForAdd(BigDecimal weight, BigDecimal volume, BigDecimal currentContainerWeightCapacity, BigDecimal currentContainerVolumeCapacity) {
        return this.getUnitsPerPallet(weight, volume, currentContainerWeightCapacity, currentContainerVolumeCapacity).compareTo(Env.ONE) >= 0;
    }
}

