/*
 * Decompiled with CFR 0.152.
 */
package org.spin.ie.setup;

import java.util.Arrays;
import java.util.Properties;
import org.adempiere.model.GenericPO;
import org.compiere.model.MDocType;
import org.compiere.model.MLanguage;
import org.compiere.model.Query;
import org.compiere.model.X_AD_ModelValidator;
import org.spin.ie.model.MECA28Expedient;
import org.spin.ie.model.validator.ImportExportExpedient;
import org.spin.util.ISetupDefinition;

public class DeployImportExpedient
implements ISetupDefinition {
    private static final String DESCRIPTION = "(*Created from Setup Automatically*)";
    private static final String UUID = "(*AutomaticSetup*)";
    private static final String NAME = "Import Expedient Management";
    private static final String ENTITY_TYPE = "ECA28";
    private static final int DEFAULT_SEQUENCE = 200;
    private static final String DOCUMENT_TYPE_NAME = "Import Expedient";
    private static final String DOCUMENT_TYPE_NAME_TRL = "Expediente de Importaci\u00f3n";
    private static final String DocBaseType_IE = "_IE";

    public String doIt(Properties context, String transactionName) {
        this.createModelValidator(context, transactionName);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private X_AD_ModelValidator createModelValidator(Properties context, String transactionName) {
        X_AD_ModelValidator modelValidator = (X_AD_ModelValidator)new Query(context, "AD_ModelValidator", "ModelValidationClass = ?", transactionName).setParameters(new Object[]{ImportExportExpedient.class.getName()}).setClient_ID().first();
        if (modelValidator != null && modelValidator.getAD_ModelValidator_ID() > 0) {
            return modelValidator;
        }
        modelValidator = new X_AD_ModelValidator(context, 0, transactionName);
        modelValidator.setName(NAME);
        modelValidator.setEntityType(ENTITY_TYPE);
        modelValidator.setDescription(DESCRIPTION);
        modelValidator.setSeqNo(200);
        modelValidator.setModelValidationClass(ImportExportExpedient.class.getName());
        modelValidator.setUUID(UUID);
        modelValidator.setIsDirectLoad(true);
        modelValidator.saveEx();
        this.createDocumentBaseType(context, transactionName);
        return modelValidator;
    }

    private void createDocumentBaseType(Properties context, String transactionName) {
        GenericPO docBaseImportExpedient = new GenericPO("C_DocBaseType", context, 0, transactionName);
        docBaseImportExpedient.set_ValueOfColumn("DocBaseType", (Object)DocBaseType_IE);
        docBaseImportExpedient.set_ValueOfColumn("Name", (Object)DOCUMENT_TYPE_NAME);
        docBaseImportExpedient.set_ValueOfColumn("Description", (Object)DESCRIPTION);
        docBaseImportExpedient.set_ValueOfColumn("UUID", (Object)UUID);
        docBaseImportExpedient.set_ValueOfColumn("EntityType", (Object)ENTITY_TYPE);
        docBaseImportExpedient.set_ValueOfColumn("AD_Table_ID", (Object)MECA28Expedient.Table_ID);
        docBaseImportExpedient.setIsDirectLoad(true);
        docBaseImportExpedient.saveEx();
        this.createTranslation(context, transactionName, "C_DocBaseType_Trl", "C_DocBaseType_ID", docBaseImportExpedient.get_ID(), DOCUMENT_TYPE_NAME_TRL);
        MDocType docTypeImportExpedient = new MDocType(context, 0, transactionName);
        docTypeImportExpedient.setName(DOCUMENT_TYPE_NAME);
        docTypeImportExpedient.setPrintName(DOCUMENT_TYPE_NAME);
        docTypeImportExpedient.set_ValueOfColumn("C_DocBaseType_ID", (Object)docBaseImportExpedient.get_ID());
        docTypeImportExpedient.setDocBaseType(DocBaseType_IE);
        docTypeImportExpedient.setGL_Category_ID();
        docTypeImportExpedient.setIsDirectLoad(true);
        docTypeImportExpedient.saveEx();
        this.createTranslation(context, transactionName, "C_DocType".concat("_Trl"), "C_DocType_ID", docTypeImportExpedient.get_ID(), DOCUMENT_TYPE_NAME_TRL);
    }

    private void createTranslation(Properties context, String transactionName, String tableName, String poColumnNameId, int poId, String translation) {
        Arrays.asList(MLanguage.getMaintainLanguage((Properties)context)).forEach(languague -> {
            if (languague.isSystemLanguage() && languague.getAD_Language().contains("es_")) {
                GenericPO trl = new GenericPO(tableName, context, 0, transactionName);
                trl.set_ValueOfColumn(poColumnNameId, (Object)poId);
                trl.set_ValueOfColumn("Name", (Object)translation);
                trl.set_ValueOfColumn("Description", (Object)translation);
                trl.set_ValueOfColumn("PrintName", (Object)translation);
                trl.set_ValueOfColumn("AD_Language", (Object)languague.getAD_Language());
                trl.saveEx();
            }
        });
    }
}

