/*
 * Decompiled with CFR 0.152.
 */
package org.spin.ie.process;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MCurrency;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MPriceList;
import org.compiere.util.Env;
import org.spin.ie.model.MECA28ExpedientTax;
import org.spin.ie.model.MECA28Tax;
import org.spin.ie.process.GenerateDocumentTaxAbstract;

public class GenerateDocumentTax
extends GenerateDocumentTaxAbstract {
    private static final String EXPEDIENT_PREFIX = "EXP_";
    private HashMap<Integer, MInvoice> taxDocuments = new HashMap();
    private HashMap<Integer, MECA28Tax> taxToGenerated = new HashMap();
    private int Max_Sequence = 9999;
    BigDecimal taxAmount = Env.ZERO;

    @Override
    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        AtomicInteger seqNo = new AtomicInteger(0);
        if (this.isSelection()) {
            this.getSelectionKeys().forEach(selectionId -> {
                MECA28Tax tax = new MECA28Tax(this.getCtx(), (int)selectionId, this.get_TrxName());
                String baseForTax = Optional.ofNullable(tax.getECA28_BaseForTax()).orElse("");
                int sequence = baseForTax.equals("IT") ? this.Max_Sequence : seqNo.incrementAndGet();
                this.taxToGenerated.put(sequence, tax);
            });
            this.taxToGenerated.entrySet().stream().sorted(Comparator.comparing(item -> (Integer)item.getKey())).forEach(taxItem -> {
                MECA28Tax tax = (MECA28Tax)taxItem.getValue();
                BigDecimal baseForTax = Env.ZERO;
                BigDecimal baseAmount = this.getSelectionAsBigDecimal(tax.get_ID(), EXPEDIENT_PREFIX.concat("ECA28_BaseAmtInvoices"));
                baseForTax = (Integer)taxItem.getKey() == this.Max_Sequence ? baseAmount.add(this.taxAmount) : baseAmount;
                int expedientId = this.getSelectionAsInt(tax.get_ID(), EXPEDIENT_PREFIX.concat("ECA28_Expedient_ID"));
                this.generateTaxDocument(tax, baseForTax, expedientId);
            });
            this.taxDocuments.entrySet().forEach(taxDocumentIndex -> {
                MInvoice taxDocument = (MInvoice)taxDocumentIndex.getValue();
                taxDocument.processIt(this.getDocAction());
                taxDocument.saveEx();
                this.addLog(taxDocument.get_ID(), taxDocument.getDateAcct(), taxDocument.getGrandTotal(), taxDocument.getDescription());
            });
            this.openResult("C_Invoice");
        }
        return "@OK@";
    }

    private void generateTaxDocument(MECA28Tax tax, BigDecimal baseAmount, int expedientId) {
        MInvoice taxDocument = Optional.ofNullable(this.taxDocuments.get(tax.getC_BPartner_ID())).orElse(new MInvoice(this.getCtx(), 0, this.get_TrxName()));
        if (taxDocument.get_ID() == 0) {
            taxDocument.setC_DocTypeTarget_ID(this.getDocTypeId());
            taxDocument.setC_BPartner_ID(tax.getC_BPartner_ID());
            taxDocument.setDateInvoiced(this.getDateDoc());
            taxDocument.setDateAcct(this.getDateDoc());
            taxDocument.setDocumentNo(this.getDocumentNo());
            taxDocument.set_ValueOfColumn("ECA28_IsExpedientTax", (Object)true);
            if (this.getRefInvoiceId() > 0) {
                taxDocument.set_ValueOfColumn("ECA28_RefInvoice_ID", (Object)this.getRefInvoiceId());
            }
            taxDocument.setIsSOTrx(false);
            MCurrency currency = MCurrency.get((Properties)this.getCtx(), (int)this.getCurrencyId());
            Optional<MPriceList> maybePriceList = Optional.ofNullable(MPriceList.getDefault((Properties)this.getCtx(), (boolean)false, (String)currency.getISO_Code()));
            maybePriceList.ifPresent(priceList -> taxDocument.setM_PriceList_ID(priceList.get_ID()));
            if (expedientId > 0) {
                taxDocument.set_ValueOfColumn("ECA28_Expedient_ID", (Object)expedientId);
            }
            taxDocument.saveEx();
            if (this.getProjectId() == 0) {
                taxDocument.setC_Project_ID(0);
                taxDocument.save();
            }
            this.taxDocuments.put(tax.getC_BPartner_ID(), taxDocument);
        }
        MInvoiceLine taxDocumentLine = new MInvoiceLine(taxDocument);
        taxDocumentLine.setC_Charge_ID(tax.getC_Charge_ID());
        taxDocumentLine.setQty(Env.ONE);
        taxDocumentLine.setPrice(baseAmount.multiply(tax.getRate().divide(Env.ONEHUNDRED)));
        taxDocumentLine.setDescription("(".concat(baseAmount.toString()).concat(" * ").concat(tax.getRate().toString()).concat("% ) = ").concat(taxDocumentLine.getPriceEntered().toString()));
        if (this.getRefInvoiceId() > 0) {
            taxDocumentLine.set_ValueOfColumn("ECA28_RefInvoice_ID", (Object)this.getRefInvoiceId());
        }
        taxDocumentLine.saveEx();
        if (this.getProjectId() == 0) {
            taxDocumentLine.setC_Project_ID(0);
            taxDocumentLine.save();
        }
        MECA28ExpedientTax expedientTax = new MECA28ExpedientTax(this.getCtx(), 0, this.get_TrxName());
        expedientTax.setC_Invoice_ID(taxDocument.get_ID());
        expedientTax.setECA28_Expedient_ID(expedientId);
        expedientTax.setECA28_Tax_ID(tax.get_ID());
        expedientTax.setTaxBaseAmt(baseAmount);
        expedientTax.setTaxAmt(taxDocumentLine.getPriceEntered());
        expedientTax.setProcessed(true);
        expedientTax.saveEx();
        this.taxAmount = this.taxAmount.add(expedientTax.getTaxAmt());
    }
}

