/*
 * Decompiled with CFR 0.152.
 */
package org.spin.ie.model.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.spin.ie.model.MECA28Expedient;
import org.spin.ie.model.validator.ImportExport;

public class ImportExportExpedient
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ImportExport.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Order", (ModelValidator)this);
        engine.addModelChange("C_Invoice", (ModelValidator)this);
        engine.addModelChange("C_InvoiceLine", (ModelValidator)this);
        engine.addModelChange("C_Payment", (ModelValidator)this);
        engine.addDocValidate("C_Order", (ModelValidator)this);
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
        engine.addDocValidate("C_Payment", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        if (type == 2 || type == 1) {
            Optional<PO> maybeDocument = Optional.ofNullable(entity);
            maybeDocument.ifPresent(document -> {
                MInvoice invoice;
                if (document.get_TableName().equals("C_Order") || document.get_TableName().equals("C_Invoice") || document.get_TableName().equals("C_Payment")) {
                    MOrder order;
                    if (document.get_TableName().equals("C_Invoice")) {
                        MInvoice invoice2 = (MInvoice)document;
                        if (type == 1) {
                            MDocType docType = MDocType.get((Properties)Env.getCtx(), (int)invoice2.getC_DocTypeTarget_ID());
                            invoice2.set_ValueOfColumn("ECA28_IsAffectsExpedient", docType.get_Value("ECA28_IsAffectsExpedient"));
                        }
                        if (invoice2.is_ValueChanged("C_Order_ID") && invoice2.getC_Order_ID() > 0 && (order = new MOrder(invoice2.getCtx(), invoice2.getC_Order_ID(), invoice2.get_TrxName())).get_ValueAsInt("ECA28_Expedient_ID") > 0 && order.get_ValueAsInt("ECA28_Expedient_ID") != invoice2.get_ValueAsInt("ECA28_Expedient_ID")) {
                            int currentExpedientId = invoice2.get_ValueAsInt("ECA28_Expedient_ID");
                            invoice2.set_ValueOfColumn("ECA28_Expedient_ID", (Object)order.get_ValueAsInt("ECA28_Expedient_ID"));
                            Optional<MInvoiceLine[]> maybeInvoiceLines = Optional.ofNullable(invoice2.getLines());
                            maybeInvoiceLines.ifPresent(invoiceLines -> Arrays.asList(invoiceLines).forEach(invoiceLine -> {
                                if (invoiceLine.get_ValueAsInt("ECA28_Expedient_ID") == currentExpedientId) {
                                    invoiceLine.set_ValueOfColumn("ECA28_Expedient_ID", (Object)invoice2.get_ValueAsInt("ECA28_Expedient_ID"));
                                    invoiceLine.saveEx();
                                }
                            }));
                        }
                    }
                    if (document.get_TableName().equals("C_Payment")) {
                        MPayment payment = (MPayment)document;
                        if (payment.is_ValueChanged("C_Order_ID") && payment.getC_Order_ID() > 0) {
                            order = new MOrder(payment.getCtx(), payment.getC_Order_ID(), payment.get_TrxName());
                            if (order.get_ValueAsInt("ECA28_Expedient_ID") > 0) {
                                payment.set_ValueOfColumn("ECA28_Expedient_ID", (Object)order.get_ValueAsInt("ECA28_Expedient_ID"));
                            }
                        } else if (payment.is_ValueChanged("C_Invoice_ID") && payment.getC_Invoice_ID() > 0 && (invoice = new MInvoice(payment.getCtx(), payment.getC_Invoice_ID(), payment.get_TrxName())).get_ValueAsInt("ECA28_Expedient_ID") > 0) {
                            payment.set_ValueOfColumn("ECA28_Expedient_ID", (Object)invoice.get_ValueAsInt("ECA28_Expedient_ID"));
                        }
                    }
                    if (document.is_ValueChanged("ECA28_Expedient_ID")) {
                        Optional<MECA28Expedient> maybeExpedient = Optional.ofNullable(MECA28Expedient.get(document.getCtx(), document.get_ValueAsInt("ECA28_Expedient_ID"), null));
                        maybeExpedient.ifPresent(expedient -> {
                            if (expedient.getC_Project_ID() > 0) {
                                document.set_ValueOfColumn("C_Project_ID", (Object)expedient.getC_Project_ID());
                            }
                            if (expedient.getC_ConversionType_ID() > 0) {
                                document.set_ValueOfColumn("C_ConversionType_ID", (Object)expedient.getC_ConversionType_ID());
                            }
                        });
                    }
                }
                if (document.get_TableName().equals("C_InvoiceLine")) {
                    MInvoiceLine invoiceLine = (MInvoiceLine)document;
                    invoice = invoiceLine.getParent();
                    if (invoiceLine.get_ValueAsInt("ECA28_Expedient_ID") == 0 && invoice.get_ValueAsInt("ECA28_Expedient_ID") != 0) {
                        invoiceLine.set_ValueOfColumn("ECA28_Expedient_ID", (Object)invoice.get_ValueAsInt("ECA28_Expedient_ID"));
                    }
                    if (invoiceLine.get_ValueAsInt("ECA28_RefInvoice_ID") == 0 && invoice.get_ValueAsInt("ECA28_RefInvoice_ID") != 0) {
                        invoiceLine.set_ValueOfColumn("ECA28_RefInvoice_ID", (Object)invoice.get_ValueAsInt("ECA28_RefInvoice_ID"));
                    }
                }
            });
        }
        return null;
    }

    public String docValidate(PO entity, int timing) {
        Optional<PO> maybeDocument = Optional.ofNullable(entity);
        maybeDocument.ifPresent(document -> {
            if (document.get_TableName().equals("C_Order")) {
                MOrder order;
                if (timing == 9) {
                    MOrder order2 = (MOrder)document;
                    if (order2.get_ValueAsInt("ECA28_Expedient_ID") > 0) {
                        MECA28Expedient expedient = MECA28Expedient.get(order2.getCtx(), order2.get_ValueAsInt("ECA28_Expedient_ID"), order2.get_TrxName());
                        expedient.updateOrderBalance(order2, true, false);
                    }
                } else if ((timing == 12 || timing == 13 || timing == 14 || timing == 10) && (order = (MOrder)document).get_ValueAsInt("ECA28_Expedient_ID") > 0) {
                    MECA28Expedient expedient = MECA28Expedient.get(order.getCtx(), order.get_ValueAsInt("ECA28_Expedient_ID"), order.get_TrxName());
                    expedient.updateOrderBalance(order, true, true);
                }
            } else if (document.get_TableName().equals("C_Invoice")) {
                MInvoice invoice;
                if (timing == 9) {
                    MInvoice invoice2 = (MInvoice)document;
                    if (invoice2.get_ValueAsInt("ECA28_Expedient_ID") > 0 && invoice2.getReversal_ID() == 0) {
                        MECA28Expedient expedient = MECA28Expedient.get(invoice2.getCtx(), invoice2.get_ValueAsInt("ECA28_Expedient_ID"), invoice2.get_TrxName());
                        expedient.updateInvoiceBalance(invoice2, true, false);
                    }
                } else if ((timing == 13 || timing == 14 || timing == 10) && (invoice = (MInvoice)document).get_ValueAsInt("ECA28_Expedient_ID") > 0) {
                    MECA28Expedient expedient = MECA28Expedient.get(invoice.getCtx(), invoice.get_ValueAsInt("ECA28_Expedient_ID"), invoice.get_TrxName());
                    expedient.updateInvoiceBalance(invoice, true, true);
                    String whereClause = "ECA28_Expedient_ID".concat("=? AND ").concat("C_Invoice_ID".concat("=?"));
                    Optional<List> maybeTaxes = Optional.ofNullable(new Query(invoice.getCtx(), "ECA28_Expedient_Tax", whereClause, invoice.get_TrxName()).setParameters(new Object[]{expedient.getECA28_Expedient_ID(), invoice.getC_Invoice_ID()}).list());
                    maybeTaxes.ifPresent(taxes -> taxes.forEach(expedientTax -> {
                        expedientTax.setProcessed(false);
                        expedientTax.saveEx();
                    }));
                }
            } else if (document.get_TableName().equals("C_Payment")) {
                MPayment payment;
                if (timing == 9) {
                    MPayment payment2 = (MPayment)document;
                    if (payment2.get_ValueAsInt("ECA28_Expedient_ID") > 0) {
                        MECA28Expedient expedient = MECA28Expedient.get(payment2.getCtx(), payment2.get_ValueAsInt("ECA28_Expedient_ID"), payment2.get_TrxName());
                        expedient.updatePaymentBalance(payment2, true, false);
                    }
                } else if ((timing == 13 || timing == 14 || timing == 10) && (payment = (MPayment)document).get_ValueAsInt("ECA28_Expedient_ID") > 0) {
                    MECA28Expedient expedient = MECA28Expedient.get(payment.getCtx(), payment.get_ValueAsInt("ECA28_Expedient_ID"), payment.get_TrxName());
                    expedient.updatePaymentBalance(payment, true, true);
                }
            }
        });
        return null;
    }
}

