/*
 * Decompiled with CFR 0.152.
 */
package org.spin.ie.model.validator;

import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MPackage;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.eevolution.model.MDDTransportUnit;
import org.spin.ie.util.ImportExportUtil;

public class ImportExport
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ImportExport.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("DD_TransportUnit", (ModelValidator)this);
        engine.addModelChange("M_Package", (ModelValidator)this);
        engine.addModelChange("C_Order", (ModelValidator)this);
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        MPackage packageToProcess;
        if (type == 1 || type == 2) {
            if (entity.get_TableName().equals("DD_TransportUnit") && (entity.is_new() || entity.is_ValueChanged("DD_TransportUnitType_ID"))) {
                MDDTransportUnit transportUnit = (MDDTransportUnit)entity;
                ImportExportUtil.setTransportUnitValueFromType(transportUnit);
            }
        } else if ((type == 5 || type == 4) && entity.get_TableName().equals("M_Package") && ((packageToProcess = (MPackage)entity).is_ValueChanged("DD_TransportUnit_ID") || type == 4)) {
            ImportExportUtil.updateContainerFromPackage(packageToProcess);
        }
        return null;
    }

    public String docValidate(PO entity, int timing) {
        MOrder order;
        if (timing == 1) {
            MOrder order2;
            if (entity.get_TableName().equals("C_Order") && !(order2 = (MOrder)entity).isSOTrx() && !order2.isReturnOrder()) {
                ImportExportUtil.createAndAllocateTransportUnitFromOrder(order2);
            }
        } else if (timing == 9) {
            MOrder order3;
            if (entity.get_TableName().equals("C_Order") && !(order3 = (MOrder)entity).isSOTrx() && !order3.isReturnOrder() && order3.get_ValueAsBoolean("IsAllocatePackages")) {
                ImportExportUtil.allocateContainersFromOrder(order3);
            }
        } else if ((timing == 10 || timing == 12) && entity.get_TableName().equals("C_Order") && !(order = (MOrder)entity).isSOTrx() && !order.isReturnOrder() && order.get_ValueAsBoolean("IsAllocatePackages")) {
            ImportExportUtil.unLinkPackagesFromContainer(order);
            ImportExportUtil.updateContainerFromOrder(order);
        }
        return null;
    }
}

