/*
 * Decompiled with CFR 0.152.
 */
package org.spin.ie.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.MProject;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CCache;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.spin.ie.model.X_ECA28_Expedient;

public class MECA28Expedient
extends X_ECA28_Expedient
implements DocAction {
    private static final long serialVersionUID = 20220905L;
    private static CCache<Integer, MECA28Expedient> s_cache = new CCache("ECA28_Expedient", 40, 5);
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MECA28Expedient(Properties ctx, int ECA28_Expedient_ID, String trxName) {
        super(ctx, ECA28_Expedient_ID, trxName);
    }

    public MECA28Expedient(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getDateDoc(), (String)dt.getDocBaseType(), (int)this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        if (this.getC_Project_ID() == 0) {
            this.createProject();
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete()) {
            String value = null;
            int index = this.p_info.getColumnIndex("C_DocType_ID");
            if (index == -1) {
                index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (index != -1) {
                value = DB.getDocumentNo((int)this.get_ValueAsInt(index), (String)this.get_TrxName(), (boolean)true);
            }
            if (value != null) {
                this.setDocumentNo(value);
            }
        }
    }

    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        return this.closeIt();
    }

    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return false;
    }

    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.setProcessed(false);
        return this.reverseCorrectIt();
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return 0;
    }

    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MIEExpedient[").append(this.getSummary()).append("]");
        return sb.toString();
    }

    private int getPrecision() {
        return MCurrency.getStdPrecision((Properties)this.getCtx(), (int)this.getLVE_FiscalCurrency_ID());
    }

    private void createProject() {
        MProject project = new MProject(this.getCtx(), 0, this.get_TrxName());
        project.setAD_Org_ID(this.getAD_Org_ID());
        project.setName(this.getDocumentNo());
        project.setValue(this.getDocumentNo());
        project.setC_Currency_ID(this.getC_Currency_ID());
        project.setProjectLineLevel("P");
        project.saveEx();
        this.setC_Project_ID(project.get_ID());
    }

    public static MECA28Expedient get(Properties ctx, int IE_Expedient_ID, String trxName) {
        if (IE_Expedient_ID <= 0) {
            return null;
        }
        Integer key = new Integer(IE_Expedient_ID);
        MECA28Expedient retValue = (MECA28Expedient)s_cache.get((Object)key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MECA28Expedient(ctx, IE_Expedient_ID, trxName);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateDoc() == null) {
            this.setDateDoc(Env.getContextAsDate((Properties)this.getCtx(), (String)"#Date"));
        }
        Optional<MDocType> maybeDocumentType = Optional.ofNullable(MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID()));
        maybeDocumentType.ifPresent(documentType -> this.setIsSOTrx(documentType.isSOTrx()));
        if (this.getLVE_FiscalCurrency_ID() == 0) {
            Optional<MOrgInfo> maybeOrgInfo = Optional.ofNullable(MOrgInfo.get((Properties)this.getCtx(), (int)this.getAD_Org_ID(), (String)this.get_TrxName()));
            maybeOrgInfo.ifPresent(orgInfo -> {
                if (orgInfo.get_ValueAsInt("LVE_FiscalCurrency_ID") > 0) {
                    this.setLVE_FiscalCurrency_ID(orgInfo.get_ValueAsInt("LVE_FiscalCurrency_ID"));
                }
            });
            if (this.getLVE_FiscalCurrency_ID() == 0) {
                this.setLVE_FiscalCurrency_ID(Env.getContextAsInt((Properties)this.getCtx(), (String)"@$C_Currency_ID@"));
            }
        }
        return super.beforeSave(newRecord);
    }

    public void updateOrderBalance() {
        String whereClause = "ECA28_Expedient_ID".concat("=? AND ").concat("DocStatus").concat(" IN (?, ?)");
        Optional<List> maybeOrders = Optional.ofNullable(new Query(this.getCtx(), "C_Order", whereClause, this.get_TrxName()).setParameters(new Object[]{this.getECA28_Expedient_ID(), "CO", "CL"}).list());
        this.setECA28_BaseAmtOrders(Env.ZERO);
        this.setECA28_NetAmtOrders(Env.ZERO);
        this.setECA28_TaxAmtOrders(Env.ZERO);
        this.setECA28_QtyOrders(Env.ZERO);
        maybeOrders.ifPresent(orders -> orders.forEach(order -> this.updateOrderBalance((MOrder)order, false, false)));
        this.saveEx();
    }

    public void updateOrderBalance(MOrder order, boolean save, boolean reversal) {
        BigDecimal multiplier = reversal ? Env.ONE.negate() : Env.ONE;
        BigDecimal currencyRate = Optional.ofNullable(MConversionRate.getRate((int)order.getC_Currency_ID(), (int)this.getLVE_FiscalCurrency_ID(), (Timestamp)order.getDateAcct(), (int)order.getC_ConversionType_ID(), (int)order.getAD_Client_ID(), (int)order.getAD_Org_ID())).orElse(Env.ZERO);
        int stdPrecision = this.getPrecision();
        this.setECA28_BaseAmtOrders(this.getECA28_BaseAmtOrders().add(order.getTotalLines().multiply(multiplier).multiply(currencyRate).setScale(stdPrecision, 4)));
        this.setECA28_NetAmtOrders(this.getECA28_NetAmtOrders().add(order.getGrandTotal().multiply(multiplier).multiply(currencyRate).setScale(stdPrecision, 4)));
        Arrays.asList(order.getTaxes(true)).forEach(tax -> this.setECA28_TaxAmtOrders(this.getECA28_TaxAmtOrders().add(tax.getTaxAmt().multiply(multiplier).multiply(currencyRate).setScale(stdPrecision, 4))));
        this.setECA28_QtyOrders(this.getECA28_QtyOrders().add(Env.ONE.multiply(multiplier)));
        if (save) {
            this.saveEx();
        }
    }

    public void updateInvoiceBalance() {
        String whereClause = "EXISTS (SELECT 1 FROM C_InvoiceLine il WHERE C_Invoice.C_Invoice_ID = il.C_Invoice_ID AND COALESCE(il.".concat("ECA28_Expedient_ID").concat(",C_Invoice.").concat("ECA28_Expedient_ID").concat(")=?) AND ").concat("DocStatus").concat(" IN (?, ?)");
        Optional<List> maybeInvoices = Optional.ofNullable(new Query(this.getCtx(), "C_Invoice", whereClause, this.get_TrxName()).setParameters(new Object[]{this.getECA28_Expedient_ID(), "CO", "CL"}).list());
        this.setECA28_BaseAmtInvoices(Env.ZERO);
        this.setECA28_NetAmtInvoices(Env.ZERO);
        this.setECA28_TaxAmtInvoices(Env.ZERO);
        this.setECA28_QtyInvoices(Env.ZERO);
        this.setTaxAmt(Env.ZERO);
        maybeInvoices.ifPresent(invoices -> invoices.forEach(invoice -> this.updateInvoiceBalance((MInvoice)invoice, false, false)));
        this.saveEx();
    }

    public void updateInvoiceBalance(MInvoice invoice, boolean save, boolean reversal) {
        if (!invoice.get_ValueAsBoolean("ECA28_IsAffectsExpedient")) {
            return;
        }
        BinaryOperator _sum = (prevousValue, newValue) -> prevousValue.add((BigDecimal)newValue);
        BigDecimal currencyRate = Optional.ofNullable(MConversionRate.getRate((int)invoice.getC_Currency_ID(), (int)this.getLVE_FiscalCurrency_ID(), (Timestamp)invoice.getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID())).orElse(Env.ZERO);
        int stdPrecision = this.getPrecision();
        AtomicReference<BigDecimal> currentBaseAmt = new AtomicReference<BigDecimal>(Env.ZERO);
        AtomicReference<BigDecimal> currentNetAmt = new AtomicReference<BigDecimal>(Env.ZERO);
        AtomicReference<BigDecimal> currentTaxAmt = new AtomicReference<BigDecimal>(Env.ZERO);
        boolean expedientTax = invoice.get_ValueAsBoolean("ECA28_IsExpedientTax");
        BigDecimal multiplier = (invoice.isCreditMemo() ? Env.ONE.negate() : Env.ONE).multiply(reversal ? Env.ONE.negate() : Env.ONE);
        if (!expedientTax) {
            Arrays.asList(invoice.getLines()).forEach(invoiceLine -> {
                if (invoiceLine.get_ValueAsInt("ECA28_Expedient_ID") == this.getECA28_Expedient_ID() || invoiceLine.get_ValueAsInt("ECA28_Expedient_ID") == 0 && invoice.get_ValueAsInt("ECA28_Expedient_ID") == this.getECA28_Expedient_ID()) {
                    currentBaseAmt.accumulateAndGet(invoiceLine.getLineNetAmt().multiply(multiplier), _sum);
                    currentNetAmt.accumulateAndGet(invoiceLine.getLineTotalAmt().multiply(multiplier), _sum);
                    currentTaxAmt.accumulateAndGet(invoiceLine.getTaxAmt().multiply(multiplier), _sum);
                }
            });
            this.setECA28_BaseAmtInvoices(this.getECA28_BaseAmtInvoices().add(currentBaseAmt.get().multiply(currencyRate).setScale(stdPrecision, 4)));
            this.setECA28_NetAmtInvoices(this.getECA28_NetAmtInvoices().add(currentNetAmt.get().multiply(currencyRate).setScale(stdPrecision, 4)));
            this.setECA28_TaxAmtInvoices(this.getECA28_TaxAmtInvoices().add(currentTaxAmt.get().multiply(currencyRate).setScale(stdPrecision, 4)));
            this.setECA28_QtyInvoices(this.getECA28_QtyInvoices().add(Env.ONE.multiply(reversal ? Env.ONE.negate() : Env.ONE)));
        } else {
            this.setTaxAmt(this.getTaxAmt().add(invoice.getGrandTotal().multiply(multiplier).multiply(currencyRate).setScale(stdPrecision, 4)));
        }
        if (save) {
            this.saveEx();
        }
    }

    public void updatePaymentBalance() {
        String whereClause = "ECA28_Expedient_ID".concat("=? AND ").concat("DocStatus").concat(" IN (?, ?)");
        Optional<List> maybePayments = Optional.ofNullable(new Query(this.getCtx(), "C_Payment", whereClause, this.get_TrxName()).setParameters(new Object[]{this.getECA28_Expedient_ID(), "CO", "CL"}).list());
        this.setECA28_PaymentsAmount(Env.ZERO);
        this.setECA28_QtyPayments(Env.ZERO);
        maybePayments.ifPresent(payments -> payments.forEach(payment -> this.updatePaymentBalance((MPayment)payment, false, false)));
        this.saveEx();
    }

    public void updatePaymentBalance(MPayment payment, boolean save, boolean reversal) {
        BigDecimal multiplier = reversal ? Env.ONE.negate() : Env.ONE;
        BigDecimal currencyRate = Optional.ofNullable(MConversionRate.getRate((int)payment.getC_Currency_ID(), (int)this.getLVE_FiscalCurrency_ID(), (Timestamp)payment.getDateAcct(), (int)payment.getC_ConversionType_ID(), (int)payment.getAD_Client_ID(), (int)payment.getAD_Org_ID())).orElse(Env.ZERO);
        int stdPrecision = this.getPrecision();
        this.setECA28_PaymentsAmount(this.getECA28_PaymentsAmount().add(payment.getPayAmt().multiply(multiplier).multiply(currencyRate).setScale(stdPrecision, 4)));
        this.setECA28_QtyPayments(this.getECA28_QtyPayments().add(Env.ONE.multiply(multiplier)));
        if (save) {
            this.saveEx();
        }
    }
}

