/*
 * Decompiled with CFR 0.152.
 */
package org.farming.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.model.MDDFreight;
import org.eevolution.model.MDDOrder;
import org.farming.model.MFAPFarming;
import org.farming.model.MFAPFarmingDefinition;
import org.farming.model.MFAPRawMaterialConditioning;
import org.spin.model.MFMAccount;
import org.spin.model.MFMAgreement;
import org.spin.model.MFMBatch;

public class FarmingTechnicalAssistanceUtil {
    public static final String Table_Name_DD_RecordWeight = "DD_RecordWeight";
    public static final String COLUMNNAME_DD_RecordWeight_ID = "DD_RecordWeight_ID";
    public static final String COLUMNNAME_IsSOTrx = "IsSOTrx";
    public static final String COLUMNNAME_Description = "Description";
    public static final String Table_Name_DD_RecordWeightAttributes = "DD_WeightAttributes";
    public static final String Table_Name_RM_QualityAnalysisAttributes = "RM_AnalysisAttributes";
    public static final String Table_Name_RM_QualityAnalysis = "RM_QualityAnalysis";
    public static final String COLUMNNAME_RM_QualityAnalysis_ID = "RM_QualityAnalysis_ID";
    public static final String COLUMNNAME_NegotiatedConditionedWeight = "NegotiatedConditionedWeight";
    public static final String COLUMNNAME_Code = "Code";
    public static final String COLUMNNAME_ValueString = "ValueString";
    public static final String COLUMNNAME_ValueNumber = "ValueNumber";
    public static final String COLUMNNAME_ValueDate = "ValueDate";
    public static final String COLUMNNAME_IsCategory = "IsCategory";
    public static final String COLUMNNAME_NetWeight = "NetWeight";
    public static final String COLUMNNAME_ConditionedWeight = "ConditionedWeight";
    public static final String COLUMNNAME_DateDoc = "DateDoc";
    public static final String COLUMNNAME_FarmerCreditAvailable = "FarmerCreditAvailable";
    public static final String COLUMNNAME_FarmerCreditLimit = "FarmerCreditLimit";
    public static final String COLUMNNAME_FarmerCreditUsed = "FarmerCreditUsed";
    public static final String COLUMNNAME_FarmingAmount = "FarmingAmount";
    public static final String COLUMNNAME_FarmingApprovedAmount = "FarmingApprovedAmount";
    public static final String COLUMNNAME_FarmingApprovedArea = "FarmingApprovedArea";
    public static final String COLUMNNAME_FarmingArea = "FarmingArea";
    public static final String COLUMNNAME_IsFarmerAssistanceProgram = "IsFarmerAssistanceProgram";
    public static final String COLUMNNAME_QualityAnalysis_ID = "QualityAnalysis_ID";
    public static final String COLUMNNAME_FarmerInvoiceInterest_ID = "FarmerInvoiceInterest_ID";
    public static final String COLUMNNAME_IsFarmerInvoiceInterest = "IsFarmerInvoiceInterest";
    public static final int AttributeValue_AD_REFERENCE_ID = 54258;
    public static final String COLUMNNAME_IsFarmerTransactionReversal = "IsFarmerTransactionReversal";
    public static final String COLUMNNAME_IsFarmerOverdraftCreditLimit = "IsFarmerOverdraftCreditLimit";
    public static final String COLUMNNAME_ReceiptReferenceWeight = "ReceiptReferenceWeight";
    public static final String RECEIPTREFERENCEWEIGHT_ConditionedWeight = "C";
    public static final String RECEIPTREFERENCEWEIGHT_NegociatedConditionedWeight = "G";
    public static final String RECEIPTREFERENCEWEIGHT_NetWeight = "N";
    public static final String COLUMNNAME_C_DocType_ID = "C_DocType_ID";
    public static final String COLUMNNAME_FAP_Warehouse_ID = "FAP_Warehouse_ID";

    public static MFAPRawMaterialConditioning createConditioningWeightCalculation(PO recordWeight) {
        return FarmingTechnicalAssistanceUtil.createConditioningWeightCalculation(recordWeight.getCtx(), recordWeight.get_ValueAsInt(COLUMNNAME_DD_RecordWeight_ID), null, null, -1, null, recordWeight.get_ValueAsString(COLUMNNAME_Description), recordWeight.get_TrxName(), "RW");
    }

    public static MFAPRawMaterialConditioning createConditioningWeightCalculation(Properties context, int recordWeightId, Map<String, Object> attributes, Timestamp documentDate, int documentTypeId, String documentAction, String desctiption, String transactionName, String usingType) {
        if (!Optional.of(MTable.get((Properties)context, (String)Table_Name_DD_RecordWeight)).isPresent()) {
            return null;
        }
        MFAPRawMaterialConditioning conditioning = new MFAPRawMaterialConditioning(context, 0, transactionName);
        conditioning.setDD_RecordWeight_ID(recordWeightId);
        int productId = FarmingTechnicalAssistanceUtil.getProductIdFromRecordWeight(context, recordWeightId, transactionName);
        int bPartnerId = 0;
        PO recordWeight = MTable.get((Properties)context, (String)Table_Name_DD_RecordWeight).getPO(recordWeightId, transactionName);
        if (productId > 0 && (recordWeight.get_ValueAsInt("C_Order_ID") > 0 || recordWeight.get_ValueAsInt("DD_Order_ID") > 0)) {
            if (recordWeight.get_ValueAsInt("C_Order_ID") > 0) {
                MOrder purchaseOrder = new MOrder(recordWeight.getCtx(), recordWeight.get_ValueAsInt("C_Order_ID"), recordWeight.get_TrxName());
                bPartnerId = purchaseOrder.getC_BPartner_ID();
            } else if (recordWeight.get_ValueAsInt("DD_Order_ID") > 0) {
                MDDOrder distributionOrder = new MDDOrder(recordWeight.getCtx(), recordWeight.get_ValueAsInt("DD_Order_ID"), recordWeight.get_TrxName());
                bPartnerId = distributionOrder.getC_BPartner_ID();
            }
            if (documentDate == null) {
                documentDate = (Timestamp)recordWeight.get_Value(COLUMNNAME_DateDoc);
            }
            if (Util.isEmpty((String)desctiption)) {
                desctiption = recordWeight.get_ValueAsString(COLUMNNAME_Description);
            }
            if (Util.isEmpty((String)documentAction) || !documentAction.equals("PR") && !documentAction.equals("CO")) {
                documentAction = "CO";
            }
            BigDecimal netWeight = (BigDecimal)recordWeight.get_Value(COLUMNNAME_NetWeight);
            if (documentTypeId > 0) {
                conditioning.setC_DocType_ID(documentTypeId);
            }
            conditioning.setDateDoc(documentDate);
            conditioning.setNetWeight(netWeight);
            conditioning.setM_Product_ID(productId);
            conditioning.setC_BPartner_ID(bPartnerId);
            conditioning.setDescription(desctiption);
            conditioning.setUsingType(usingType);
            conditioning.setDocStatus("DR");
            FarmingTechnicalAssistanceUtil.setFinancialReferencesFromDocument(recordWeight, conditioning);
            conditioning.setIsNegotiatedAttributes(attributes != null && attributes.size() > 0 || Optional.ofNullable(usingType).orElse("").equals("PC"));
            conditioning.saveEx();
            if (attributes == null || attributes.size() == 0) {
                FarmingTechnicalAssistanceUtil.getAttributesListFromRecordWeight(recordWeight.getCtx(), recordWeight.get_ValueAsInt(COLUMNNAME_DD_RecordWeight_ID), recordWeight.get_TrxName()).forEach(attribute -> {
                    String key = attribute.get_ValueAsString(COLUMNNAME_Code);
                    Object value = Optional.ofNullable(attribute.get_Value(COLUMNNAME_ValueString)).orElse(Optional.ofNullable(attribute.get_Value(COLUMNNAME_ValueNumber)).orElse(attribute.get_Value(COLUMNNAME_ValueDate)));
                    conditioning.adddAttribute(key, value, attribute.get_ValueAsString(COLUMNNAME_Description));
                });
            } else {
                attributes.entrySet().forEach(attribute -> conditioning.adddAttribute((String)attribute.getKey(), attribute.getValue(), null));
            }
            if (!conditioning.processIt(documentAction)) {
                throw new AdempiereException(conditioning.getProcessMsg());
            }
            conditioning.saveEx();
        }
        return conditioning;
    }

    public static List<PO> getAttributesListFromRecordWeight(Properties context, int recordWeightId, String transactionName) {
        List<Object> attributes = new ArrayList<PO>();
        if (Optional.of(MTable.get((Properties)context, (String)Table_Name_RM_QualityAnalysisAttributes)).isPresent()) {
            attributes = new Query(context, Table_Name_RM_QualityAnalysisAttributes, "EXISTS(SELECT 1 FROM RM_QualityAnalysis qa WHERE qa.RM_QualityAnalysis_ID = RM_AnalysisAttributes.RM_QualityAnalysis_ID AND qa.DD_RecordWeight_ID = ? AND qa.DocStatus IN('IP', 'CO', 'CL'))", transactionName).setParameters(new Object[]{recordWeightId}).list();
        }
        return attributes;
    }

    public static Map<String, Object> getAttributesMapFromRecordWeight(Properties context, int recordWeightId, String transactionName) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        FarmingTechnicalAssistanceUtil.getAttributesListFromRecordWeight(context, recordWeightId, transactionName).forEach(attribute -> {
            String key = attribute.get_ValueAsString(COLUMNNAME_Code);
            Object value = Optional.ofNullable(attribute.get_Value(COLUMNNAME_ValueString)).orElse(Optional.ofNullable(attribute.get_Value(COLUMNNAME_ValueNumber)).orElse(attribute.get_Value(COLUMNNAME_ValueDate)));
            attributes.put(key, value);
        });
        return attributes;
    }

    public static int getProductIdFromRecordWeight(Properties context, int recordWeightId, String transactionName) {
        PO qualityAnalysis;
        if (Optional.of(MTable.get((Properties)context, (String)Table_Name_RM_QualityAnalysis)).isPresent() && Optional.ofNullable(qualityAnalysis = new Query(context, Table_Name_RM_QualityAnalysis, "DD_RecordWeight_ID = ? AND DocStatus IN('IP', 'CO', 'CL')", transactionName).setParameters(new Object[]{recordWeightId}).first()).isPresent()) {
            return qualityAnalysis.get_ValueAsInt("M_Product_ID");
        }
        return 0;
    }

    public static List<PO> getQualityAnalysisFromFreightOrder(Properties context, int freightOrderId, String transactionName) {
        return new Query(context, Table_Name_RM_QualityAnalysis, "DD_Freight_ID = ? AND DocStatus IN('IP', 'CO')", transactionName).setParameters(new Object[]{freightOrderId}).list();
    }

    public static List<Integer> getBatchIdsFromAccountId(Properties context, int accountId, String transactionName) {
        if (accountId <= 0) {
            throw new AdempiereException("@FM_Account_ID@ @IsMandatory@");
        }
        return new Query(context, "FM_Batch", "DocStatus = 'CO' AND FM_Account_ID = ? ", transactionName).setParameters(new Object[]{accountId}).getIDsAsList();
    }

    public static MOrder getPurchaseOrderFromAgreement(Properties context, int agreementId, int accountId, String transactionName) {
        StringBuffer whereClause = new StringBuffer();
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        if (accountId > 0) {
            whereClause.append(" AND FM_Account_ID = ?");
            parameters.add(accountId);
        } else if (agreementId > 0) {
            whereClause.append(" AND FM_Agreement_ID = ?");
            parameters.add(agreementId);
        } else {
            throw new AdempiereException("@FM_Agreement_ID@ / @FM_Account_ID@ @IsMandatory@");
        }
        return (MOrder)new Query(context, "C_Order", "DocStatus = 'CO' AND IsFarmerAssistanceProgram = 'Y' AND IsSOTrx = 'N'" + whereClause.toString(), transactionName).setParameters(parameters).first();
    }

    public static void setDefaultFinancialAccountFromAgreement(PO document) {
        MFMAgreement agreement;
        if (!Optional.ofNullable(document).isPresent()) {
            return;
        }
        if (document.get_ValueAsInt("FM_Agreement_ID") > 0 && document.get_ValueAsInt("FM_Account_ID") <= 0 && (agreement = MFMAgreement.getById((Properties)document.getCtx(), (int)document.get_ValueAsInt("FM_Agreement_ID"), (String)document.get_TrxName())).get_ValueAsBoolean(COLUMNNAME_IsFarmerAssistanceProgram)) {
            MFAPFarmingDefinition farmingCostDefinition = new MFAPFarmingDefinition(document.getCtx(), agreement.get_ValueAsInt("FAP_FarmingDefinition_ID"), document.get_TrxName());
            agreement.getAccountProducts().stream().filter(accountProduct -> accountProduct.getFM_Product_ID() == farmingCostDefinition.getFM_Product_ID()).findFirst().ifPresent(account -> {
                document.set_ValueOfColumn("FM_Account_ID", (Object)account.getFM_Account_ID());
                document.saveEx();
            });
        }
    }

    public static void reverseConditioningReferencesOfRecordWeight(PO recordWeight) {
        FarmingTechnicalAssistanceUtil.getConditioningCalculationFromRecordWeight(recordWeight.getCtx(), recordWeight.get_ValueAsInt(COLUMNNAME_DD_RecordWeight_ID), recordWeight.get_TrxName()).forEach(conditioningCalculation -> {
            if (!conditioningCalculation.processIt("VO")) {
                throw new AdempiereException(conditioningCalculation.getProcessMsg());
            }
            conditioningCalculation.save(recordWeight.get_TrxName());
        });
    }

    public static void unlinkQualityAnalysisReferencesOfRecordWeight(PO recordWeight) {
        FarmingTechnicalAssistanceUtil.getQualityAnalysisFromRecordWeight(recordWeight.getCtx(), recordWeight.get_ValueAsInt(COLUMNNAME_DD_RecordWeight_ID), recordWeight.get_TrxName()).forEach(qualityAnalysis -> {
            qualityAnalysis.set_ValueOfColumn(COLUMNNAME_DD_RecordWeight_ID, null);
            qualityAnalysis.save();
        });
    }

    public static List<MFAPRawMaterialConditioning> getConditioningCalculationFromRecordWeight(Properties context, int recordWeightId, String transactionName) {
        return new Query(context, "FAP_RawMaterialConditioning", "DD_RecordWeight_ID = ? AND DocStatus IN('CO')", transactionName).setParameters(new Object[]{recordWeightId}).list();
    }

    public static List<PO> getQualityAnalysisFromRecordWeight(Properties context, int recordWeightId, String transactionName) {
        return new Query(context, Table_Name_RM_QualityAnalysis, "DD_RecordWeight_ID = ? AND DocStatus IN('CO')", transactionName).setParameters(new Object[]{recordWeightId}).list();
    }

    public static void setFinancialReferencesFromDocument(PO sourceDocument, PO targetDocument) {
        if (!Optional.ofNullable(sourceDocument).isPresent() || !Optional.ofNullable(targetDocument).isPresent()) {
            return;
        }
        if (sourceDocument.get_ValueAsInt("FM_Agreement_ID") > 0 && targetDocument.get_ValueAsInt("FM_Agreement_ID") <= 0) {
            targetDocument.set_ValueOfColumn("FM_Agreement_ID", (Object)sourceDocument.get_ValueAsInt("FM_Agreement_ID"));
        }
        if (sourceDocument.get_ValueAsInt("FM_Account_ID") > 0) {
            targetDocument.set_ValueOfColumn("FM_Account_ID", (Object)sourceDocument.get_ValueAsInt("FM_Account_ID"));
        }
        targetDocument.set_ValueOfColumn(COLUMNNAME_IsFarmerAssistanceProgram, (Object)sourceDocument.get_ValueAsBoolean(COLUMNNAME_IsFarmerAssistanceProgram));
    }

    public static void setDefaultFarmerOverdrafCreditLimitFromDocumentType(PO entity) {
        if (entity == null) {
            return;
        }
        if (!entity.is_ValueChanged("C_DocTypeTarget_ID") && !entity.is_ValueChanged(COLUMNNAME_C_DocType_ID)) {
            return;
        }
        int documentTypeId = entity.get_ValueAsInt("C_DocTypeTarget_ID");
        if (documentTypeId <= 0) {
            documentTypeId = entity.get_ValueAsInt(COLUMNNAME_C_DocType_ID);
        }
        if (documentTypeId <= 0) {
            return;
        }
        MDocType documentType = MDocType.get((Properties)entity.getCtx(), (int)documentTypeId);
        entity.set_ValueOfColumn(COLUMNNAME_IsFarmerOverdraftCreditLimit, (Object)documentType.get_ValueAsBoolean(COLUMNNAME_IsFarmerOverdraftCreditLimit));
    }

    public static void setRecordWeightReference(PO recordWeight) {
        if (recordWeight.get_ValueAsInt("C_Order_ID") > 0 || recordWeight.get_ValueAsInt("C_OrderLine_ID") > 0 || recordWeight.get_ValueAsInt("DD_Freight_ID") <= 0) {
            return;
        }
        MDDFreight freightOrder = new MDDFreight(recordWeight.getCtx(), recordWeight.get_ValueAsInt("DD_Freight_ID"), recordWeight.get_TrxName());
        AtomicInteger farmingId = new AtomicInteger(recordWeight.get_ValueAsInt("FAP_Farming_ID"));
        if (farmingId.get() <= 0) {
            freightOrder.getLines().stream().filter(freightOrderLine -> freightOrderLine.get_ValueAsInt("FAP_Farming_ID") > 0).findFirst().ifPresent(freightOrderLine -> farmingId.set(freightOrderLine.get_ValueAsInt("FAP_Farming_ID")));
        }
        if (farmingId.get() <= 0) {
            return;
        }
        MFAPFarming.getOrdersListOfFarming(recordWeight.getCtx(), farmingId.get(), false, recordWeight.get_TrxName()).stream().findFirst().ifPresent(order -> {
            recordWeight.set_ValueOfColumn("C_Order_ID", (Object)order.getC_Order_ID());
            Arrays.asList(order.getLines()).stream().findFirst().ifPresent(orderLine -> recordWeight.set_ValueOfColumn("C_OrderLine_ID", (Object)orderLine.getC_OrderLine_ID()));
        });
    }

    public static void updateFinancialAgreementBalanceFromAccountId(int accountId, boolean validate, String transactionName) {
        AtomicReference<BigDecimal> totalAmount = new AtomicReference<BigDecimal>(Env.ZERO);
        FarmingTechnicalAssistanceUtil.getBatchIdsFromAccountId(Env.getCtx(), accountId, transactionName).forEach(batchId -> {
            MFMBatch batch = new MFMBatch(Env.getCtx(), batchId.intValue(), transactionName);
            batch.getLines(true).forEach(transaction -> totalAmount.updateAndGet(transactionAmount -> transactionAmount.add(Optional.ofNullable(transaction.getAmount()).orElse(Env.ZERO))));
        });
        MFMAccount account = MFMAccount.getById((Properties)Env.getCtx(), (int)accountId, (String)transactionName);
        FarmingTechnicalAssistanceUtil.updateFinancialAgreementBalance(account.getFM_Agreement_ID(), totalAmount.get(), validate, transactionName);
    }

    public static void updateFinancialAgreementBalance(int agreementId, BigDecimal amount, boolean validate, String transactionName) {
        Optional.ofNullable(amount).ifPresent(amountForBalance -> {
            MFMAgreement agreement = new MFMAgreement(Env.getCtx(), agreementId, transactionName);
            BigDecimal creditLimit = Optional.ofNullable((BigDecimal)agreement.get_Value(COLUMNNAME_FarmerCreditLimit)).orElse(Env.ZERO);
            BigDecimal creditAvailable = Optional.ofNullable((BigDecimal)agreement.get_Value(COLUMNNAME_FarmerCreditAvailable)).orElse(Env.ZERO);
            BigDecimal creditUsed = Optional.ofNullable((BigDecimal)agreement.get_Value(COLUMNNAME_FarmerCreditUsed)).orElse(Env.ZERO);
            creditUsed = creditUsed.add((BigDecimal)amountForBalance);
            creditAvailable = creditLimit.subtract(creditUsed);
            if (validate && creditAvailable.compareTo(Env.ZERO) < 0) {
                throw new AdempiereException(FarmingTechnicalAssistanceUtil.getMessageWithParameters(agreement.getCtx(), "FAP.FarmerCreditLimitOverlaps", creditLimit, creditUsed, creditAvailable));
            }
            agreement.set_ValueOfColumn(COLUMNNAME_FarmerCreditUsed, (Object)creditUsed);
            agreement.set_ValueOfColumn(COLUMNNAME_FarmerCreditLimit, (Object)creditLimit);
            agreement.set_ValueOfColumn(COLUMNNAME_FarmerCreditAvailable, (Object)creditAvailable);
            agreement.saveEx();
        });
    }

    public static String getMessageWithParameters(Properties context, String message, Object ... parameters) {
        return Msg.getMsg((Properties)context, (String)message, (Object[])parameters);
    }

    public static List<PO> getQualityAnalysisFromPurchaseOrder(Properties context, int purchaseOrderId, String transactionName) {
        return new Query(context, Table_Name_RM_QualityAnalysis, "C_Order_ID = ? AND DocStatus IN('IP', 'CO')", transactionName).setParameters(new Object[]{purchaseOrderId}).list();
    }
}

