/*
 * Decompiled with CFR 0.152.
 */
package org.farming.test;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Properties;
import java.util.UUID;
import org.compiere.Adempiere;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.farming.engine.CategoryEngine;
import org.farming.engine.CategoryEngineFactory;
import org.farming.engine.Corn_ConditionedWeight;
import org.farming.engine.Rice_ConditionedWeight;
import org.farming.model.MFAPWeightCalculation;
import org.farming.model.MFAPWeightCalculationType;

public final class TestWeightCalculation {
    public void test1() {
        Adempiere.startup((boolean)true);
        Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (int)11);
        Trx.run(transactionName -> {
            String uuid = " (" + UUID.randomUUID().toString() + ")";
            MFAPWeightCalculationType conditionedWeightCalculationType = new MFAPWeightCalculationType(Env.getCtx(), 0, transactionName);
            conditionedWeightCalculationType.setValue("PesoAcondicionado" + uuid);
            conditionedWeightCalculationType.setName("Peso Acondicionado" + uuid);
            conditionedWeightCalculationType.saveEx();
            MFAPWeightCalculationType humidityWeightCalculationType = new MFAPWeightCalculationType(Env.getCtx(), 0, transactionName);
            humidityWeightCalculationType.setValue("PesoHumedad" + uuid);
            humidityWeightCalculationType.setName("Peso de Humedad" + uuid);
            humidityWeightCalculationType.saveEx();
            MFAPWeightCalculationType scrapWeightCalculationType = new MFAPWeightCalculationType(Env.getCtx(), 0, transactionName);
            scrapWeightCalculationType.setValue("PesoImpureza" + uuid);
            scrapWeightCalculationType.setName("Peso de Impureza" + uuid);
            scrapWeightCalculationType.saveEx();
            MProduct product = new MProduct(Env.getCtx(), 0, transactionName);
            product.setValue("Maiz" + uuid);
            product.setName("Ma\u00edz" + uuid);
            product.setDescription(uuid);
            product.setM_Product_Category_ID(new Query(Env.getCtx(), "M_Product_Category", "Value = ?", transactionName).setParameters(new Object[]{"Assembly"}).setClient_ID().firstId());
            product.setC_TaxCategory_ID(new Query(Env.getCtx(), "C_TaxCategory", "Name = ?", transactionName).setParameters(new Object[]{"Standard"}).setClient_ID().firstId());
            product.setC_UOM_ID(new Query(Env.getCtx(), "C_UOM", "X12DE355 = ?", transactionName).setParameters(new Object[]{"Kg"}).setClient_ID().firstId());
            product.set_ValueOfColumn("IsCategory", (Object)true);
            product.setProductType("I");
            product.saveEx();
            MFAPWeightCalculation conditionedWeightCalculation = new MFAPWeightCalculation(Env.getCtx(), 0, transactionName);
            conditionedWeightCalculation.setFAP_WeightCalculationType_ID(conditionedWeightCalculationType.getFAP_WeightCalculationType_ID());
            conditionedWeightCalculation.setValue("PesoAcondicionado" + uuid);
            conditionedWeightCalculation.setName("Peso Acondicionado" + uuid);
            conditionedWeightCalculation.setSeqNo(10);
            conditionedWeightCalculation.setClassname(Corn_ConditionedWeight.class.getName());
            conditionedWeightCalculation.setM_Product_ID(product.getM_Product_ID());
            conditionedWeightCalculation.setUsingType("RW");
            conditionedWeightCalculation.saveEx();
            MFAPWeightCalculation calculation = MFAPWeightCalculation.getOfProductAndUsingType(Env.getCtx(), product.getM_Product_ID(), "RW", transactionName);
            CategoryEngine engine = CategoryEngineFactory.getInstance().getEngine(calculation);
            BigDecimal netWeight = new BigDecimal(46280);
            BigDecimal humidity = new BigDecimal(23.8);
            BigDecimal scrap = new BigDecimal(3.2);
            BigDecimal expectedWeight = new BigDecimal(38791.9);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("Humidity", humidity);
            parameters.put("Scrap", scrap);
            System.out.println("**********************************Corn Testing**********************************");
            System.out.println("Net Weight: " + netWeight);
            System.out.println("Parameters: " + parameters);
            BigDecimal convertedWeight = engine.calculate(Env.getCtx(), 0, product.getM_Product_ID(), new Timestamp(System.currentTimeMillis()), netWeight, parameters, transactionName);
            System.out.println("Converted Weight: " + convertedWeight);
            conditionedWeightCalculation.delete(true);
            product.delete(true);
            conditionedWeightCalculationType.delete(true);
            humidityWeightCalculationType.delete(true);
            scrapWeightCalculationType.delete(true);
            System.out.println("Expected Conditioned weight: " + expectedWeight.setScale(2, 4));
            System.out.println("Conditioned weight: " + convertedWeight.setScale(2, 4));
            System.out.println("Equals: " + expectedWeight.setScale(2, 4).equals(convertedWeight.setScale(2, 4)));
            System.out.println("**********************************End Corn Testing**********************************");
        });
        Trx.run(transactionName -> {
            String uuid = " (" + UUID.randomUUID().toString() + ")";
            MFAPWeightCalculationType conditionedWeightCalculationType = new MFAPWeightCalculationType(Env.getCtx(), 0, transactionName);
            conditionedWeightCalculationType.setValue("PesoAcondicionado" + uuid);
            conditionedWeightCalculationType.setName("Peso Acondicionado" + uuid);
            conditionedWeightCalculationType.saveEx();
            MFAPWeightCalculationType humidityWeightCalculationType = new MFAPWeightCalculationType(Env.getCtx(), 0, transactionName);
            humidityWeightCalculationType.setValue("PesoHumedad" + uuid);
            humidityWeightCalculationType.setName("Peso de Humedad" + uuid);
            humidityWeightCalculationType.saveEx();
            MFAPWeightCalculationType scrapWeightCalculationType = new MFAPWeightCalculationType(Env.getCtx(), 0, transactionName);
            scrapWeightCalculationType.setValue("PesoImpureza" + uuid);
            scrapWeightCalculationType.setName("Peso de Impureza" + uuid);
            scrapWeightCalculationType.saveEx();
            MProduct product = new MProduct(Env.getCtx(), 0, transactionName);
            product.setValue("Maiz" + uuid);
            product.setName("Ma\u00edz" + uuid);
            product.setDescription(uuid);
            product.setM_Product_Category_ID(new Query(Env.getCtx(), "M_Product_Category", "Value = ?", transactionName).setParameters(new Object[]{"Assembly"}).setClient_ID().firstId());
            product.setC_TaxCategory_ID(new Query(Env.getCtx(), "C_TaxCategory", "Name = ?", transactionName).setParameters(new Object[]{"Standard"}).setClient_ID().firstId());
            product.setC_UOM_ID(new Query(Env.getCtx(), "C_UOM", "X12DE355 = ?", transactionName).setParameters(new Object[]{"Kg"}).setClient_ID().firstId());
            product.set_ValueOfColumn("IsCategory", (Object)true);
            product.setProductType("I");
            product.saveEx();
            MFAPWeightCalculation conditionedWeightCalculation = new MFAPWeightCalculation(Env.getCtx(), 0, transactionName);
            conditionedWeightCalculation.setFAP_WeightCalculationType_ID(conditionedWeightCalculationType.getFAP_WeightCalculationType_ID());
            conditionedWeightCalculation.setValue("PesoAcondicionado" + uuid);
            conditionedWeightCalculation.setName("Peso Acondicionado" + uuid);
            conditionedWeightCalculation.setSeqNo(10);
            conditionedWeightCalculation.setClassname(Rice_ConditionedWeight.class.getName());
            conditionedWeightCalculation.setM_Product_ID(product.getM_Product_ID());
            conditionedWeightCalculation.setUsingType("RW");
            conditionedWeightCalculation.saveEx();
            MFAPWeightCalculation calculation = MFAPWeightCalculation.getOfProductAndUsingType(Env.getCtx(), product.getM_Product_ID(), "RW", transactionName);
            CategoryEngine engine = CategoryEngineFactory.getInstance().getEngine(calculation);
            BigDecimal netWeight = new BigDecimal(15060);
            BigDecimal humidity = new BigDecimal(26.5);
            BigDecimal scrap = new BigDecimal(3.58);
            BigDecimal greenBean = new BigDecimal(1);
            BigDecimal expectedWeight = new BigDecimal(11980.09);
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("Humidity", humidity);
            parameters.put("Scrap", scrap);
            parameters.put("GreenBeans", greenBean);
            System.out.println("**********************************Rice Testing**********************************");
            System.out.println("Net Weight: " + netWeight);
            System.out.println("Parameters: " + parameters);
            BigDecimal convertedWeight = engine.calculate(Env.getCtx(), 0, product.getM_Product_ID(), new Timestamp(System.currentTimeMillis()), netWeight, parameters, transactionName);
            System.out.println("Converted Weight: " + convertedWeight);
            conditionedWeightCalculation.delete(true);
            product.delete(true);
            conditionedWeightCalculationType.delete(true);
            humidityWeightCalculationType.delete(true);
            scrapWeightCalculationType.delete(true);
            System.out.println("Expected Conditioned weight: " + expectedWeight.setScale(2, 4));
            System.out.println("Conditioned weight: " + convertedWeight.setScale(2, 4));
            System.out.println("Equals: " + expectedWeight.setScale(2, 4).equals(convertedWeight.setScale(2, 4)));
            System.out.println("**********************************End Rice Testing**********************************");
        });
    }

    public static void main(String[] args) {
        new TestWeightCalculation().test1();
    }
}

