/*
 * Decompiled with CFR 0.152.
 */
package org.farming.setup;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeUse;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCharge;
import org.compiere.model.MCountry;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MLocation;
import org.compiere.model.MPeriod;
import org.compiere.model.MPeriodControl;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MRegion;
import org.compiere.model.MTable;
import org.compiere.model.MUOM;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.eevolution.model.MDDVehicleType;
import org.eevolution.service.dsl.ProcessBuilder;
import org.farming.engine.Corn_ConditionedWeight;
import org.farming.engine.Legumes_ConditionedWeight;
import org.farming.engine.Rice_ConditionedWeight;
import org.farming.engine.financing.Charge;
import org.farming.engine.financing.Invoice;
import org.farming.engine.financing.Order;
import org.farming.engine.financing.Payment;
import org.farming.engine.financing.RawMaterialConditioning;
import org.farming.model.MFAPDefintionCategory;
import org.farming.model.MFAPFarm;
import org.farming.model.MFAPFarmDivision;
import org.farming.model.MFAPFarming;
import org.farming.model.MFAPFarmingAllocation;
import org.farming.model.MFAPFarmingDefinition;
import org.farming.model.MFAPFarmingStage;
import org.farming.model.MFAPObservationType;
import org.farming.model.MFAPPlantingCycle;
import org.farming.model.MFAPWeightCalculation;
import org.farming.model.MFAPWeightCalculationType;
import org.spin.model.MFMAccount;
import org.spin.model.MFMAccountProduct;
import org.spin.model.MFMAgreement;
import org.spin.model.MFMAgreementType;
import org.spin.model.MFMFunctionalApplicability;
import org.spin.model.MFMFunctionalSetting;
import org.spin.model.MFMProduct;
import org.spin.model.MFMProductCategory;
import org.spin.model.MFMTransactionType;
import org.spin.util.ISetupDefinition;

public final class TestingSetup
implements ISetupDefinition {
    private static final String SETUP_UUID = "(*FAP_AutomaticSetup*)";
    private static final String SETUP_DESCRIPTION = "(*Creado desde el Setup del Programa de Asistencia al Productor Autom\u00e1ticamente*)";

    public String doIt(Properties context, String transactionName) {
        this.removeSetup(transactionName);
        this.createVehicleType("C01", "Gandola de 30 TONS", new BigDecimal(30000), transactionName);
        MFAPWeightCalculationType conditionedWeightCalculationType = new MFAPWeightCalculationType(Env.getCtx(), 0, transactionName);
        conditionedWeightCalculationType.setValue("PesoAcondicionado");
        conditionedWeightCalculationType.setName("Peso Acondicionado");
        conditionedWeightCalculationType.setDescription(SETUP_DESCRIPTION);
        conditionedWeightCalculationType.setUUID(SETUP_UUID);
        conditionedWeightCalculationType.setIsDirectLoad(true);
        conditionedWeightCalculationType.saveEx();
        MFAPWeightCalculationType humidityWeightCalculationType = new MFAPWeightCalculationType(Env.getCtx(), 0, transactionName);
        humidityWeightCalculationType.setValue("PesoHumedad");
        humidityWeightCalculationType.setName("Peso de Humedad");
        humidityWeightCalculationType.setDescription(SETUP_DESCRIPTION);
        humidityWeightCalculationType.setUUID(SETUP_UUID);
        humidityWeightCalculationType.setIsDirectLoad(true);
        humidityWeightCalculationType.saveEx();
        MFAPWeightCalculationType scrapWeightCalculationType = new MFAPWeightCalculationType(Env.getCtx(), 0, transactionName);
        scrapWeightCalculationType.setValue("PesoImpureza");
        scrapWeightCalculationType.setName("Peso de Impureza");
        scrapWeightCalculationType.setDescription(SETUP_DESCRIPTION);
        scrapWeightCalculationType.setUUID(SETUP_UUID);
        scrapWeightCalculationType.setIsDirectLoad(true);
        scrapWeightCalculationType.saveEx();
        MProduct category = this.createCategory("MA", "Ma\u00edz Amarillo", conditionedWeightCalculationType.getFAP_WeightCalculationType_ID(), Corn_ConditionedWeight.class.getName(), true, transactionName);
        MAttribute humidity = this.createAttribute("Humidity", "Humedad", transactionName);
        MAttribute scrap = this.createAttribute("Scrap", "Impureza", transactionName);
        MAttribute greenBean = this.createAttribute("GreenBeans", "Granos Verdes", transactionName);
        MAttributeSet cornAttributeSet = this.createAttributeSet("Atributos de Ma\u00edz", transactionName);
        this.createAttributeUse(cornAttributeSet.getM_AttributeSet_ID(), humidity.getM_Attribute_ID(), 10, transactionName);
        this.createAttributeUse(cornAttributeSet.getM_AttributeSet_ID(), scrap.getM_Attribute_ID(), 20, transactionName);
        category.setM_AttributeSet_ID(cornAttributeSet.getM_AttributeSet_ID());
        category.saveEx();
        category = this.createCategory("FC", "Frijol Chino", conditionedWeightCalculationType.getFAP_WeightCalculationType_ID(), Legumes_ConditionedWeight.class.getName(), true, transactionName);
        MAttribute ground = this.createAttribute("Ground", "Tierra", transactionName);
        MAttribute grainScrap = this.createAttribute("Scrap", "Desperdicio", transactionName);
        MAttribute brokenGrains = this.createAttribute("Broken_Grains", "Granos Partidos", transactionName);
        MAttributeSet legumesAttributeSet = this.createAttributeSet("Atributos de Frijol", transactionName);
        this.createAttributeUse(cornAttributeSet.getM_AttributeSet_ID(), ground.getM_Attribute_ID(), 10, transactionName);
        this.createAttributeUse(cornAttributeSet.getM_AttributeSet_ID(), grainScrap.getM_Attribute_ID(), 20, transactionName);
        this.createAttributeUse(cornAttributeSet.getM_AttributeSet_ID(), brokenGrains.getM_Attribute_ID(), 30, transactionName);
        category.setM_AttributeSet_ID(legumesAttributeSet.getM_AttributeSet_ID());
        category.saveEx();
        MAttributeSet riceAttributeSet = this.createAttributeSet("Atributos de Arroz", transactionName);
        this.createAttributeUse(riceAttributeSet.getM_AttributeSet_ID(), humidity.getM_Attribute_ID(), 10, transactionName);
        this.createAttributeUse(riceAttributeSet.getM_AttributeSet_ID(), scrap.getM_Attribute_ID(), 20, transactionName);
        this.createAttributeUse(riceAttributeSet.getM_AttributeSet_ID(), greenBean.getM_Attribute_ID(), 30, transactionName);
        category = this.createCategory("MB", "Ma\u00edz Blanco", conditionedWeightCalculationType.getFAP_WeightCalculationType_ID(), Corn_ConditionedWeight.class.getName(), true, transactionName);
        category.setM_AttributeSet_ID(cornAttributeSet.getM_AttributeSet_ID());
        category.saveEx();
        this.createCategory("SO", "Sorgo", 0, null, true, transactionName);
        category = this.createCategory("AR", "Arroz", conditionedWeightCalculationType.getFAP_WeightCalculationType_ID(), Rice_ConditionedWeight.class.getName(), true, transactionName);
        category.setM_AttributeSet_ID(riceAttributeSet.getM_AttributeSet_ID());
        category.saveEx();
        this.createCategory("AJ", "Ajonjol\u00ed", 0, null, true, transactionName);
        this.createCategory("GI", "Girasol", 0, null, true, transactionName);
        this.createObservationType("CocoJui-juao", "Coco Jui-juao", transactionName);
        this.createObservationType("Enfermedades", "Enfermedades", transactionName);
        this.createObservationType("GusanoBarredor", "Gusano Barredor", transactionName);
        this.createObservationType("TierraslistasparalaSiembra", "Tierras listas para la Siembra", transactionName);
        this.createObservationType("Etapadecosecha", "Etapa de cosecha", transactionName);
        this.createObservationType("Malezas(Gramineas,Cyperaceas,Hojaancha)", "Malezas (Gramineas, Cyperaceas, Hoja ancha)", transactionName);
        this.createObservationType("Coleopteros", "Coleopteros", transactionName);
        this.createObservationType("DeficienciasNutricionales", "Deficiencias Nutricionales", transactionName);
        this.createObservationType("Aves(Pajaros,Perico)", "Aves (Pajaros, Perico)", transactionName);
        this.createObservationType("Larva(Cortador,barredor,cogollero,enrrollador)", "Larva (Cortador, barredor, cogollero, enrrollador)", transactionName);
        this.createObservationType("Hem\u00edpteros(Chinches)", "Hem\u00edpteros (Chinches)", transactionName);
        this.createObservationType("Hom\u00f3pteros(Afidos)", "Hom\u00f3pteros (Afidos)", transactionName);
        this.createObservationType("Reptiles", "Reptiles", transactionName);
        this.createObservationType("Bachaco", "Bachaco", transactionName);
        this.createPlantingCycle("Invierno", "Invierno", TimeUtil.getDay((int)2020, (int)5, (int)1), TimeUtil.addMonths((Timestamp)TimeUtil.getDay((int)2020, (int)5, (int)1), (int)6), transactionName);
        MFAPPlantingCycle plantingCycle = this.createPlantingCycle("Verano", "Verano", TimeUtil.getDay((int)2020, (int)11, (int)30), TimeUtil.addMonths((Timestamp)TimeUtil.getDay((int)2020, (int)11, (int)30), (int)6), transactionName);
        this.createFarmer("J400788315", "E.R.P. Consultores y Asociados, C.A.", plantingCycle, transactionName);
        return "@AD_SetupDefinition_ID@ @Ok@";
    }

    private MDDVehicleType createVehicleType(String value, String name, BigDecimal weight, String transactionName) {
        MDDVehicleType vehicleType = new MDDVehicleType(Env.getCtx(), 0, transactionName);
        vehicleType.setValue(value);
        vehicleType.setName(name);
        vehicleType.setVehicleType("TRC");
        vehicleType.setMaximumWeight(weight);
        vehicleType.setWeight_UOM_ID(((MUOM)new Query(Env.getCtx(), "C_UOM", "X12DE355 = ?", transactionName).setParameters(new Object[]{"Kg"}).first()).getC_UOM_ID());
        vehicleType.setVolume_UOM_ID(((MUOM)new Query(Env.getCtx(), "C_UOM", "X12DE355 = ?", transactionName).setParameters(new Object[]{"L"}).first()).getC_UOM_ID());
        vehicleType.setDescription(SETUP_DESCRIPTION);
        vehicleType.setUUID(SETUP_UUID);
        vehicleType.setIsDirectLoad(true);
        vehicleType.saveEx();
        return vehicleType;
    }

    private MAttribute createAttribute(String value, String name, String transactionName) {
        MAttribute attribute = new MAttribute(Env.getCtx(), 0, transactionName);
        attribute.set_ValueOfColumn("Value", (Object)value);
        attribute.setName(name);
        attribute.setAttributeValueType("N");
        attribute.setDescription(SETUP_DESCRIPTION);
        attribute.setIsInstanceAttribute(true);
        attribute.setUUID(SETUP_UUID);
        attribute.setIsDirectLoad(true);
        attribute.saveEx();
        return attribute;
    }

    private MAttributeSet createAttributeSet(String name, String transactionName) {
        MAttributeSet attributeSet = new MAttributeSet(Env.getCtx(), 0, transactionName);
        attributeSet.setName(name);
        attributeSet.setIsInstanceAttribute(true);
        attributeSet.setMandatoryType("N");
        attributeSet.setDescription(SETUP_DESCRIPTION);
        attributeSet.setUUID(SETUP_UUID);
        attributeSet.setIsDirectLoad(true);
        attributeSet.saveEx();
        return attributeSet;
    }

    private MAttributeUse createAttributeUse(int attributeSetId, int attributeId, int seqNo, String transactionName) {
        MAttributeUse attributeUse = new MAttributeUse(Env.getCtx(), 0, transactionName);
        attributeUse.setSeqNo(seqNo);
        attributeUse.setM_AttributeSet_ID(attributeSetId);
        attributeUse.setM_Attribute_ID(attributeId);
        attributeUse.setUUID(SETUP_UUID);
        attributeUse.setIsDirectLoad(true);
        attributeUse.saveEx();
        return attributeUse;
    }

    private MFAPPlantingCycle createPlantingCycle(String value, String name, Timestamp startDate, Timestamp endDate, String transactionName) {
        MFAPPlantingCycle plantingCycle = new MFAPPlantingCycle(Env.getCtx(), 0, transactionName);
        plantingCycle.setValue(value);
        plantingCycle.setName(name);
        plantingCycle.setDescription(SETUP_DESCRIPTION);
        plantingCycle.setStartDate(startDate);
        plantingCycle.setEndDate(endDate);
        plantingCycle.setUUID(SETUP_UUID);
        plantingCycle.setIsDirectLoad(true);
        plantingCycle.saveEx();
        return plantingCycle;
    }

    private MFAPObservationType createObservationType(String value, String name, String transactionName) {
        MFAPObservationType observationType = new MFAPObservationType(Env.getCtx(), 0, transactionName);
        observationType.setValue(value);
        observationType.setName(name);
        observationType.setDescription(SETUP_DESCRIPTION);
        observationType.setUUID(SETUP_UUID);
        observationType.setIsDirectLoad(true);
        observationType.saveEx();
        return observationType;
    }

    private MProduct createCategory(String value, String name, int weightCalculationTypeId, String className, boolean withFarmingStage, String transactionName) {
        MProduct category = new MProduct(Env.getCtx(), 0, transactionName);
        category.setValue(value);
        category.setName(name);
        category.setDescription(SETUP_DESCRIPTION);
        category.setM_Product_Category_ID(new Query(Env.getCtx(), "M_Product_Category", null, transactionName).setClient_ID().firstId());
        category.setC_TaxCategory_ID(new Query(Env.getCtx(), "C_TaxCategory", null, transactionName).setClient_ID().firstId());
        category.setC_UOM_ID(new Query(Env.getCtx(), "C_UOM", "X12DE355 = ?", transactionName).setParameters(new Object[]{"Kg"}).firstId());
        category.set_ValueOfColumn("IsCategory", (Object)true);
        category.setProductType("I");
        category.saveEx();
        category.setUUID(SETUP_UUID);
        category.setIsDirectLoad(true);
        category.saveEx();
        this.createPriceList(category.getM_Product_ID(), null, transactionName);
        if (weightCalculationTypeId > 0) {
            MFAPWeightCalculationType weightCalculationType = new MFAPWeightCalculationType(Env.getCtx(), weightCalculationTypeId, transactionName);
            MFAPWeightCalculation conditionedWeightCalculation = new MFAPWeightCalculation(Env.getCtx(), 0, transactionName);
            conditionedWeightCalculation.setFAP_WeightCalculationType_ID(weightCalculationTypeId);
            conditionedWeightCalculation.setValue(weightCalculationType.getValue());
            conditionedWeightCalculation.setName(weightCalculationType.getName());
            conditionedWeightCalculation.setDescription(SETUP_DESCRIPTION);
            conditionedWeightCalculation.setSeqNo(10);
            conditionedWeightCalculation.setClassname(className);
            conditionedWeightCalculation.setM_Product_ID(category.getM_Product_ID());
            conditionedWeightCalculation.setUsingType("RW");
            conditionedWeightCalculation.setUUID(SETUP_UUID);
            conditionedWeightCalculation.setIsDirectLoad(true);
            conditionedWeightCalculation.saveEx();
        }
        if (withFarmingStage) {
            AtomicInteger sequence = new AtomicInteger(10);
            this.createFarmingStage("Preparaci\u00f3ndetierra", "Preparaci\u00f3n de tierra", 0, 0, sequence.getAndAdd(10), category.getM_Product_ID(), transactionName);
            this.createFarmingStage("Siembra", "Siembra", 0, 0, sequence.getAndAdd(10), category.getM_Product_ID(), transactionName);
            this.createFarmingStage("Fertilizaci\u00f3n", "Fertilizaci\u00f3n", 0, 0, sequence.getAndAdd(10), category.getM_Product_ID(), transactionName);
            this.createFarmingStage("Germinaci\u00f3n", "Germinaci\u00f3n", 1, 5, sequence.getAndAdd(10), category.getM_Product_ID(), transactionName);
            this.createFarmingStage("PrimerReabono", "Primer Reabono", 0, 0, sequence.getAndAdd(10), category.getM_Product_ID(), transactionName);
            this.createFarmingStage("HerbicidasPre-Siembra", "Herbicidas Pre-Siembra", 0, 0, sequence.getAndAdd(10), category.getM_Product_ID(), transactionName);
            this.createFarmingStage("DesarrolloVegetativo", "Desarrollo Vegetativo", 6, 45, sequence.getAndAdd(10), category.getM_Product_ID(), transactionName);
            this.createFarmingStage("HerbicidasPre-Emergente", "Herbicidas Pre-Emergente", 0, 0, sequence.getAndAdd(10), category.getM_Product_ID(), transactionName);
            this.createFarmingStage("SegundoReabono", "Segundo Reabono", 0, 0, sequence.getAndAdd(10), category.getM_Product_ID(), transactionName);
            this.createFarmingStage("Foliar", "Foliar", 0, 0, sequence.getAndAdd(10), category.getM_Product_ID(), transactionName);
            this.createFarmingStage("Floraci\u00f3n", "Floraci\u00f3n", 46, 60, sequence.getAndAdd(10), category.getM_Product_ID(), transactionName);
            this.createFarmingStage("HerbicidasPost-Emergente", "Herbicidas Post-Emergente", 0, 0, sequence.getAndAdd(10), category.getM_Product_ID(), transactionName);
            this.createFarmingStage("Formaci\u00f3nyllenadodegrano", "Formaci\u00f3n y llenado de grano", 61, 80, sequence.getAndAdd(10), category.getM_Product_ID(), transactionName);
            this.createFarmingStage("Insecticida", "Insecticida", 0, 0, sequence.getAndAdd(10), category.getM_Product_ID(), transactionName);
            this.createFarmingStage("Secado", "Secado", 81, 120, sequence.getAndAdd(10), category.getM_Product_ID(), transactionName);
            this.createFarmingStage("Fungicida", "Fungicida", 0, 0, sequence.getAndAdd(10), category.getM_Product_ID(), transactionName);
            this.createFarmingStage("Cosecha", "Cosecha", 121, 130, sequence.getAndAdd(10), category.getM_Product_ID(), transactionName);
        }
        return category;
    }

    private void createFarmerCreditDefinition(MBPartner farmer, MFAPFarm farm, MFAPPlantingCycle plantingCycle, String transactionName) {
        this.createTransactionType("FFO", "OFA", "\u00d3rdenes de Financiamiento Agr\u00edcola", transactionName);
        this.createTransactionType("FFI", "FFA", "Facturaci\u00f3n de Financiamiento Agr\u00edcola", transactionName);
        this.createTransactionType("FFT", "IFA", "Impuesto de Financiamiento Agr\u00edcola", transactionName);
        this.createTransactionType("FFP", "PFA", "Pago de Financiamiento Agr\u00edcola", transactionName);
        this.createTransactionType("FFR", "RFA", "Recepci\u00f3n de Financiamiento Agr\u00edcola", transactionName);
        this.createTransactionType("FFL", "LFA", "Liquidaci\u00f3n de Financiamiento Agr\u00edcola", transactionName);
        this.createTransactionType("FFC", "CFA", "Cargo de financiamiento Agr\u00edcola", transactionName);
        this.createTransactionType("FFC", "AFA", "Abono de financiamiento Agr\u00edcola", transactionName);
        this.createTransactionType("FFN", "CFA", "Inter\u00e9s sobre Factura Agr\u00edcola", transactionName);
        this.createTransactionType("FFX", "AFA", "Impuesto de Inter\u00e9s dobre Factura Agr\u00edcola", transactionName);
        MFMAgreementType agreementType = new MFMAgreementType(Env.getCtx(), 0, transactionName);
        agreementType.setValue("ContratoLineadeCredito");
        agreementType.setName("Contrato L\u00ednea de Cr\u00e9dito");
        agreementType.setDescription(SETUP_DESCRIPTION);
        agreementType.setText("Este contrato se usa para efectos de prueba de l\u00ednea de cr\u00e9dito y se gener\u00f3 autom\u00e1ticamente desde el setup inicial de la funcionalidad de financiamiento agr\u00edcola, si requiere hacer cambios en el mismo deber\u00e1 crear uno diferente puesto que el mismo puede ser eliminado de manera autom\u00e1tica");
        agreementType.setUUID(SETUP_UUID);
        agreementType.setIsDirectLoad(true);
        agreementType.saveEx();
        MDocType documentType = this.createDocumentType("FMA", "L\u00ednea de Cr\u00e9dito a Productor", transactionName);
        documentType = this.createDocumentType("FMB", "Lote de Transacci\u00f3n de Cr\u00e9dito", transactionName);
        documentType = this.createDocumentType("FRO", "Orden de Flete (Materia Prima)", transactionName);
        documentType = this.createDocumentType("FDD", "Costo de Ma\u00edz", transactionName);
        documentType = this.createDocumentType("DRW", "Registro de Peso", transactionName);
        documentType = this.createDocumentType("RMQ", "An\u00e1lisis de Calidad", transactionName);
        documentType = this.createDocumentType("FFD", "Cultivo", transactionName);
        documentType = this.createDocumentType("FCR", "Calculo de Peso Acondicionado", transactionName);
        MFMProductCategory financialProductCategory = new MFMProductCategory(Env.getCtx(), 0, transactionName);
        financialProductCategory.setValue("LCP");
        financialProductCategory.setName("L\u00ednea de Cr\u00e9dito a Productor");
        financialProductCategory.setType("L");
        financialProductCategory.setDescription(SETUP_DESCRIPTION);
        financialProductCategory.setUUID(SETUP_UUID);
        financialProductCategory.setIsDirectLoad(true);
        financialProductCategory.saveEx();
        MFMFunctionalSetting functionalSetting = this.createFunctionalSetting("OC", "Orden a Cuenta de Cr\u00e9dito", Order.class.getName(), transactionName);
        this.createApplicability(functionalSetting.getFM_FunctionalSetting_ID(), financialProductCategory.getFM_ProductCategory_ID(), "C_Order", "T", "DACO", transactionName);
        this.createApplicability(functionalSetting.getFM_FunctionalSetting_ID(), financialProductCategory.getFM_ProductCategory_ID(), "C_Order", "T", "DAVO", transactionName);
        functionalSetting = this.createFunctionalSetting("FC", "Facturaci\u00f3n a Cuenta de Cr\u00e9dito", Invoice.class.getName(), transactionName);
        this.createApplicability(functionalSetting.getFM_FunctionalSetting_ID(), financialProductCategory.getFM_ProductCategory_ID(), "C_Invoice", "T", "DACO", transactionName);
        functionalSetting = this.createFunctionalSetting("AC", "Anticipo a Cuenta de Cr\u00e9dito", Payment.class.getName(), transactionName);
        this.createApplicability(functionalSetting.getFM_FunctionalSetting_ID(), financialProductCategory.getFM_ProductCategory_ID(), "C_Payment", "T", "DACO", transactionName);
        functionalSetting = this.createFunctionalSetting("LC", "Liquidaci\u00f3n de Cuenta de Cr\u00e9dito", RawMaterialConditioning.class.getName(), transactionName);
        this.createApplicability(functionalSetting.getFM_FunctionalSetting_ID(), financialProductCategory.getFM_ProductCategory_ID(), "FAP_RawMaterialConditioning", "T", "DACO", transactionName);
        this.createApplicability(functionalSetting.getFM_FunctionalSetting_ID(), financialProductCategory.getFM_ProductCategory_ID(), "FAP_RawMaterialConditioning", "T", "DAVO", transactionName);
        functionalSetting = this.createFunctionalSetting("CC", "Abono / Cargo a Cr\u00e9dito", Charge.class.getName(), transactionName);
        this.createApplicability(functionalSetting.getFM_FunctionalSetting_ID(), financialProductCategory.getFM_ProductCategory_ID(), null, "P", null, transactionName);
        MFMProduct financialProduct = this.createFinancialProduct(financialProductCategory.getFM_ProductCategory_ID(), "CP", "Cr\u00e9dito a Productor", transactionName);
        MFAPFarmingDefinition cornDefinition = this.createFarmingDefinition("CostoMa\u00edz", documentType.getC_DocType_ID(), agreementType.getFM_AgreementType_ID(), new BigDecimal(325.6), financialProduct.getFM_Product_ID(), new Query(Env.getCtx(), "M_Product", "Value IN(?, ?)", transactionName).setParameters(new Object[]{"MA", "MB"}).list(), transactionName);
        this.createFarmingDefinition("CostoArroz", documentType.getC_DocType_ID(), agreementType.getFM_AgreementType_ID(), new BigDecimal(155.9), financialProduct.getFM_Product_ID(), new Query(Env.getCtx(), "M_Product", "Value IN(?)", transactionName).setParameters(new Object[]{"AR"}).list(), transactionName);
        this.createFarmingDefinition("CostoSorgo", documentType.getC_DocType_ID(), agreementType.getFM_AgreementType_ID(), new BigDecimal(220.9), financialProduct.getFM_Product_ID(), new Query(Env.getCtx(), "M_Product", "Value IN(?)", transactionName).setParameters(new Object[]{"SO"}).list(), transactionName);
        this.createFarmingDefinition("CostoGirasol", documentType.getC_DocType_ID(), agreementType.getFM_AgreementType_ID(), new BigDecimal(130), financialProduct.getFM_Product_ID(), new Query(Env.getCtx(), "M_Product", "Value IN(?)", transactionName).setParameters(new Object[]{"GI"}).list(), transactionName);
        this.createFarmingDefinition("CostoAjonjol\u00ed", documentType.getC_DocType_ID(), agreementType.getFM_AgreementType_ID(), new BigDecimal(256.45), financialProduct.getFM_Product_ID(), new Query(Env.getCtx(), "M_Product", "Value IN(?)", transactionName).setParameters(new Object[]{"AJ"}).list(), transactionName);
        MFAPFarming farming = this.createFarming("CultivoMa\u00edz", documentType.getC_DocType_ID(), farmer.getC_BPartner_ID(), farm.getFAP_Farm_ID(), 0, plantingCycle.getFAP_PlantingCycle_ID(), ((MProduct)new Query(Env.getCtx(), "M_Product", "Value IN(?)", transactionName).setParameters(new Object[]{"MA"}).first()).getM_Product_ID(), new BigDecimal(12.6), transactionName);
        this.createAgreement(farmer.getC_BPartner_ID(), documentType.getC_DocType_ID(), agreementType.getFM_AgreementType_ID(), cornDefinition.getFAP_FarmingDefinition_ID(), financialProductCategory.getFM_ProductCategory_ID(), farming.getFAP_Farming_ID(), transactionName);
    }

    private MDocType createDocumentType(String documentBaseType, String name, String transactionName) {
        MDocType documentType = (MDocType)new Query(Env.getCtx(), "C_DocType", "DocBaseType = ? AND PrintName = ?", transactionName).setParameters(new Object[]{documentBaseType, name}).setClient_ID().first();
        if (documentType != null && documentType.getC_DocType_ID() > 0) {
            return documentType;
        }
        documentType = new MDocType(Env.getCtx(), 0, transactionName);
        documentType.setName(name);
        documentType.setPrintName(name);
        documentType.setDocBaseType(documentBaseType);
        documentType.setGL_Category_ID();
        documentType.setIsSOTrx(true);
        documentType.setDescription(SETUP_DESCRIPTION);
        documentType.saveEx();
        documentType.setUUID(SETUP_UUID);
        documentType.setIsDirectLoad(true);
        documentType.saveEx();
        ProcessBuilder.create((Properties)Env.getCtx()).process(Integer.valueOf(233)).withoutTransactionClose().execute(transactionName);
        MPeriod period = MPeriod.get((Properties)Env.getCtx(), (Timestamp)TimeUtil.getDay((long)System.currentTimeMillis()), (int)Env.getAD_Org_ID((Properties)Env.getCtx()));
        if (period != null) {
            period.set_TrxName(transactionName);
            MPeriodControl periodControl = period.getPeriodControl(documentBaseType);
            if (periodControl != null) {
                periodControl.setPeriodStatus("O");
                periodControl.saveEx(transactionName);
            }
        }
        return documentType;
    }

    private MFMTransactionType createTransactionType(String type, String value, String name, String transactionName) {
        MFMTransactionType transactionType = new MFMTransactionType(Env.getCtx(), 0, transactionName);
        transactionType.setValue(value);
        transactionType.setName(name);
        transactionType.setType(type);
        transactionType.setUUID(SETUP_UUID);
        transactionType.setIsDirectLoad(true);
        transactionType.saveEx();
        return transactionType;
    }

    private MFAPFarming createFarming(String documentNo, int documentTypeId, int businessPartnerId, int farmId, int divisionId, int plantingCycleId, int categoryId, BigDecimal area, String transactionName) {
        MFAPFarming farming = new MFAPFarming(Env.getCtx(), 0, transactionName);
        farming.setDocumentNo(documentNo);
        farming.setDateDoc(TimeUtil.getDay((long)System.currentTimeMillis()));
        farming.setStartDate(TimeUtil.getDay((long)System.currentTimeMillis()));
        farming.setC_DocType_ID(documentTypeId);
        farming.setC_BPartner_ID(businessPartnerId);
        farming.setFAP_Farm_ID(farmId);
        farming.setArea(area);
        farming.setFinancingType("A");
        farming.setStatus("M");
        if (divisionId > 0) {
            farming.setFAP_FarmDivision_ID(divisionId);
        }
        farming.setCategory_ID(categoryId);
        farming.setFAP_PlantingCycle_ID(plantingCycleId);
        farming.setDescription(SETUP_DESCRIPTION);
        farming.setUUID(SETUP_UUID);
        farming.setIsDirectLoad(true);
        farming.saveEx();
        farming.setIsDirectLoad(false);
        farming.setDocStatus("DR");
        farming.processIt("PR");
        farming.setDocStatus("CO");
        farming.setDocAction("--");
        farming.setProcessed(true);
        farming.setIsApproved(true);
        farming.saveEx();
        return farming;
    }

    private MFAPFarmingDefinition createFarmingDefinition(String documentNo, int documentTypeId, int agreementTypeId, BigDecimal cost, int financialProductId, List<MProduct> categories, String transactionName) {
        MFAPFarmingDefinition costDefinition = new MFAPFarmingDefinition(Env.getCtx(), 0, transactionName);
        costDefinition.setDocumentNo(documentNo);
        costDefinition.setDateDoc(TimeUtil.getDay((long)System.currentTimeMillis()));
        costDefinition.setC_DocType_ID(documentTypeId);
        costDefinition.setC_Currency_ID(MCurrency.get((Properties)Env.getCtx(), (String)"USD").getC_Currency_ID());
        costDefinition.setAmount(cost);
        costDefinition.setFM_AgreementType_ID(agreementTypeId);
        costDefinition.setDescription(SETUP_DESCRIPTION);
        costDefinition.setDocStatus("CO");
        costDefinition.setDocAction("--");
        costDefinition.setProcessed(true);
        costDefinition.setIsApproved(true);
        costDefinition.setUUID(SETUP_UUID);
        costDefinition.setIsDirectLoad(true);
        costDefinition.setFM_Product_ID(financialProductId);
        costDefinition.saveEx();
        if (categories != null) {
            categories.forEach(category -> {
                MFAPDefintionCategory categoryToAdd = new MFAPDefintionCategory(Env.getCtx(), 0, transactionName);
                categoryToAdd.setFAP_FarmingDefinition_ID(costDefinition.getFAP_FarmingDefinition_ID());
                categoryToAdd.setCategory_ID(category.getM_Product_ID());
                categoryToAdd.setUUID(SETUP_UUID);
                categoryToAdd.setDescription(SETUP_DESCRIPTION);
                categoryToAdd.setIsDirectLoad(true);
                categoryToAdd.saveEx();
            });
        }
        return costDefinition;
    }

    private MFMAgreement createAgreement(int farmerId, int documentTypeId, int agreementTypeId, int farmingDefinitionId, int financialProductCategoryId, int farmingId, String transactionName) {
        MFMAgreementType agreementType = new MFMAgreementType(Env.getCtx(), agreementTypeId, transactionName);
        MFMAgreement agreement = new MFMAgreement(Env.getCtx(), 0, transactionName);
        agreement.setDocumentNo("LineaCreditoPrueba");
        agreement.setDateDoc(TimeUtil.getDay((long)System.currentTimeMillis()));
        agreement.setValidFrom(TimeUtil.getDay((long)System.currentTimeMillis()));
        agreement.setC_BPartner_ID(farmerId);
        agreement.setFM_AgreementType_ID(agreementTypeId);
        agreement.setC_DocType_ID(documentTypeId);
        agreement.setDescription(SETUP_DESCRIPTION);
        agreement.setIsSOTrx(true);
        agreement.setText(agreementType.getText());
        agreement.set_ValueOfColumn("FAP_FarmingDefinition_ID", (Object)farmingDefinitionId);
        agreement.set_ValueOfColumn("IsFarmerAssistanceProgram", (Object)true);
        agreement.setUUID(SETUP_UUID);
        agreement.setIsDirectLoad(true);
        agreement.saveEx();
        MFMAccount account = new MFMAccount(agreement);
        account.saveEx();
        account.setUUID(SETUP_UUID);
        account.setIsDirectLoad(true);
        account.saveEx(transactionName);
        new Query(Env.getCtx(), "FM_Product", "FM_ProductCategory_ID = ?", transactionName).setParameters(new Object[]{financialProductCategoryId}).setOnlyActiveRecords(true).list().forEach(financialProduct -> {
            MFMAccountProduct accountProduct = new MFMAccountProduct(account);
            accountProduct.setFM_Product_ID(financialProduct.getFM_Product_ID());
            accountProduct.setValidFrom(agreement.getDateDoc());
            accountProduct.saveEx(transactionName);
            accountProduct.setUUID(SETUP_UUID);
            accountProduct.setIsDirectLoad(true);
            accountProduct.saveEx(transactionName);
        });
        agreement.setDocStatus("CO");
        agreement.setProcessed(true);
        agreement.saveEx();
        MFAPFarmingAllocation allocationOfFarming = new MFAPFarmingAllocation(Env.getCtx(), 0, transactionName);
        allocationOfFarming.setFM_Agreement_ID(agreement.getFM_Agreement_ID());
        allocationOfFarming.setFAP_Farming_ID(farmingId);
        allocationOfFarming.setUUID(SETUP_UUID);
        allocationOfFarming.setIsDirectLoad(true);
        allocationOfFarming.saveEx();
        allocationOfFarming.setDescription(SETUP_DESCRIPTION);
        allocationOfFarming.setIsDirectLoad(false);
        allocationOfFarming.saveEx();
        agreement.load(transactionName);
        agreement.setIsDirectLoad(false);
        agreement.setDocStatus("DR");
        agreement.processIt("PR");
        agreement.setDocStatus("CO");
        agreement.setDocAction("--");
        agreement.setProcessed(true);
        agreement.setIsApproved(true);
        agreement.saveEx();
        return agreement;
    }

    private MFMProduct createFinancialProduct(int financialProductCategoryId, String value, String name, String transactionName) {
        MFMProduct financialProduct = new MFMProduct(Env.getCtx(), 0, transactionName);
        financialProduct.setValue(value);
        financialProduct.setName(name);
        financialProduct.setFM_ProductCategory_ID(financialProductCategoryId);
        financialProduct.setC_Currency_ID(MCurrency.get((Properties)Env.getCtx(), (String)"USD").getC_Currency_ID());
        MProduct product = this.createProduct(value, name, transactionName);
        financialProduct.setM_Product_ID(product.getM_Product_ID());
        MCharge charge = this.createCharge(value, name, transactionName);
        financialProduct.setC_Charge_ID(charge.getC_Charge_ID());
        financialProduct.setPaymentFrequency("F");
        financialProduct.setGraceDays(0);
        financialProduct.setUUID(SETUP_UUID);
        financialProduct.setIsDirectLoad(true);
        financialProduct.saveEx();
        return financialProduct;
    }

    private MProduct createProduct(String value, String name, String transactionName) {
        MProduct product = new MProduct(Env.getCtx(), 0, transactionName);
        product.setValue(value);
        product.setName(name);
        product.setDescription(SETUP_DESCRIPTION);
        product.setM_Product_Category_ID(new Query(Env.getCtx(), "M_Product_Category", null, transactionName).setClient_ID().firstId());
        product.setC_TaxCategory_ID(new Query(Env.getCtx(), "C_TaxCategory", null, transactionName).setClient_ID().firstId());
        product.setC_UOM_ID(new Query(Env.getCtx(), "C_UOM", "X12DE355 = ?", transactionName).setParameters(new Object[]{"Kg"}).firstId());
        product.set_ValueOfColumn("IsCategory", (Object)true);
        product.setProductType("S");
        product.saveEx();
        product.setUUID(SETUP_UUID);
        product.setIsDirectLoad(true);
        product.saveEx();
        this.createPriceList(product.getM_Product_ID(), null, transactionName);
        return product;
    }

    private void createPriceList(int productId, BigDecimal optionalPrice, String transactionName) {
        new Query(Env.getCtx(), "M_PriceList_Version", null, transactionName).setOnlyActiveRecords(true).setClient_ID().list().forEach(priceListVersion -> {
            MProductPrice productPrice = new MProductPrice(Env.getCtx(), priceListVersion.getM_PriceList_Version_ID(), productId, transactionName);
            productPrice.setPriceList(Optional.ofNullable(optionalPrice).orElse(Env.ONEHUNDRED));
            productPrice.setPriceStd(Optional.ofNullable(optionalPrice).orElse(Env.ONEHUNDRED));
            productPrice.setPriceLimit(Optional.ofNullable(optionalPrice).orElse(Env.ONEHUNDRED));
            productPrice.setUUID(SETUP_UUID);
            productPrice.setIsDirectLoad(true);
            productPrice.saveEx();
        });
    }

    private MCharge createCharge(String value, String name, String transactionName) {
        MCharge charge = new MCharge(Env.getCtx(), 0, transactionName);
        charge.setName(name);
        charge.setDescription(SETUP_DESCRIPTION);
        charge.setC_TaxCategory_ID(new Query(Env.getCtx(), "C_TaxCategory", null, transactionName).setClient_ID().firstId());
        charge.saveEx();
        charge.setUUID(SETUP_UUID);
        charge.setIsDirectLoad(true);
        charge.saveEx();
        return charge;
    }

    private MFMFunctionalSetting createFunctionalSetting(String value, String name, String className, String transactionName) {
        MFMFunctionalSetting functionalSetting = new MFMFunctionalSetting(Env.getCtx(), 0, transactionName);
        functionalSetting.setValue(value);
        functionalSetting.setName(name);
        functionalSetting.setClassname(className);
        functionalSetting.setDescription(SETUP_DESCRIPTION);
        functionalSetting.setUUID(SETUP_UUID);
        functionalSetting.setIsDirectLoad(true);
        functionalSetting.saveEx();
        return functionalSetting;
    }

    private MFMFunctionalApplicability createApplicability(int functionaSettingId, int financialProductCategoryId, String tableName, String eventType, String eventModelValidator, String transactionName) {
        MFMFunctionalApplicability applicability = new MFMFunctionalApplicability(Env.getCtx(), 0, transactionName);
        applicability.setFM_FunctionalSetting_ID(functionaSettingId);
        applicability.setFM_ProductCategory_ID(financialProductCategoryId);
        if (!Util.isEmpty((String)tableName)) {
            applicability.setAD_Table_ID(MTable.getTable_ID((String)tableName));
        }
        if (!Util.isEmpty((String)eventType)) {
            applicability.setEventType(eventType);
        }
        if (!Util.isEmpty((String)eventModelValidator)) {
            applicability.setEventModelValidator(eventModelValidator);
        }
        applicability.setSeqNo(10);
        applicability.setValidFrom(TimeUtil.getDay((int)2020, (int)5, (int)1));
        applicability.setDescription(SETUP_DESCRIPTION);
        applicability.setUUID(SETUP_UUID);
        applicability.setIsCreateReversal(false);
        applicability.setIsDirectLoad(true);
        applicability.saveEx();
        return applicability;
    }

    private MBPartner createFarmer(String value, String name, MFAPPlantingCycle plantingCycle, String transactionName) {
        MBPartner farmer = (MBPartner)new Query(Env.getCtx(), "C_BPartner", "Value = ?", transactionName).setParameters(new Object[]{value}).setClient_ID().first();
        if (farmer == null || farmer.getC_BPartner_ID() <= 0) {
            farmer = new MBPartner(Env.getCtx(), 0, transactionName);
        }
        farmer.setValue(value);
        farmer.setName(name);
        farmer.setDescription(SETUP_DESCRIPTION);
        farmer.setC_BP_Group_ID(new Query(Env.getCtx(), "C_BP_Group", null, transactionName).setClient_ID().firstId());
        farmer.setSOCreditStatus("O");
        farmer.setIsCustomer(true);
        farmer.setIsVendor(true);
        farmer.set_ValueOfColumn("IsFarmer", (Object)true);
        farmer.saveEx();
        farmer.setUUID(SETUP_UUID);
        farmer.setIsDirectLoad(true);
        farmer.saveEx();
        MLocation location = new MLocation(Env.getCtx(), MCountry.getDefault((Properties)Env.getCtx()).getC_Country_ID(), MRegion.getDefault((Properties)Env.getCtx()).getC_Region_ID(), "Guanare", transactionName);
        location.setAddress1("Final AV La Cancha");
        location.setAddress2("Barrio la Goajira");
        location.setAddress3("Casa Nro 7");
        location.setAddress4("San Juan de Guanaguanare");
        location.setPostal("3323");
        location.saveEx();
        location.setUUID(SETUP_UUID);
        location.setIsDirectLoad(true);
        location.saveEx();
        MBPartnerLocation farmerLocation = new MBPartnerLocation(farmer);
        farmerLocation.setIsBillTo(true);
        farmerLocation.setIsShipTo(true);
        farmerLocation.setC_Location_ID(location.getC_Location_ID());
        farmerLocation.saveEx();
        farmerLocation.setUUID(SETUP_UUID);
        farmerLocation.setIsDirectLoad(true);
        farmerLocation.saveEx();
        MFAPFarm cornFarm = new MFAPFarm(Env.getCtx(), 0, transactionName);
        cornFarm.setC_BPartner_ID(farmer.getC_BPartner_ID());
        cornFarm.setC_BPartner_Location_ID(farmerLocation.getC_BPartner_Location_ID());
        cornFarm.setName("Los Naranjos");
        cornFarm.setIsFarmDivisionControl(false);
        cornFarm.setFarmType("L");
        cornFarm.setIsValid(true);
        cornFarm.setArea(new BigDecimal(120));
        cornFarm.setUUID(SETUP_UUID);
        cornFarm.setIsDirectLoad(true);
        cornFarm.saveEx();
        MFAPFarm farm = new MFAPFarm(Env.getCtx(), 0, transactionName);
        farm.setC_BPartner_ID(farmer.getC_BPartner_ID());
        farm.setC_BPartner_Location_ID(farmerLocation.getC_BPartner_Location_ID());
        farm.setName("La Selva");
        farm.setFarmType("O");
        farm.setIsFarmDivisionControl(true);
        farm.setIsValid(true);
        farm.setArea(new BigDecimal(20));
        farm.setUUID(SETUP_UUID);
        farm.setIsDirectLoad(true);
        farm.saveEx();
        MFAPFarmDivision farmDivision = new MFAPFarmDivision(Env.getCtx(), 0, transactionName);
        farmDivision.setFAP_Farm_ID(farm.getFAP_Farm_ID());
        farmDivision.setName("Lote 1");
        farmDivision.setArea(new BigDecimal(7));
        farmDivision.setUUID(SETUP_UUID);
        farmDivision.setIsDirectLoad(true);
        farmDivision.saveEx();
        farmDivision = new MFAPFarmDivision(Env.getCtx(), 0, transactionName);
        farmDivision.setFAP_Farm_ID(farm.getFAP_Farm_ID());
        farmDivision.setName("Lote 2");
        farmDivision.setArea(new BigDecimal(8));
        farmDivision.setUUID(SETUP_UUID);
        farmDivision.setIsDirectLoad(true);
        farmDivision.saveEx();
        farmDivision = new MFAPFarmDivision(Env.getCtx(), 0, transactionName);
        farmDivision.setFAP_Farm_ID(farm.getFAP_Farm_ID());
        farmDivision.setName("Lote 3");
        farmDivision.setArea(new BigDecimal(5));
        farmDivision.setUUID(SETUP_UUID);
        farmDivision.setIsDirectLoad(true);
        farmDivision.saveEx();
        farm.validate();
        farm.saveEx();
        this.createFarmerCreditDefinition(farmer, cornFarm, plantingCycle, transactionName);
        return farmer;
    }

    private MFAPFarmingStage createFarmingStage(String value, String name, int dayFrom, int dayTo, int sequence, int categoryId, String transactionName) {
        MFAPFarmingStage farmingStage = new MFAPFarmingStage(Env.getCtx(), 0, transactionName);
        farmingStage.setCategory_ID(categoryId);
        farmingStage.setValue(value);
        farmingStage.setName(name);
        farmingStage.setSeqNo(sequence);
        farmingStage.setDayFrom(new BigDecimal(dayFrom));
        farmingStage.setDayTo(new BigDecimal(dayTo));
        farmingStage.setUUID(SETUP_UUID);
        farmingStage.setIsDirectLoad(true);
        farmingStage.saveEx();
        return farmingStage;
    }

    private void removeSetup(String transactionName) {
        this.deleteEntity("FAP_WeightCalculation", transactionName);
        this.deleteEntity("FAP_WeightCalculationType", transactionName);
        this.deleteEntity("FAP_SuggestedProduct", transactionName);
        this.deleteEntity("FAP_ObservationType", transactionName);
        this.deleteEntity("FAP_Farming", transactionName);
        this.deleteEntity("FAP_PlantingCycle", transactionName);
        this.deleteEntity("FAP_FarmingStage", transactionName);
        this.deleteEntity("FAP_FarmDivision", transactionName);
        this.deleteEntity("FAP_Farm", transactionName);
        this.deleteEntity("C_BPartner_Location", transactionName);
        this.deleteEntity("C_Location", transactionName);
        this.deleteEntity("C_BPartner", transactionName);
        this.deleteEntity("FM_TransactionType", transactionName);
        this.deleteEntity("C_DocType", transactionName);
        this.deleteEntity("FM_FunctionalApplicability", transactionName);
        this.deleteEntity("FM_FunctionalSetting", transactionName);
        this.deleteEntity("FM_AccountProduct", transactionName);
        this.deleteEntity("FAP_FarmingAllocation", transactionName);
        this.deleteEntity("FAP_DefinitionCategory", transactionName);
        this.deleteEntity("FAP_FarmingDefinition", transactionName);
        this.deleteEntity("FM_Product", transactionName);
        this.deleteEntity("M_Product", transactionName);
        this.deleteEntity("C_Charge", transactionName);
        this.deleteEntity("FM_ProductCategory", transactionName);
        this.deleteEntity("FM_Account", transactionName);
        this.deleteEntity("FM_Agreement", transactionName);
        this.deleteEntity("FM_AgreementType", transactionName);
        this.deleteEntity("DD_VehicleType", transactionName);
    }

    private void deleteEntity(String tableName, String transactionName) {
        new Query(Env.getCtx(), tableName, "UUID = ?", transactionName).setParameters(new Object[]{SETUP_UUID}).setClient_ID().list().forEach(entity -> entity.deleteEx(true));
    }
}

