/*
 * Decompiled with CFR 0.152.
 */
package org.farming.report;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MDocType;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.farming.report.FarmerAccountStatementAbstract;

public class FarmerAccountStatement
extends FarmerAccountStatementAbstract {
    private String sql = null;
    private String sqlInsert = null;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getDateTrx() == null) {
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
        }
        if (this.getDateTrxTo() == null) {
            this.setDateTrxTo(new Timestamp(System.currentTimeMillis()));
        }
        String beginningBalanceMessage = Msg.getMsg((Properties)this.getCtx(), (String)"BeginningBalance");
        StringBuffer additionalWhere = new StringBuffer(" WHERE asr.AD_Client_ID = ").append(this.getAD_Client_ID());
        if (this.getBPartnerId() != 0) {
            additionalWhere.append(" AND asr.C_BPartner_ID = ").append(this.getBPartnerId());
        }
        if (this.getBPAccountTypeId() != 0) {
            additionalWhere.append(" AND EXISTS(SELECT 1 FROM C_BPartner bp WHERE bp.C_BPartner_ID = asr.C_BPartner_ID AND bp.C_BP_AccountType_ID = ").append(this.getBPAccountTypeId()).append(")");
        }
        if (this.getBPIndustryTypeId() != 0) {
            additionalWhere.append(" AND EXISTS(SELECT 1 FROM C_BPartner bp WHERE bp.C_BPartner_ID = asr.C_BPartner_ID AND bp.C_BP_IndustryType_ID = ").append(this.getBPIndustryTypeId()).append(")");
        }
        if (this.getBPSalesGroupId() != 0) {
            additionalWhere.append(" AND EXISTS(SELECT 1 FROM C_BPartner bp WHERE bp.C_BPartner_ID = asr.C_BPartner_ID AND bp.C_BP_SalesGroup_ID = ").append(this.getBPSalesGroupId()).append(")");
        }
        if (this.getBPSegmentId() != 0) {
            additionalWhere.append(" AND EXISTS(SELECT 1 FROM C_BPartner bp WHERE bp.C_BPartner_ID = asr.C_BPartner_ID AND bp.C_BP_Segment_ID = ").append(this.getBPSegmentId()).append(")");
        }
        if (this.getBPGroupId() != 0) {
            additionalWhere.append(" AND EXISTS(SELECT 1 FROM C_BPartner bp WHERE bp.C_BPartner_ID = asr.C_BPartner_ID AND bp.C_BP_Group_ID = ").append(this.getBPGroupId()).append(")");
        }
        if (this.getAgreementId() > 0) {
            additionalWhere.append(" AND asr.FM_Agreement_ID = ").append(this.getAgreementId());
        }
        if (this.getAgreementTypeId() > 0) {
            additionalWhere.append(" AND EXISTS(SELECT 1 FROM FM_Agreement ag WHERE ag.FM_Agreement_ID = asr.FM_Agreement_ID AND ag.FM_AgreementType_ID = ").append(this.getAgreementTypeId()).append(")");
        }
        if (this.getAccountId() > 0) {
            additionalWhere.append(" AND asr.FM_Account_ID = ").append(this.getAccountId());
        }
        if (this.getProductId() > 0) {
            additionalWhere.append(" AND EXISTS(SELECT 1 FROM FM_Agreement ag WHERE ag.FM_Agreement_ID = asr.FM_Agreement_ID AND ag.FM_Product_ID = ").append(this.getProductId()).append(")");
        }
        this.sql = "SELECT asr.AD_Client_ID, asr.SeqNo, asr.AD_Org_ID, asr.Multiplier, asr.C_Payment_ID, asr.C_Invoice_ID, asr.C_Order_ID, asr.FM_Batch_ID, asr.FM_Transaction_ID, asr.FM_Agreement_ID, asr.FM_Account_ID, asr.DocumentNo, asr.Description, asr.DateTrx, asr.DateAcct, asr.C_BPartner_ID, asr.AmtSource, asr.AmtSourceDr, (asr.AmtSourceDr - asr.AmtSourceCr) AS Balance, asr.AmtSourceCr, asr.C_DocType_ID, asr.DD_RecordWeight_ID, asr.DD_Freight_ID FROM (    SELECT ft.AD_Client_ID, 10 SeqNo, 0 AS AD_Org_ID, ft.Multiplier, 0 AS C_Payment_ID, 0 AS C_Invoice_ID, 0 AS C_Order_ID, 0 AS FM_Batch_ID, 0 AS FM_Transaction_ID, ft.FM_Agreement_ID, ft.FM_Account_ID, '" + beginningBalanceMessage + "' AS DocumentNo, '" + beginningBalanceMessage + "' AS Description, ft.DateTrx, ft.DateAcct, ft.C_BPartner_ID, SUM(ft.AmtSource) AmtSource, SUM(ft.AmtSourceDr) AS AmtSourceDr, SUM(ft.AmtSourceCr) AS AmtSourceCr, 0 AS C_DocType_ID, 0 AS DD_RecordWeight_ID, 0 AS DD_Freight_ID     FROM (        SELECT ft.AD_Client_ID, 10 SeqNo, 0 AS AD_Org_ID, 1 AS Multiplier, 0 AS C_Payment_ID, 0 AS C_Invoice_ID, 0 AS C_Order_ID, 0 AS FM_Batch_ID, 0 AS FM_Transaction_ID, ft.FM_Agreement_ID, fa.FM_Account_ID, ft.DocumentNo, ft.Description, getDate() AS DateTrx, getDate() AS DateAcct, ft.C_BPartner_ID, SUM(ft.FarmingApprovedAmount) AS AmtSource, 0 AS AmtSourceDr, SUM(ft.FarmingApprovedAmount) AS AmtSourceCr        FROM FM_Agreement ft \t\t INNER JOIN FM_Account fa ON(fa.FM_Agreement_ID = ft.FM_Agreement_ID)        WHERE ft.DocStatus IN('CO', 'CL')        AND ft.DateDoc < ?         GROUP BY ft.AD_Client_ID, ft.C_BPartner_ID, ft.FM_Agreement_ID, fa.FM_Account_ID        UNION ALL        SELECT ft.AD_Client_ID, 30 SeqNo, 0 AS AD_Org_ID, 1 AS Multiplier, 0 AS C_Payment_ID, 0 AS C_Invoice_ID, 0 AS C_Order_ID, 0 AS FM_Batch_ID, 0 AS FM_Transaction_ID, ft.FM_Agreement_ID, ft.FM_Account_ID, '' AS DocumentNo, '' AS Description, getDate() AS DateTrx, getDate() AS DateAcct, ft.C_BPartner_ID, SUM(ft.Amount) AS AmtSource,         SUM(CASE WHEN COALESCE(ft.Amount, 0) > 0 THEN ft.Amount ELSE 0 END) AS AmtSourceDr, SUM(CASE WHEN COALESCE(ft.Amount, 0) < 0 THEN ABS(ft.Amount) ELSE 0 END) AS AmtSourceCr         FROM RV_FAP_Transaction ft        WHERE ft.DocStatus IN('CO', 'CL')        AND ft.DateDoc < ?        GROUP BY ft.AD_Client_ID, ft.C_BPartner_ID, ft.FM_Agreement_ID, ft.FM_Account_ID    ) AS ft    GROUP BY ft.AD_Client_ID, ft.Multiplier, ft.FM_Agreement_ID, ft.FM_Account_ID, ft.DocumentNo, ft.Description, ft.DateTrx, ft.DateAcct, ft.C_BPartner_ID     UNION ALL     SELECT fc.AD_Client_ID, 20 SeqNo, fc.AD_Org_ID, 1 AS Multiplier, 0 AS C_Payment_ID, 0 AS C_Invoice_ID, 0 AS C_Order_ID, 0 AS FM_Batch_ID, 0 AS FM_Transaction_ID, fc.FM_Agreement_ID, 0 FM_Account_ID, fc.DocumentNo, fc.Description, fc.DateDoc AS DateTrx, fc.DateDoc AS DateAcct, fc.C_BPartner_ID, fc.FarmingApprovedAmount AS AmtSource, 0 AS AmtSourceDr, fc.FarmingApprovedAmount AS AmtSourceCr, fc.C_DocType_ID, 0 AS DD_RecordWeight_ID, 0 AS DD_Freight_ID     FROM FM_Agreement fc    WHERE fc.DocStatus IN('CO', 'CL')    AND fc.DateDoc BETWEEN ? AND ?     UNION ALL    SELECT ft.AD_Client_ID, 30 SeqNo, ft.AD_Org_ID, 1 AS Multiplier, ft.C_Payment_ID, ft.C_Invoice_ID, ft.C_Order_ID, ft.FM_Batch_ID, ft.FM_Transaction_ID, ft.FM_Agreement_ID, ft.FM_Account_ID, ft.DocumentNo, ft.Description, ft.DateDoc AS DateTrx, ft.DateDoc AS DateAcct, ft.C_BPartner_ID, ft.Amount AS AmtSource,     CASE WHEN COALESCE(ft.Amount, 0) > 0 THEN ft.Amount ELSE 0 END AS AmtSourceDr, CASE WHEN COALESCE(ft.Amount, 0) < 0 THEN ABS(ft.Amount) ELSE 0 END AS AmtSourceCr, ft.C_DocType_ID, ft.DD_RecordWeight_ID,ft.DD_Freight_ID     FROM RV_FAP_Transaction ft    WHERE ft.DocStatus IN('CO', 'CL')    AND ft.DateDoc BETWEEN ? AND ? ) AS asr " + additionalWhere + " ORDER BY asr.C_BPartner_ID, asr.FM_Agreement_ID, asr.FM_Account_ID, asr.SeqNo, asr.DateTrx";
        this.sqlInsert = "INSERT INTO T_FarmerAccountStatement(AD_Client_ID, AD_Org_ID, AD_PInstance_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy, Multiplier, C_Order_ID, C_Invoice_ID, C_Payment_ID, FM_Agreement_ID, FM_Account_ID, DocumentNo, DateTrx, DateAcct, C_BPartner_ID, AmtSource, AmtSourceDr, AmtSourceCr, Balance, SeqNo, Description, BalanceAmount, FM_Batch_ID, FM_Transaction_ID, DD_RecordWeight_ID, DD_Freight_ID) VALUES(" + this.getAD_Client_ID() + " , " + Env.getAD_Org_ID((Properties)this.getCtx()) + ", " + this.getAD_PInstance_ID() + ", 'Y', getDate(), " + this.getAD_User_ID() + ", getDate(), " + this.getAD_User_ID() + ", ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    protected String doIt() throws Exception {
        CPreparedStatement pstmtSelect = null;
        ResultSet resultSet = null;
        try {
            String amountCrColumnName;
            this.log.fine("SQL = " + this.sql.toString());
            pstmtSelect = DB.prepareStatement((String)this.sql, (String)this.get_TrxName());
            int i = 1;
            pstmtSelect.setTimestamp(i++, this.getDateTrx());
            pstmtSelect.setTimestamp(i++, this.getDateTrx());
            pstmtSelect.setTimestamp(i++, this.getDateTrx());
            pstmtSelect.setTimestamp(i++, this.getDateTrxTo());
            pstmtSelect.setTimestamp(i++, this.getDateTrx());
            pstmtSelect.setTimestamp(i++, this.getDateTrxTo());
            resultSet = pstmtSelect.executeQuery();
            BigDecimal balanceAmount = Env.ZERO;
            AtomicInteger counter = new AtomicInteger(0);
            int currentBusinessPartnerId = 0;
            String amountDrColumnName = this.isSOTrx() ? "AmtSourceDr" : "AmtSourceCr";
            String string = amountCrColumnName = this.isSOTrx() ? "AmtSourceCr" : "AmtSourceDr";
            while (resultSet.next()) {
                int sequece = resultSet.getInt("SeqNo");
                BigDecimal balance = Optional.ofNullable(resultSet.getBigDecimal("Balance")).orElse(Env.ZERO);
                BigDecimal amountSource = Optional.ofNullable(resultSet.getBigDecimal("AmtSource")).orElse(Env.ZERO);
                BigDecimal amountSourceDr = Optional.ofNullable(resultSet.getBigDecimal(amountDrColumnName)).orElse(Env.ZERO);
                BigDecimal amountSourceCr = Optional.ofNullable(resultSet.getBigDecimal(amountCrColumnName)).orElse(Env.ZERO);
                Timestamp transactionDate = resultSet.getTimestamp("DateTrx");
                Timestamp accountingDate = resultSet.getTimestamp("DateAcct");
                int businessPartnerId = resultSet.getInt("C_BPartner_ID");
                int farmerCreditId = resultSet.getInt("FM_Agreement_ID");
                int farmerAccountId = resultSet.getInt("FM_Account_ID");
                int batchId = resultSet.getInt("FM_Batch_ID");
                int transactionId = resultSet.getInt("FM_Transaction_ID");
                int recordWeightId = resultSet.getInt("DD_RecordWeight_ID");
                int freightId = resultSet.getInt("DD_Freight_ID");
                if (sequece == 10 || currentBusinessPartnerId != businessPartnerId) {
                    balanceAmount = this.isSOTrx() ? balance : balance.negate();
                    currentBusinessPartnerId = businessPartnerId;
                    if (sequece == 10 || transactionDate == null) {
                        transactionDate = this.getDateTrx();
                        accountingDate = this.getDateTrx();
                    }
                } else {
                    balanceAmount = balanceAmount.add(amountSourceDr).subtract(amountSourceCr);
                }
                int orderId = resultSet.getInt("C_Order_ID");
                int invoiceId = resultSet.getInt("C_Invoice_ID");
                int paymentId = resultSet.getInt("C_Payment_ID");
                int documentTypeId = resultSet.getInt("C_DocType_ID");
                String description = resultSet.getString("Description");
                if (documentTypeId != 0) {
                    MDocType documentType = MDocType.get((Properties)this.getCtx(), (int)documentTypeId);
                    String documentName = documentType.getName();
                    if (!Env.isBaseLanguage((Properties)this.getCtx(), null)) {
                        documentName = documentType.get_Translation("Name");
                    }
                    description = Util.isEmpty((String)description) ? documentName : documentName + Env.NL + description;
                }
                DB.executeUpdateEx((String)this.sqlInsert, (Object[])new Object[]{resultSet.getBigDecimal("Multiplier"), orderId == 0 ? null : Integer.valueOf(orderId), invoiceId == 0 ? null : Integer.valueOf(invoiceId), paymentId == 0 ? null : Integer.valueOf(paymentId), farmerCreditId == 0 ? null : Integer.valueOf(farmerCreditId), farmerAccountId == 0 ? null : Integer.valueOf(farmerAccountId), resultSet.getString("DocumentNo"), transactionDate, accountingDate, businessPartnerId, amountSource, amountSourceDr, amountSourceCr, balance, resultSet.getInt("SeqNo") + counter.addAndGet(1), description, balanceAmount, batchId == 0 ? null : Integer.valueOf(batchId), transactionId == 0 ? null : Integer.valueOf(transactionId), recordWeightId == 0 ? null : Integer.valueOf(recordWeightId), freightId == 0 ? null : Integer.valueOf(freightId)}, (String)this.get_TrxName());
            }
        }
        catch (Exception e) {
            try {
                throw new DBException(e, this.sql.toString());
            }
            catch (Throwable throwable) {
                DB.close(resultSet, pstmtSelect);
                throw throwable;
            }
        }
        DB.close((ResultSet)resultSet, (Statement)pstmtSelect);
        return "Ok";
    }
}

