/*
 * Decompiled with CFR 0.152.
 */
package org.farming.process;

import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.farming.model.MFAPProductsToApply;
import org.farming.model.MFAPTechnicalForm;
import org.farming.model.MFAPTechnicalFormLine;
import org.farming.process.TechnicalFormOrderGenerateAbstract;

public class TechnicalFormOrderGenerate
extends TechnicalFormOrderGenerateAbstract {
    private Map<String, MOrder> orders = new Hashtable<String, MOrder>();
    private AtomicInteger created = new AtomicInteger();
    private StringBuffer generatedDocuments = new StringBuffer();

    protected String doIt() throws Exception {
        Iterable technicalForms = null;
        if (this.getRecord_ID() > 0 && this.getTableName().equals("FAP_TechnicalForm")) {
            technicalForms = new Query(this.getCtx(), "FAP_TechnicalForm", "FAP_TechnicalForm_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getRecord_ID()}).list();
        } else if (this.isSelection()) {
            this.getProcessInfo().setTableSelectionId(MFAPTechnicalForm.Table_ID);
            technicalForms = this.getInstancesForSelection(this.get_TrxName());
        }
        technicalForms.forEach(technicalForm -> this.createOrder((MFAPTechnicalForm)technicalForm));
        this.processOrders();
        this.openResult("C_Order");
        return "@Created@ " + this.created + (this.generatedDocuments.length() > 0 ? " [" + this.generatedDocuments + "]" : "");
    }

    private void createOrder(MFAPTechnicalForm technicalForm) {
        Optional<MFAPTechnicalFormLine> maybeTechnicalFormLine = technicalForm.getLines(true).stream().filter(technicalFormLine -> technicalFormLine.getFM_Agreement_ID() > 0).findFirst();
        technicalForm.getProductToApply(true).stream().filter(productToApply -> !this.isOrderGenerated((MFAPProductsToApply)productToApply)).forEach(productToApply -> {
            MOrder order = this.getOrder(maybeTechnicalFormLine, (MFAPProductsToApply)productToApply);
            MOrderLine orderLine = new MOrderLine(order);
            MProduct product = MProduct.get((Properties)this.getCtx(), (int)productToApply.getM_Product_ID());
            if (productToApply.getM_Warehouse_ID() > 0) {
                order.setM_Warehouse_ID(productToApply.getM_Warehouse_ID());
            }
            orderLine.setProduct(product);
            int uom = productToApply.getC_UOM_ID();
            orderLine.setPrice();
            BigDecimal rate = MUOMConversion.getProductRateFrom((Properties)Env.getCtx(), (int)product.getM_Product_ID(), (int)uom);
            if (rate == null) {
                throw new AdempiereException("@NoUOMConversion@");
            }
            orderLine.setQtyEntered(productToApply.getQty());
            orderLine.setQtyOrdered(productToApply.getQty().multiply(rate));
            orderLine.setC_UOM_ID(uom);
            orderLine.set_ValueOfColumn("FAP_ProductsToApply_ID", (Object)productToApply.getFAP_ProductsToApply_ID());
            maybeTechnicalFormLine.ifPresent(technicalFormLine -> {
                orderLine.set_ValueOfColumn("FAP_TechnicalFormLine_ID", (Object)technicalFormLine.getFAP_TechnicalFormLine_ID());
                orderLine.set_ValueOfColumn("FAP_Farming_ID", (Object)technicalFormLine.getFAP_Farming_ID());
            });
            orderLine.saveEx(this.get_TrxName());
        });
    }

    private boolean isOrderGenerated(MFAPProductsToApply productToApply) {
        return new Query(this.getCtx(), "C_Order", "DocStatus NOT IN('VO') AND EXISTS(SELECT 1 FROM C_OrderLine ol WHERE ol.C_Order_ID = C_Order.C_Order_ID AND ol.FAP_ProductsToApply_ID = ?)", productToApply.get_TrxName()).setParameters(new Object[]{productToApply.getFAP_ProductsToApply_ID()}).match();
    }

    private MOrder getOrder(Optional<MFAPTechnicalFormLine> maybeTechnicalFormLine, MFAPProductsToApply productToApply) {
        String key = productToApply.getFAP_TechnicalForm_ID() + "";
        int agreementId = 0;
        if (productToApply.getFAP_TechnicalFormLine_ID() > 0) {
            MFAPTechnicalFormLine technicalFormLine = MFAPTechnicalFormLine.get(this.getCtx(), productToApply.getFAP_TechnicalFormLine_ID(), this.get_TrxName());
            agreementId = technicalFormLine.getFM_Agreement_ID();
        } else if (maybeTechnicalFormLine.isPresent()) {
            agreementId = maybeTechnicalFormLine.get().getFM_Agreement_ID();
        }
        key = this.isSplitOrdersByWarehouse() ? key + "|" + agreementId + "|" + productToApply.getM_Warehouse_ID() : key + "|" + agreementId;
        MOrder order = this.orders.get(key);
        if (order != null) {
            return order;
        }
        MFAPTechnicalForm technicalForm = MFAPTechnicalForm.getById(this.getCtx(), productToApply.getFAP_TechnicalForm_ID(), this.get_TrxName());
        MBPartner businessPartner = MBPartner.get((Properties)this.getCtx(), (int)technicalForm.getC_BPartner_ID());
        order = new MOrder(this.getCtx(), 0, this.get_TrxName());
        order.setBPartner(businessPartner);
        order.setIsSOTrx(true);
        order.setSalesRep_ID(technicalForm.getSalesRep_ID());
        order.setDateOrdered(this.getDateDoc());
        order.setDatePromised(this.getDateDoc());
        order.addDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)("@Created@ @From@ @FAP_TechnicalForm_ID@: " + technicalForm.getDocumentNo())));
        if (this.getDocTypeTargetId() > 0) {
            order.setC_DocTypeTarget_ID(this.getDocTypeTargetId());
        } else {
            order.setC_DocTypeTarget_ID();
        }
        order.setDocAction(this.getDocAction());
        order.setDocStatus("DR");
        order.setProcessed(false);
        if (this.getWarehouseId() > 0 && !this.isSplitOrdersByWarehouse()) {
            order.setM_Warehouse_ID(this.getWarehouseId());
        } else if (productToApply.getM_Warehouse_ID() > 0) {
            order.setM_Warehouse_ID(productToApply.getM_Warehouse_ID());
        }
        if (agreementId > 0) {
            order.set_ValueOfColumn("FM_Agreement_ID", (Object)agreementId);
        }
        if (this.getPriceListId() > 0) {
            order.setM_PriceList_ID(this.getPriceListId());
        }
        order.set_ValueOfColumn("IsFarmerAssistanceProgram", (Object)true);
        order.saveEx();
        this.orders.put(key, order);
        this.addLog(order.getC_Order_ID(), order.getDateOrdered(), null, order.getDocumentNo());
        return order;
    }

    private void addToMessage(String documentInfo) {
        if (this.generatedDocuments.length() > 0) {
            this.generatedDocuments.append(", ");
        }
        this.generatedDocuments.append(documentInfo);
    }

    private void processOrders() {
        if (this.orders == null) {
            return;
        }
        this.orders.entrySet().stream().filter(entry -> entry != null).forEach(entry -> {
            MOrder order = (MOrder)entry.getValue();
            order.setDocAction(this.getDocAction());
            if (!order.processIt(this.getDocAction())) {
                this.addLog("@ProcessFailed@ : " + order.getDocumentInfo());
                this.log.warning("@ProcessFailed@ :" + order.getDocumentInfo());
            }
            order.saveEx();
            this.created.addAndGet(1);
            this.addToMessage(order.getDocumentNo());
        });
    }
}

