/*
 * Decompiled with CFR 0.152.
 */
package org.farming.process;

import java.math.BigDecimal;
import java.util.Optional;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.farming.process.IncreaseCreditLimitAbstract;
import org.spin.model.MFMAgreement;

public class IncreaseCreditLimit
extends IncreaseCreditLimitAbstract {
    protected String doIt() throws Exception {
        String description;
        if (this.getRecord_ID() <= 0 || !this.getTableName().equals("FM_Agreement")) {
            throw new AdempiereException("@FM_Agreement_ID@ @NotFound@");
        }
        MFMAgreement agreement = new MFMAgreement(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        BigDecimal creditLimit = Optional.ofNullable((BigDecimal)agreement.get_Value("FarmerCreditLimit")).orElse(Env.ZERO);
        BigDecimal creditAvailable = Optional.ofNullable((BigDecimal)agreement.get_Value("FarmerCreditAvailable")).orElse(Env.ZERO);
        BigDecimal creditUsed = Optional.ofNullable((BigDecimal)agreement.get_Value("FarmerCreditUsed")).orElse(Env.ZERO);
        BigDecimal amount = Optional.ofNullable(this.getAmount()).orElse(Env.ZERO);
        if (amount.compareTo(Env.ZERO) != 0) {
            creditLimit = creditLimit.add(amount);
        }
        if (!Util.isEmpty((String)(description = this.getDescription()))) {
            if (!Util.isEmpty((String)agreement.getDescription())) {
                agreement.setDescription(agreement.getDescription() + Env.NL + description);
            } else {
                agreement.setDescription(description);
            }
        }
        creditAvailable = creditLimit.subtract(creditUsed);
        agreement.set_ValueOfColumn("FarmerCreditUsed", (Object)creditUsed);
        agreement.set_ValueOfColumn("FarmerCreditLimit", (Object)creditLimit);
        agreement.set_ValueOfColumn("FarmerCreditAvailable", (Object)creditAvailable);
        agreement.saveEx();
        return "@FM_Agreement_ID@ " + agreement.getDocumentNo() + " @Updated@";
    }
}

