/*
 * Decompiled with CFR 0.152.
 */
package org.farming.process;

import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.farming.process.GeneratePurchaseOrderExpressAbstract;

public class GeneratePurchaseOrderExpress
extends GeneratePurchaseOrderExpressAbstract {
    private AtomicInteger created = new AtomicInteger();
    private StringBuffer generatedDocuments = new StringBuffer();
    private MOrder order;

    @Override
    protected void prepare() {
        super.prepare();
        if (Optional.ofNullable(this.getQtyToOrder()).orElse(Env.ZERO).compareTo(Env.ZERO) <= 0) {
            throw new AdempiereException("@QtyToOrder@ @IsMandatory@");
        }
    }

    protected String doIt() throws Exception {
        this.createOrder();
        this.processOrder();
        this.openResult("C_Order");
        return "@Created@ " + this.created + (this.generatedDocuments.length() > 0 ? " [" + this.generatedDocuments + "]" : "");
    }

    private void createOrder() {
        MBPartner businessPartner = MBPartner.get((Properties)this.getCtx(), (int)this.getBPartnerId());
        this.order = new MOrder(this.getCtx(), 0, this.get_TrxName());
        this.order.setAD_Org_ID(this.getOrgId());
        this.order.setIsSOTrx(false);
        this.order.setBPartner(businessPartner);
        this.order.setDateOrdered(this.getDateDoc());
        this.order.setDatePromised(this.getDateDoc());
        if (!Util.isEmpty((String)this.getDescription())) {
            this.order.addDescription(this.getDescription());
        }
        if (this.getDocTypeTargetId() > 0) {
            this.order.setC_DocTypeTarget_ID(this.getDocTypeTargetId());
        } else {
            this.order.setC_DocTypeTarget_ID();
        }
        this.order.setDocAction(this.getDocAction());
        this.order.setDocStatus("DR");
        this.order.setProcessed(false);
        if (this.getWarehouseId() > 0) {
            this.order.setM_Warehouse_ID(this.getWarehouseId());
        }
        this.order.set_ValueOfColumn("IsFarmerAssistanceProgram", (Object)true);
        this.order.saveEx();
        MOrderLine orderLine = new MOrderLine(this.order);
        MProduct product = MProduct.get((Properties)this.getCtx(), (int)this.getProductId());
        if (this.getWarehouseId() > 0) {
            this.order.setM_Warehouse_ID(this.getWarehouseId());
        }
        orderLine.setProduct(product);
        orderLine.setPrice();
        orderLine.setQtyEntered(this.getQtyToOrder());
        orderLine.setQtyOrdered(this.getQtyToOrder());
        if (!Util.isEmpty((String)this.getDescription())) {
            orderLine.addDescription(this.getDescription());
        }
        orderLine.saveEx(this.get_TrxName());
    }

    private void addToMessage(String documentInfo) {
        if (this.generatedDocuments.length() > 0) {
            this.generatedDocuments.append(", ");
        }
        this.generatedDocuments.append(documentInfo);
    }

    private void processOrder() {
        this.order.setDocAction(this.getDocAction());
        if (!this.order.processIt(this.getDocAction())) {
            this.addLog("@ProcessFailed@ : " + this.order.getDocumentInfo());
            this.log.warning("@ProcessFailed@ :" + this.order.getDocumentInfo());
        }
        this.order.saveEx();
        this.addLog(this.order.getC_Order_ID(), this.order.getDateOrdered(), null, this.order.getDocumentNo());
        this.created.addAndGet(1);
        this.addToMessage(this.order.getDocumentNo());
    }
}

