/*
 * Decompiled with CFR 0.152.
 */
package org.farming.process;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MClientInfo;
import org.compiere.model.MDocType;
import org.compiere.model.MFreight;
import org.compiere.model.MFreightCategory;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.model.MUOMConversion;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.eevolution.model.MDDFreight;
import org.eevolution.model.MDDFreightLine;
import org.eevolution.model.MDDVehicle;
import org.eevolution.model.MDDVehicleType;
import org.farming.model.MFAPFarming;
import org.farming.model.MFAPFarmingAllocation;
import org.farming.process.FarmingGenerateFreightOrderAbstract;
import org.spin.model.MFMAgreement;

public class FarmingGenerateFreightOrder
extends FarmingGenerateFreightOrderAbstract {
    private AtomicInteger created = new AtomicInteger();
    private StringBuffer generatedDocuments = new StringBuffer();
    private List<Integer> freightOrdersReference = new ArrayList<Integer>();
    private int defaultWeightUomId = 0;
    private int defaultVolumeUomId = 0;

    @Override
    protected void prepare() {
        MClientInfo clientInfo;
        super.prepare();
        if (this.getFreightAmt() == null) {
            this.setFreightAmt(Env.ZERO);
        }
        if (this.getDateDoc() == null) {
            this.setDateDoc(TimeUtil.getDay((long)System.currentTimeMillis()));
        }
        if ((clientInfo = MClientInfo.get((Properties)this.getCtx())).getC_UOM_Weight_ID() == 0) {
            this.defaultWeightUomId = clientInfo.getC_UOM_Weight_ID();
            this.defaultVolumeUomId = clientInfo.getC_UOM_Volume_ID();
        }
    }

    protected String doIt() throws Exception {
        Iterable farmings = null;
        if (this.getRecord_ID() > 0 && this.getTableName().equals("FAP_Farming")) {
            farmings = new Query(this.getCtx(), "FAP_Farming", "FAP_Farming_ID = ? AND DocStatus = ?", this.get_TrxName()).setParameters(new Object[]{this.getRecord_ID(), "CO"}).list();
        } else if (this.isSelection()) {
            this.getProcessInfo().setTableSelectionId(MFAPFarming.Table_ID);
            farmings = this.getInstancesForSelection(this.get_TrxName());
        }
        farmings.forEach(farming -> this.createOrder((MFAPFarming)farming));
        this.processOrders();
        return "@Created@ " + this.created + (this.generatedDocuments.length() > 0 ? " [" + this.generatedDocuments + "]" : "");
    }

    private void createOrder(MFAPFarming farming) {
        BigDecimal farmingEstimatedQuantity = Optional.ofNullable(farming.getEstimatedQty()).orElse(Env.ZERO).subtract(Optional.ofNullable(farming.getFarmingTransportedQuantity()).orElse(Env.ZERO));
        if (farmingEstimatedQuantity.signum() <= 0) {
            return;
        }
        BigDecimal weightCapacity = Env.ZERO;
        int weightUomId = 0;
        if (this.getVehicleId() > 0) {
            MDDVehicle vehicle = new MDDVehicle(this.getCtx(), this.getVehicleId(), this.get_TrxName());
            weightCapacity = Optional.ofNullable(vehicle.getMaximumWeight()).orElse(Env.ZERO);
            weightUomId = vehicle.getWeight_UOM_ID();
        }
        if (weightCapacity.signum() == 0) {
            MDDVehicleType vehicleType = new MDDVehicleType(this.getCtx(), this.getVehicleTypeId(), this.get_TrxName());
            weightCapacity = Optional.ofNullable(vehicleType.getMaximumWeight()).orElse(Env.ZERO);
            weightUomId = vehicleType.getWeight_UOM_ID();
        }
        if (weightCapacity.signum() <= 0) {
            throw new AdempiereException("@MaximumWeight@ @IsMandatory@");
        }
        if (weightUomId <= 0) {
            weightUomId = this.defaultWeightUomId;
        }
        if (weightUomId <= 0) {
            throw new AdempiereException("@C_UOM_Weight_ID@ @NotFound@");
        }
        MProduct product = MProduct.get((Properties)this.getCtx(), (int)farming.getCategory_ID());
        BigDecimal estimatedQuantity = Optional.ofNullable(farmingEstimatedQuantity).orElse(Env.ZERO);
        if (product.getC_UOM_ID() != weightUomId) {
            BigDecimal rate = MUOMConversion.getProductRateFrom((Properties)Env.getCtx(), (int)product.getM_Product_ID(), (int)weightUomId);
            MUOM uom = MUOM.get((Properties)this.getCtx(), (int)product.getC_UOM_ID());
            int precision = uom.getStdPrecision();
            if (rate == null) {
                throw new AdempiereException("@NoUOMConversion@ @from@ " + uom.getX12DE355() + " @to@ " + MUOM.get((Properties)this.getCtx(), (int)weightUomId).getX12DE355());
            }
            estimatedQuantity = Optional.ofNullable(farmingEstimatedQuantity).orElse(Env.ZERO).multiply(rate).setScale(precision, 4);
        }
        if (estimatedQuantity.signum() <= 0) {
            throw new AdempiereException("@EstimatedQty@ @IsMandatory@");
        }
        BigDecimal freightQuantity = Env.ZERO;
        BigDecimal maximunQuantity = Env.ZERO;
        if (estimatedQuantity.compareTo(weightCapacity) <= 0) {
            freightQuantity = Env.ONE;
            maximunQuantity = Env.ONE;
            weightCapacity = estimatedQuantity;
        } else {
            freightQuantity = estimatedQuantity.divide(weightCapacity, MathContext.DECIMAL128);
            maximunQuantity = freightQuantity.setScale(0, 0);
        }
        BigDecimal weight = maximunQuantity.subtract(freightQuantity);
        int freightMaximumQuantity = Math.min(Optional.ofNullable(this.getMaxQty()).orElse(Env.ONE).intValue(), maximunQuantity.intValue());
        for (int i = 0; i < freightMaximumQuantity; ++i) {
            this.createOrderFromWeight(farming, weightCapacity);
        }
        if (weight.signum() > 0) {
            this.createOrderFromWeight(farming, weight);
        }
    }

    private void createOrderFromWeight(MFAPFarming farming, BigDecimal weight) {
        MDDFreight freightOrder = new MDDFreight(this.getCtx(), 0, this.get_TrxName());
        if (this.getDriverId() > 0) {
            freightOrder.setDD_Driver_ID(this.getDriverId());
        }
        if (this.getVehicleId() > 0) {
            freightOrder.setDD_Vehicle_ID(this.getVehicleId());
        }
        freightOrder.setAD_Org_ID(this.getOrgId());
        freightOrder.setDateDoc(this.getDateDoc());
        freightOrder.setM_Shipper_ID(this.getShipperId());
        freightOrder.setDateOrdered(this.getDateDoc());
        if (this.getDocTypeTargetId() > 0) {
            freightOrder.setC_DocType_ID(this.getDocTypeTargetId());
        } else {
            freightOrder.setC_DocType_ID(MDocType.getDocType((String)"FRO", (int)this.getOrgId()));
        }
        freightOrder.setDocAction(this.getDocAction());
        if (this.isOverwriteFreightCostRule()) {
            freightOrder.setFreightCostRule(this.getFreightCostRule());
        }
        freightOrder.setFreightAmt(this.getFreightAmt());
        freightOrder.set_ValueOfColumn("FAP_Farming_ID", (Object)farming.getFAP_Farming_ID());
        freightOrder.set_ValueOfColumn("IsFarmerAssistanceProgram", (Object)true);
        Optional<MFMAgreement> maybeAgreement = MFAPFarmingAllocation.getAgreementListOfFarming(this.getCtx(), farming.getFAP_Farming_ID(), this.get_TrxName()).stream().filter(agreement -> agreement.getDocStatus().equals("CO")).findFirst();
        maybeAgreement.ifPresent(agreement -> freightOrder.set_ValueOfColumn("FM_Agreement_ID", (Object)agreement.getFM_Agreement_ID()));
        if (this.getBPartnerId() > 0) {
            freightOrder.setC_BPartner_ID(this.getBPartnerId());
        }
        if (this.getWarehouseId() > 0) {
            freightOrder.set_ValueOfColumn("FAP_Warehouse_ID", (Object)this.getWarehouseId());
        }
        freightOrder.saveEx();
        AtomicInteger lineNo = new AtomicInteger();
        AtomicInteger lines = new AtomicInteger();
        AtomicReference<BigDecimal> freightAmount = new AtomicReference<BigDecimal>(Env.ZERO);
        MDDFreightLine freightLine = new MDDFreightLine(this.getCtx(), 0, this.get_TrxName());
        freightLine.setAD_Org_ID(this.getOrgId());
        freightLine.setDD_Freight_ID(freightOrder.getDD_Freight_ID());
        freightLine.setLine(lineNo.addAndGet(10));
        freightLine.setWeight(weight);
        freightLine.setVolume(Env.ZERO);
        freightLine.setFreightAmt(this.getFreightAmt());
        freightLine.setFreightRate(Env.ZERO);
        if (this.isOverwriteFreightCostRule()) {
            freightLine.setM_FreightCategory_ID(this.getFreightCategoryId());
            MFreight freight = new MFreight(this.getCtx(), this.getFreightCategoryId(), this.get_TrxName());
            freightLine.setM_FreightCategory_ID(freight.getM_FreightCategory_ID());
        }
        int weightUomId = 0;
        int volumeUomId = 0;
        if (this.getVehicleId() > 0) {
            MDDVehicle vehicle = new MDDVehicle(this.getCtx(), this.getVehicleId(), this.get_TrxName());
            weightUomId = vehicle.getWeight_UOM_ID();
            volumeUomId = vehicle.getVolume_UOM_ID();
        }
        if (weightUomId <= 0 && volumeUomId <= 0) {
            MDDVehicleType vehicleType = new MDDVehicleType(this.getCtx(), this.getVehicleTypeId(), this.get_TrxName());
            weightUomId = vehicleType.getWeight_UOM_ID();
            volumeUomId = vehicleType.getVolume_UOM_ID();
        }
        if (weightUomId <= 0 && volumeUomId <= 0) {
            weightUomId = this.defaultWeightUomId;
            volumeUomId = this.defaultVolumeUomId;
        }
        if (weightUomId <= 0) {
            throw new AdempiereException("@C_UOM_Weight_ID@ @NotFound@ @SeeClientInfoConfig@");
        }
        if (volumeUomId <= 0) {
            throw new AdempiereException("@C_UOM_Volume_ID@ @NotFound@ @SeeClientInfoConfig@");
        }
        freightLine.setWeight_UOM_ID(weightUomId);
        freightLine.setVolume_UOM_ID(volumeUomId);
        freightLine.set_ValueOfColumn("FAP_Farming_ID", (Object)farming.getFAP_Farming_ID());
        freightLine.setC_BPartner_ID(farming.getC_BPartner_ID());
        if (this.getFreightCategoryId() > 0) {
            MFreightCategory freightCategory = MFreightCategory.getById((Properties)this.getCtx(), (int)this.getFreightCategoryId(), (String)this.get_TrxName());
            if (freightCategory.getM_Product_ID() > 0) {
                freightLine.setM_Product_ID(freightCategory.getM_Product_ID());
            } else {
                freightLine.setC_Charge_ID(freightCategory.getC_Charge_ID());
            }
        }
        freightLine.saveEx();
        lines.addAndGet(1);
        freightAmount.getAndUpdate(amount -> amount.add(this.getFreightAmt()));
        this.addLog(freightOrder.getDD_Freight_ID(), freightOrder.getDateDoc(), null, freightOrder.getDocumentNo());
        if (!this.isOverwriteFreightCostRule()) {
            freightOrder.setFreightAmt(freightAmount.get());
        }
        freightOrder.saveEx();
        this.freightOrdersReference.add(freightOrder.getDD_Freight_ID());
    }

    private void addToMessage(String documentInfo) {
        if (this.generatedDocuments.length() > 0) {
            this.generatedDocuments.append(", ");
        }
        this.generatedDocuments.append(documentInfo);
    }

    private void processOrders() {
        if (this.freightOrdersReference == null || this.freightOrdersReference.isEmpty()) {
            return;
        }
        ArrayList freightOrdersToPrint = new ArrayList();
        this.freightOrdersReference.forEach(freightOrderId -> {
            MDDFreight freightOrder = new MDDFreight(this.getCtx(), freightOrderId.intValue(), this.get_TrxName());
            freightOrder.setDocAction(this.getDocAction());
            try {
                if (!freightOrder.processIt(this.getDocAction())) {
                    this.addLog("@ProcessFailed@ : " + freightOrder.getDocumentInfo());
                    this.log.warning("@ProcessFailed@ :" + freightOrder.getDocumentInfo());
                } else {
                    freightOrdersToPrint.add(freightOrder);
                }
            }
            catch (Exception e) {
                this.addLog("@ProcessFailed@ : " + freightOrder.getDocumentInfo());
                this.log.warning("@ProcessFailed@ :" + freightOrder.getDocumentInfo());
            }
            freightOrder.saveEx();
            this.created.addAndGet(1);
            this.addToMessage(freightOrder.getDocumentNo());
        });
        this.printDocument(freightOrdersToPrint, true);
    }
}

