/*
 * Decompiled with CFR 0.152.
 */
package org.farming.process;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MRefList;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.farming.model.MFAPRawMaterialConditioning;
import org.farming.process.CreateNegotiatedCalculationFromRecordWeightAbstract;
import org.farming.util.FarmingTechnicalAssistanceUtil;

public class CreateNegotiatedCalculationFromRecordWeight
extends CreateNegotiatedCalculationFromRecordWeightAbstract {
    private List<MRefList> attributesList = null;
    private AtomicInteger created = new AtomicInteger();
    private StringBuffer generatedDocuments = new StringBuffer();

    protected String doIt() throws Exception {
        this.getSelectionValues();
        this.getSelectionKeys().stream().forEach(key -> this.createCalculation((int)key));
        this.openResult("FAP_RawMaterialConditioning");
        return "@Created@ " + this.created + (this.generatedDocuments.length() > 0 ? " [" + this.generatedDocuments + "]" : "");
    }

    private void createCalculation(int qualityAnalysisId) {
        PO qualityAnalysis = MTable.get((Properties)this.getCtx(), (String)"RM_QualityAnalysis").getPO(qualityAnalysisId, this.get_TrxName());
        int recordWeightId = qualityAnalysis.get_ValueAsInt("DD_RecordWeight_ID");
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        this.getAttributesKeys().forEach(action -> {
            BigDecimal attribute = this.getSelectionAsBigDecimal(qualityAnalysisId, "AttributeValue_" + action.getValue());
            attributes.put(action.getValue(), attribute);
        });
        try {
            MFAPRawMaterialConditioning calculatedWeight = FarmingTechnicalAssistanceUtil.createConditioningWeightCalculation(this.getCtx(), recordWeightId, attributes, this.getDateDoc(), this.getDocTypeId(), this.getDocAction(), this.getDescription(), this.get_TrxName(), "PC");
            if (calculatedWeight != null) {
                this.addLog(calculatedWeight.getFAP_RawMaterialConditioning_ID(), calculatedWeight.getDateDoc(), null, calculatedWeight.getDocumentNo());
                this.created.addAndGet(1);
                this.addToMessage(calculatedWeight.getDocumentNo());
            }
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            this.addLog("@RM_QualityAnalysis_ID@: " + qualityAnalysis.get_ValueAsString("DocumentNo") + " @Error@ " + e.getLocalizedMessage());
        }
    }

    private void addToMessage(String documentInfo) {
        if (this.generatedDocuments.length() > 0) {
            this.generatedDocuments.append(", ");
        }
        this.generatedDocuments.append(documentInfo);
    }

    private List<MRefList> getAttributesKeys() {
        if (this.attributesList != null) {
            return this.attributesList;
        }
        this.attributesList = new Query(this.getCtx(), "AD_Ref_List", "AD_Reference_ID = ?", this.get_TrxName()).setParameters(new Object[]{54258}).list();
        return this.attributesList;
    }
}

