/*
 * Decompiled with CFR 0.152.
 */
package org.farming.process;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MRefList;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.farming.model.MFAPRawMaterialConditioning;
import org.farming.process.CreateAPFromRecordWeightAbstract;
import org.farming.util.FarmingTechnicalAssistanceUtil;

public class CreateAPFromRecordWeight
extends CreateAPFromRecordWeightAbstract {
    private List<MRefList> attributesList = null;
    private AtomicInteger created = new AtomicInteger();
    private StringBuffer generatedDocuments = new StringBuffer();
    private MInvoice invoice;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getRecord_ID() == 0) {
            throw new AdempiereException("@C_Invoice_ID@ @NotFound@");
        }
        this.invoice = new MInvoice(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (this.invoice.isProcessed()) {
            throw new AdempiereException("@C_Invoice_ID@ @Processed@");
        }
    }

    protected String doIt() throws Exception {
        this.getSelectionValues();
        this.getSelectionKeys().stream().forEach(key -> this.createCalculation((int)key));
        return "@Created@ " + this.created + (this.generatedDocuments.length() > 0 ? " [" + this.generatedDocuments + "]" : "");
    }

    private void createCalculation(int qualityAnalysisId) {
        PO qualityAnalysis = MTable.get((Properties)this.getCtx(), (String)"RM_QualityAnalysis").getPO(qualityAnalysisId, this.get_TrxName());
        int recordWeightId = qualityAnalysis.get_ValueAsInt("DD_RecordWeight_ID");
        Map<String, Object> attributesRecordWeight = FarmingTechnicalAssistanceUtil.getAttributesMapFromRecordWeight(this.getCtx(), recordWeightId, this.get_TrxName());
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        AtomicReference<Boolean> generatedRawMaterialConditioning = new AtomicReference<Boolean>(false);
        this.getAttributesKeys().forEach(action -> {
            BigDecimal attribute = this.getSelectionAsBigDecimal(qualityAnalysisId, "AttributeValue_" + action.getValue());
            attributes.put(action.getValue(), attribute);
            if (!((Boolean)generatedRawMaterialConditioning.get()).booleanValue()) {
                Optional.ofNullable((BigDecimal)attributesRecordWeight.get(action.getValue())).ifPresent(rwValue -> generatedRawMaterialConditioning.set(rwValue.compareTo(attribute) != 0));
            }
        });
        try {
            MFAPRawMaterialConditioning calculatedWeight = null;
            if (generatedRawMaterialConditioning.get().booleanValue()) {
                calculatedWeight = this.createConditioningWeightCalculation(recordWeightId, attributes);
                if (calculatedWeight != null) {
                    this.addLog(calculatedWeight.getFAP_RawMaterialConditioning_ID(), calculatedWeight.getDateDoc(), null, calculatedWeight.getDocumentNo());
                    this.created.addAndGet(1);
                    this.addToMessage(calculatedWeight.getDocumentNo());
                }
            } else {
                String whereClause = "DocStatus IN ('".concat("CO").concat("', '").concat("CL").concat("') AND IsNegotiatedAttributes = 'Y' AND ").concat("DD_RecordWeight_ID").concat(" = ? ");
                calculatedWeight = (MFAPRawMaterialConditioning)new Query(this.getCtx(), "FAP_RawMaterialConditioning", whereClause, this.get_TrxName()).setParameters(new Object[]{recordWeightId}).first();
                if (calculatedWeight == null) {
                    calculatedWeight = this.createConditioningWeightCalculation(recordWeightId, attributes);
                }
            }
            Optional.ofNullable(calculatedWeight).ifPresent(conditioning -> {
                int inoutLineId;
                PO recordWeight = MTable.get((Properties)this.getCtx(), (String)"DD_RecordWeight").getPO(recordWeightId, this.get_TrxName());
                MInvoiceLine invoiceline = new MInvoiceLine(this.invoice);
                invoiceline.setM_Product_ID(conditioning.getM_Product_ID());
                invoiceline.setQty(conditioning.getConditionedWeight());
                invoiceline.setPrice();
                if (recordWeight.get_ValueAsInt("C_OrderLine_ID") > 0) {
                    invoiceline.setC_OrderLine_ID(recordWeight.get_ValueAsInt("C_OrderLine_ID"));
                }
                if ((inoutLineId = this.getInOutLineFromRecordWeight(recordWeightId, conditioning.getM_Product_ID())) > 0) {
                    invoiceline.setM_InOutLine_ID(inoutLineId);
                }
                invoiceline.saveEx();
            });
        }
        catch (Exception e) {
            this.log.severe(e.getLocalizedMessage());
            this.addLog("@RM_QualityAnalysis_ID@: " + qualityAnalysis.get_ValueAsString("DocumentNo") + " @Error@ " + e.getLocalizedMessage());
        }
    }

    private void addToMessage(String documentInfo) {
        if (this.generatedDocuments.length() > 0) {
            this.generatedDocuments.append(", ");
        }
        this.generatedDocuments.append(documentInfo);
    }

    private List<MRefList> getAttributesKeys() {
        if (this.attributesList != null) {
            return this.attributesList;
        }
        this.attributesList = new Query(this.getCtx(), "AD_Ref_List", "AD_Reference_ID = ?", this.get_TrxName()).setParameters(new Object[]{54258}).list();
        return this.attributesList;
    }

    private MFAPRawMaterialConditioning createConditioningWeightCalculation(int recordWeightId, Map<String, Object> attributes) {
        MFAPRawMaterialConditioning calculatedWeight = FarmingTechnicalAssistanceUtil.createConditioningWeightCalculation(this.getCtx(), recordWeightId, attributes, this.invoice.getDateInvoiced(), 0, "CO", this.invoice.getDescription(), this.get_TrxName(), "PC");
        if (calculatedWeight != null) {
            this.addLog(calculatedWeight.getFAP_RawMaterialConditioning_ID(), calculatedWeight.getDateDoc(), null, calculatedWeight.getDocumentNo());
            this.created.addAndGet(1);
            this.addToMessage(calculatedWeight.getDocumentNo());
        }
        return calculatedWeight;
    }

    private int getInOutLineFromRecordWeight(int recordWeightId, int productId) {
        int inoutLineId = -1;
        String sql = "SELECT iol.M_InOutLine_ID FROM M_InOut io INNER JOIN M_InOutLine iol ON (io.M_InOut_ID = iol.M_InOut_ID) INNER JOIN WM_InOutBoundLine wmiol ON (iol.WM_InOutBoundLine_ID = wmiol.WM_InOutBoundLine_ID) INNER JOIN WM_InOutBound wmio ON (wmiol.WM_InOutBound_ID = wmio.WM_InOutBound_ID) WHERE io.DocStatus IN ('CO', 'CL') AND wmio.DocStatus IN ('CO', 'CL') AND wmio.DD_RecordWeight_ID = ? AND wmiol.M_Product_ID = ? ";
        inoutLineId = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)recordWeightId, (int)productId);
        return inoutLineId;
    }
}

