/*
 * Decompiled with CFR 0.152.
 */
package org.farming.process;

import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MOrder;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.farming.process.AgreementGeneratePrepaymentAbstract;
import org.farming.util.FarmingTechnicalAssistanceUtil;
import org.spin.model.MFMAgreement;

public class AgreementGeneratePrepayment
extends AgreementGeneratePrepaymentAbstract {
    private AtomicInteger sequence = new AtomicInteger();
    private AtomicInteger created = new AtomicInteger();
    private StringBuffer generatedDocuments = new StringBuffer();
    private MPaySelection paymentSelection;

    protected String doIt() throws Exception {
        Iterable agreements = null;
        if (this.getRecord_ID() > 0 && this.getTableName().equals("FM_Agreement")) {
            agreements = new Query(this.getCtx(), "FM_Agreement", "FM_Agreement_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getRecord_ID()}).list();
        } else if (this.isSelection()) {
            this.getProcessInfo().setTableSelectionId(MFMAgreement.Table_ID);
            agreements = this.getInstancesForSelection(this.get_TrxName());
        }
        this.createPaymentSelection();
        agreements.forEach(agreement -> this.createPaymentSelectionLine((MFMAgreement)agreement));
        this.processPaymentSelection();
        this.openResult("C_PaySelection");
        return "@Created@ " + this.created + " - " + this.paymentSelection.getDocumentNo() + (this.generatedDocuments.length() > 0 ? " [" + this.generatedDocuments + "]" : "");
    }

    private void createPaymentSelectionLine(MFMAgreement agreement) {
        MOrder purchaseOrder = FarmingTechnicalAssistanceUtil.getPurchaseOrderFromAgreement(this.getCtx(), agreement.getFM_Agreement_ID(), 0, this.get_TrxName());
        if (purchaseOrder != null && purchaseOrder.getC_Order_ID() > 0) {
            String paymentRule = purchaseOrder.getPaymentRule();
            MPaySelectionLine paymentSelectionLine = new MPaySelectionLine(this.paymentSelection, this.sequence.addAndGet(10), paymentRule);
            paymentSelectionLine.setOrder(purchaseOrder.getC_Order_ID(), purchaseOrder.getGrandTotal(), Env.ZERO, this.getPayAmt(), Env.ZERO);
            paymentSelectionLine.set_ValueOfColumn("FM_Agreement_ID", (Object)agreement.getFM_Agreement_ID());
            paymentSelectionLine.saveEx();
            this.created.incrementAndGet();
            this.addToMessage(purchaseOrder.getDocumentNo());
        }
    }

    private MPaySelection createPaymentSelection() {
        if (this.getRecord_ID() > 0 && this.getTableName().equals("C_PaySelection")) {
            this.paymentSelection = new MPaySelection(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
            return this.paymentSelection;
        }
        this.paymentSelection = new MPaySelection(this.getCtx(), 0, this.get_TrxName());
        this.paymentSelection.setAD_Org_ID(this.getOrgId());
        this.paymentSelection.setPayDate(this.getDateDoc());
        this.paymentSelection.setDateDoc(this.getDateDoc());
        this.paymentSelection.setC_Currency_ID(this.getCurrencyId());
        if (this.getDocTypeTargetId() > 0) {
            this.paymentSelection.setC_DocType_ID(this.getDocTypeTargetId());
        } else {
            this.paymentSelection.setC_DocType_ID();
        }
        this.paymentSelection.setDocAction(this.getDocAction());
        this.paymentSelection.setDocStatus("DR");
        this.paymentSelection.setProcessed(false);
        this.paymentSelection.set_ValueOfColumn("IsFarmerAssistanceProgram", (Object)true);
        if (!Util.isEmpty((String)this.getDescription())) {
            if (Util.isEmpty((String)this.paymentSelection.getDescription())) {
                this.paymentSelection.setDescription(this.getDescription());
            } else {
                this.paymentSelection.setDescription(this.paymentSelection.getDescription() + " | " + this.getDescription());
            }
        }
        this.paymentSelection.saveEx();
        return this.paymentSelection;
    }

    private void addToMessage(String documentInfo) {
        if (this.generatedDocuments.length() > 0) {
            this.generatedDocuments.append(", ");
        }
        this.generatedDocuments.append(documentInfo);
    }

    private void processPaymentSelection() {
        this.paymentSelection.setDocAction(this.getDocAction());
        if (!this.paymentSelection.processIt(this.getDocAction())) {
            this.addLog("@ProcessFailed@ : " + this.paymentSelection.getDocumentInfo());
            this.log.warning("@ProcessFailed@ :" + this.paymentSelection.getDocumentInfo());
        }
        this.paymentSelection.saveEx();
        this.addLog(this.paymentSelection.getC_PaySelection_ID(), this.paymentSelection.getDateDoc(), null, "@OK@");
    }
}

