/*
 * Decompiled with CFR 0.152.
 */
package org.farming.process;

import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.farming.model.MFAPFarmingAllocation;
import org.farming.process.AgreementGenerateOrderAbstract;
import org.spin.model.MFMAgreement;

public class AgreementGenerateOrder
extends AgreementGenerateOrderAbstract {
    private Map<Integer, MOrder> orders = new Hashtable<Integer, MOrder>();
    private AtomicInteger created = new AtomicInteger();
    private StringBuffer generatedDocuments = new StringBuffer();

    protected String doIt() throws Exception {
        Iterable agreements = null;
        if (this.getRecord_ID() > 0 && this.getTableName().equals("FM_Agreement")) {
            agreements = new Query(this.getCtx(), "FM_Agreement", "FM_Agreement_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getRecord_ID()}).list();
        } else if (this.isSelection()) {
            this.getProcessInfo().setTableSelectionId(MFMAgreement.Table_ID);
            agreements = this.getInstancesForSelection(this.get_TrxName());
        }
        agreements.forEach(farmerCredit -> this.createOrder((MFMAgreement)farmerCredit));
        this.processOrders();
        this.openResult("C_Order");
        return "@Created@ " + this.created + (this.generatedDocuments.length() > 0 ? " [" + this.generatedDocuments + "]" : "");
    }

    private void createOrder(MFMAgreement agreement) {
        MOrder order = this.getOrder(agreement);
        AtomicBoolean created = new AtomicBoolean(false);
        MFAPFarmingAllocation.getFarmingListOfAgreement(this.getCtx(), agreement.getFM_Agreement_ID(), this.get_TrxName()).stream().filter(farming -> Optional.ofNullable(farming.getEstimatedQty()).orElse(Env.ZERO).subtract(Optional.ofNullable(farming.getQtyOrdered()).orElse(Env.ZERO)).signum() > 0).forEach(farming -> {
            MOrderLine orderLine = new MOrderLine(order);
            MProduct product = MProduct.get((Properties)this.getCtx(), (int)farming.getCategory_ID());
            if (this.getWarehouseId() > 0) {
                order.setM_Warehouse_ID(this.getWarehouseId());
            }
            orderLine.setProduct(product);
            orderLine.setPrice();
            BigDecimal quantityToOrder = Optional.ofNullable(farming.getEstimatedQty()).orElse(Env.ZERO).subtract(Optional.ofNullable(farming.getQtyOrdered()).orElse(Env.ZERO));
            orderLine.setQtyEntered(quantityToOrder);
            orderLine.setQtyOrdered(quantityToOrder);
            orderLine.set_ValueOfColumn("FAP_Farming_ID", (Object)farming.getFAP_Farming_ID());
            if (!Util.isEmpty((String)this.getDescription())) {
                orderLine.addDescription(this.getDescription());
            }
            orderLine.saveEx(this.get_TrxName());
            created.set(true);
        });
        if (!created.get()) {
            throw new AdempiereException("@UnavailableFarmingToCreateOrder@");
        }
    }

    private MOrder getOrder(MFMAgreement agreement) {
        MOrder order = this.orders.get(agreement.getFM_Agreement_ID());
        if (order != null) {
            return order;
        }
        MBPartner businessPartner = MBPartner.get((Properties)this.getCtx(), (int)agreement.getC_BPartner_ID());
        order = new MOrder(this.getCtx(), 0, this.get_TrxName());
        order.setAD_Org_ID(this.getOrgId());
        order.setIsSOTrx(false);
        order.setBPartner(businessPartner);
        order.setDateOrdered(this.getDateDoc());
        order.setDatePromised(this.getDateDoc());
        order.addDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)("@Created@ @From@ @FM_Agreement_ID@: " + agreement.getDocumentNo())));
        if (this.getDocTypeTargetId() > 0) {
            order.setC_DocTypeTarget_ID(this.getDocTypeTargetId());
        } else {
            order.setC_DocTypeTarget_ID();
        }
        order.setDocAction(this.getDocAction());
        order.setDocStatus("DR");
        order.setProcessed(false);
        if (this.getWarehouseId() > 0) {
            order.setM_Warehouse_ID(this.getWarehouseId());
        }
        order.set_ValueOfColumn("FM_Agreement_ID", (Object)agreement.getFM_Agreement_ID());
        order.set_ValueOfColumn("IsFarmerAssistanceProgram", (Object)true);
        order.saveEx();
        this.orders.put(agreement.getFM_Agreement_ID(), order);
        this.addLog(order.getC_Order_ID(), order.getDateOrdered(), null, order.getDocumentNo());
        return order;
    }

    private void addToMessage(String documentInfo) {
        if (this.generatedDocuments.length() > 0) {
            this.generatedDocuments.append(", ");
        }
        this.generatedDocuments.append(documentInfo);
    }

    private void processOrders() {
        if (this.orders == null) {
            return;
        }
        this.orders.entrySet().stream().filter(entry -> entry != null).forEach(entry -> {
            MOrder order = (MOrder)entry.getValue();
            order.setDocAction(this.getDocAction());
            if (!order.processIt(this.getDocAction())) {
                this.addLog("@ProcessFailed@ : " + order.getDocumentInfo());
                this.log.warning("@ProcessFailed@ :" + order.getDocumentInfo());
            }
            order.saveEx();
            this.created.addAndGet(1);
            this.addToMessage(order.getDocumentNo());
        });
    }
}

