/*
 * Decompiled with CFR 0.152.
 */
package org.farming.process;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.farming.process.AgreementGenerateFeeAbstract;
import org.spin.model.MFMAgreement;

public class AgreementGenerateFee
extends AgreementGenerateFeeAbstract {
    private Map<Integer, MOrder> orders = new Hashtable<Integer, MOrder>();
    private AtomicInteger created = new AtomicInteger();
    private StringBuffer generatedDocuments = new StringBuffer();

    protected String doIt() throws Exception {
        Iterable agreements = null;
        if (this.getRecord_ID() > 0 && this.getTableName().equals("FM_Agreement")) {
            agreements = new Query(this.getCtx(), "FM_Agreement", "FM_Agreement_ID = ?", this.get_TrxName()).setParameters(new Object[]{this.getRecord_ID()}).list();
        } else if (this.isSelection()) {
            this.getProcessInfo().setTableSelectionId(MFMAgreement.Table_ID);
            agreements = this.getInstancesForSelection(this.get_TrxName());
        }
        agreements.forEach(farmerCredit -> this.createOrder((MFMAgreement)farmerCredit));
        this.processOrders();
        this.openResult("C_Order");
        return "@Created@ " + this.created + (this.generatedDocuments.length() > 0 ? " [" + this.generatedDocuments + "]" : "");
    }

    private void createOrder(MFMAgreement agreement) {
        BigDecimal feeAmount = Env.ZERO;
        String description = null;
        if (this.isApplieToFarmerInvoicing()) {
            if (Optional.ofNullable(this.getRate()).orElse(Env.ZERO).compareTo(Env.ZERO) == 0) {
                throw new AdempiereException("@Rate@ @IsMandatory@");
            }
            String sql = "SELECT SUM(t.Amount) FROM FM_Batch b INNER JOIN FM_Transaction t ON(t.FM_Batch_ID = b.FM_Batch_ID) WHERE b.DocStatus IN('CO', 'CL') AND t.IsFarmerTransactionReversal = 'N' AND EXISTS(SELECT 1 FROM FM_TransactionType tt WHERE tt.FM_TransactionType_ID = t.FM_TransactionType_ID AND tt.Type IN('FFI', 'FFT')) AND EXISTS(SELECT 1 FROM FM_Account a WHERE a.FM_Account_ID = b.FM_Account_ID AND a.FM_Agreement_ID = ?)";
            BigDecimal invoiceAmount = DB.getSQLValueBD((String)this.get_TrxName(), (String)sql, (int)agreement.getFM_Agreement_ID());
            if (Optional.ofNullable(invoiceAmount).orElse(Env.ZERO).compareTo(Env.ZERO) == 0) {
                feeAmount = Env.ZERO;
            } else {
                feeAmount = this.getRate().divide(Env.ONEHUNDRED, MathContext.DECIMAL128).multiply(invoiceAmount);
                description = Msg.getMsg((Properties)this.getCtx(), (String)"FAP.CreatedFromInvoiceFee", (Object[])new Object[]{invoiceAmount, this.getRate()});
            }
        } else {
            if (Optional.ofNullable(this.getFeeAmt()).orElse(Env.ZERO).compareTo(Env.ZERO) == 0) {
                throw new AdempiereException("@FeeAmt@ @IsMandatory@");
            }
            feeAmount = this.getFeeAmt();
            description = Msg.getMsg((Properties)this.getCtx(), (String)"FAP.CreatedFromInvoiceFeeAmount", (Object[])new Object[]{this.getFeeAmt()});
        }
        if (Optional.ofNullable(feeAmount).orElse(Env.ZERO).compareTo(Env.ZERO) == 0) {
            return;
        }
        MOrder order = this.getOrder(agreement);
        AtomicBoolean created = new AtomicBoolean(false);
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setC_Charge_ID(this.getChargeId());
        orderLine.setPrice(feeAmount);
        orderLine.setQtyEntered(Env.ONE);
        orderLine.setQtyOrdered(Env.ONE);
        if (!Util.isEmpty((String)this.getDescription())) {
            orderLine.addDescription(this.getDescription());
        }
        if (!Util.isEmpty((String)description)) {
            orderLine.addDescription(description);
        }
        orderLine.saveEx(this.get_TrxName());
        created.set(true);
    }

    private MOrder getOrder(MFMAgreement agreement) {
        MOrder order = this.orders.get(agreement.getFM_Agreement_ID());
        if (order != null) {
            return order;
        }
        MBPartner businessPartner = MBPartner.get((Properties)this.getCtx(), (int)agreement.getC_BPartner_ID());
        order = new MOrder(this.getCtx(), 0, this.get_TrxName());
        order.setAD_Org_ID(this.getOrgId());
        order.setIsSOTrx(true);
        order.setBPartner(businessPartner);
        order.setDateOrdered(this.getDateDoc());
        order.setDatePromised(this.getDateDoc());
        order.addDescription(Msg.parseTranslation((Properties)this.getCtx(), (String)("@Created@ @From@ @FM_Agreement_ID@: " + agreement.getDocumentNo())));
        if (!Util.isEmpty((String)this.getDescription())) {
            order.addDescription(this.getDescription());
        }
        order.setIsSOTrx(true);
        if (this.getDocTypeTargetId() > 0) {
            order.setC_DocTypeTarget_ID(this.getDocTypeTargetId());
        } else {
            order.setC_DocTypeTarget_ID("SO");
        }
        order.setDocAction(this.getDocAction());
        order.setDocStatus("DR");
        order.setProcessed(false);
        order.set_ValueOfColumn("FM_Agreement_ID", (Object)agreement.getFM_Agreement_ID());
        order.set_ValueOfColumn("IsFarmerAssistanceProgram", (Object)true);
        order.saveEx();
        this.orders.put(agreement.getFM_Agreement_ID(), order);
        this.addLog(order.getC_Order_ID(), order.getDateOrdered(), null, order.getDocumentNo());
        return order;
    }

    private void addToMessage(String documentInfo) {
        if (this.generatedDocuments.length() > 0) {
            this.generatedDocuments.append(", ");
        }
        this.generatedDocuments.append(documentInfo);
    }

    private void processOrders() {
        if (this.orders == null) {
            return;
        }
        this.orders.entrySet().stream().filter(entry -> entry != null).forEach(entry -> {
            MOrder order = (MOrder)entry.getValue();
            order.setDocAction(this.getDocAction());
            if (!order.processIt(this.getDocAction())) {
                this.addLog("@ProcessFailed@ : " + order.getDocumentInfo());
                this.log.warning("@ProcessFailed@ :" + order.getDocumentInfo());
            }
            order.saveEx();
            this.created.addAndGet(1);
            this.addToMessage(order.getDocumentNo());
        });
    }
}

