/*
 * Decompiled with CFR 0.152.
 */
package org.farming.process;

import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.Util;
import org.farming.process.AgreementGenerateChargeAbstract;
import org.spin.model.MFMAccount;
import org.spin.model.MFMAccountProduct;
import org.spin.model.MFMAgreement;
import org.spin.util.FinancialSetting;

public class AgreementGenerateCharge
extends AgreementGenerateChargeAbstract {
    protected String doIt() throws Exception {
        MFMAgreement agreement;
        if (this.getRecord_ID() > 0) {
            if (!Util.isEmpty((String)this.getTableName()) && !this.getTableName().equals("FM_Agreement")) {
                throw new AdempiereException("@FM_Agreement_ID@ @NotFound@");
            }
            this.setAgreementId(this.getRecord_ID());
        }
        if (!(agreement = MFMAgreement.getById((Properties)this.getCtx(), (int)this.getAgreementId(), (String)this.get_TrxName())).getDocStatus().equals("CO")) {
            throw new AdempiereException("@FM_Product_ID@ @Invalid@");
        }
        Optional maybeProduct = agreement.getAccountProducts().stream().findFirst();
        if (!maybeProduct.isPresent()) {
            throw new AdempiereException("@FM_Product_ID@ @NotFound@");
        }
        MFMAccount account = null;
        if (this.getAccountId() > 0) {
            account = MFMAccount.getById((Properties)this.getCtx(), (int)this.getAccountId());
        }
        if (!Optional.ofNullable(account).isPresent()) {
            Optional maybeAccount = agreement.getAccounts().stream().findFirst();
            if (!maybeAccount.isPresent()) {
                throw new AdempiereException("@FM_Account_ID@ @NotFound@");
            }
            account = (MFMAccount)maybeAccount.get();
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("AD_Org_ID", this.getOrgId());
        parameters.put("C_BPartner_ID", this.getBPartnerId());
        parameters.put("FM_Agreement_ID", this.getAgreementId());
        parameters.put("FM_Account_ID", this.getAccountId());
        parameters.put("C_DocTypeTarget_ID", this.getDocTypeTargetId());
        parameters.put("DateDoc", this.getDateDoc());
        parameters.put("Amount", this.getAmount());
        parameters.put("FM_TransactionType_ID", this.getTransactionTypeId());
        parameters.put("Description", this.getDescription());
        parameters.put("MFMAccount", account);
        String result = FinancialSetting.get().fire(this.getCtx(), ((MFMAccountProduct)maybeProduct.get()).getFM_Product_ID(), "P", parameters, this.get_TrxName());
        if (!Util.isEmpty((String)result)) {
            throw new AdempiereException(result);
        }
        return "Ok";
    }
}

