/*
 * Decompiled with CFR 0.152.
 */
package org.farming.model.validator;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.GenericPO;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrder;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPayment;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.eevolution.model.MDDFreight;
import org.eevolution.model.MWMInOutBound;
import org.eevolution.model.MWMInOutBoundLine;
import org.farming.model.MFAPFarming;
import org.farming.model.MFAPFarmingAllocation;
import org.farming.model.MFAPFarmingDefinition;
import org.farming.util.FarmingTechnicalAssistanceUtil;
import org.spin.model.MFMAccount;
import org.spin.model.MFMAccountProduct;
import org.spin.model.MFMAgreement;
import org.spin.model.MFMBatch;
import org.spin.util.FinancialSetting;

public class FarmerAssistanceProgram
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(FarmerAssistanceProgram.class);
    private int clientId = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("FM_Agreement", (ModelValidator)this);
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
        engine.addDocValidate("C_PaySelection", (ModelValidator)this);
        engine.addDocValidate("C_Payment", (ModelValidator)this);
        engine.addDocValidate("C_Order", (ModelValidator)this);
        engine.addDocValidate("DD_Freight", (ModelValidator)this);
        engine.addDocValidate("FM_Batch", (ModelValidator)this);
        engine.addDocValidate("DD_RecordWeight", (ModelValidator)this);
        engine.addDocValidate("RM_QualityAnalysis", (ModelValidator)this);
        engine.addDocValidate("FAP_RawMaterialConditioning", (ModelValidator)this);
        engine.addModelChange("FM_Agreement", (ModelValidator)this);
        engine.addModelChange("RM_QualityAnalysis", (ModelValidator)this);
        engine.addModelChange("DD_RecordWeight", (ModelValidator)this);
        engine.addModelChange("WM_InOutBoundLine", (ModelValidator)this);
        engine.addModelChange("C_Invoice", (ModelValidator)this);
        engine.addModelChange("C_Payment", (ModelValidator)this);
        engine.addModelChange("C_Order", (ModelValidator)this);
        engine.addModelChange("M_MovementLine", (ModelValidator)this);
    }

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public String modelChange(PO entity, int type) throws Exception {
        MFMAgreement agreement;
        if (type == 1 || type == 2) {
            if (entity.get_TableName().equals("FM_Agreement")) {
                MFMAgreement agreement2 = (MFMAgreement)entity;
                if (agreement2.get_ValueAsBoolean("IsFarmerAssistanceProgram") && !agreement2.isProcessed() && (agreement2.is_ValueChanged("FAP_FarmingDefinition_ID") || agreement2.is_ValueChanged("FarmingArea"))) {
                    MFAPFarmingDefinition farmingDefinition = new MFAPFarmingDefinition(agreement2.getCtx(), agreement2.get_ValueAsInt("FAP_FarmingDefinition_ID"), agreement2.get_TrxName());
                    agreement2.setFM_Product_ID(farmingDefinition.getFM_Product_ID());
                    BigDecimal unitAmount = Optional.ofNullable(farmingDefinition.getApprovalAmt()).orElse(Env.ZERO);
                    BigDecimal farmingArea = Optional.ofNullable((BigDecimal)agreement2.get_Value("FarmingArea")).orElse(Env.ZERO);
                    BigDecimal farmingAmount = unitAmount.multiply(farmingArea);
                    agreement2.set_ValueOfColumn("FarmingAmount", (Object)farmingAmount);
                    agreement2.set_ValueOfColumn("FarmingApprovedAmount", (Object)farmingAmount);
                    agreement2.set_ValueOfColumn("FarmingApprovedArea", (Object)farmingArea);
                }
            } else if (entity.get_TableName().equals("DD_RecordWeight")) {
                if (entity.is_new() || entity.is_ValueChanged("DD_Freight_ID") && entity.get_ValueAsInt("DD_Freight_ID") > 0) {
                    FarmingTechnicalAssistanceUtil.setRecordWeightReference(entity);
                }
                if (entity.is_new() || entity.is_ValueChanged("C_DocType_ID") && entity.get_ValueAsInt("C_DocType_ID") > 0) {
                    MDocType documentType = MDocType.get((Properties)entity.getCtx(), (int)entity.get_ValueAsInt("C_DocType_ID"));
                    entity.set_ValueOfColumn("ReceiptReferenceWeight", documentType.get_Value("ReceiptReferenceWeight"));
                }
                FarmingTechnicalAssistanceUtil.setDefaultFarmerOverdrafCreditLimitFromDocumentType(entity);
            } else if (entity.get_TableName().equals("WM_InOutBoundLine")) {
                MWMInOutBoundLine inOutBoundLine = (MWMInOutBoundLine)entity;
                MWMInOutBound inOutBound = inOutBoundLine.getParent();
                if ((inOutBoundLine.is_new() || inOutBoundLine.is_ValueChanged("MovementQty")) && inOutBound.get_ValueAsInt("DD_RecordWeight_ID") > 0 && !inOutBoundLine.isProcessed()) {
                    GenericPO recordWeight2 = new GenericPO("DD_RecordWeight", inOutBoundLine.getCtx(), inOutBound.get_ValueAsInt("DD_RecordWeight_ID"), entity.get_TrxName());
                    BigDecimal receiptWeight = (BigDecimal)recordWeight2.get_Value("ConditionedWeight");
                    String receiptReferenceWeight = "ConditionedWeight";
                    if (!Util.isEmpty((String)recordWeight2.get_ValueAsString("ReceiptReferenceWeight"))) {
                        receiptReferenceWeight = recordWeight2.get_ValueAsString("ReceiptReferenceWeight");
                    }
                    if (receiptReferenceWeight.equals("G")) {
                        receiptWeight = (BigDecimal)recordWeight2.get_Value("NegotiatedConditionedWeight");
                    } else if (receiptReferenceWeight.equals("N")) {
                        receiptWeight = (BigDecimal)recordWeight2.get_Value("NetWeight");
                    }
                    Optional.ofNullable(receiptWeight).ifPresent(weight -> inOutBoundLine.setMovementQty(weight));
                }
            } else if (entity.get_TableName().equals("M_MovementLine") && !entity.get_ValueAsBoolean("Processed") && entity.is_ValueChanged("MovementQty") && entity.get_ValueAsInt("DD_RecordWeight_ID") > 0) {
                MMovementLine movementLine = (MMovementLine)entity;
                Optional<GenericPO> maybeRecordWeight = Optional.ofNullable(new GenericPO("DD_RecordWeight", entity.getCtx(), movementLine.get_ValueAsInt("DD_RecordWeight_ID"), entity.get_TrxName()));
                maybeRecordWeight.ifPresent(recordWeight -> {
                    BigDecimal receiptWeight = (BigDecimal)recordWeight.get_Value("ConditionedWeight");
                    String receiptReferenceWeight = "ConditionedWeight";
                    if (!Util.isEmpty((String)recordWeight.get_ValueAsString("ReceiptReferenceWeight"))) {
                        receiptReferenceWeight = recordWeight.get_ValueAsString("ReceiptReferenceWeight");
                    }
                    if (receiptReferenceWeight.equals("G")) {
                        receiptWeight = (BigDecimal)recordWeight.get_Value("NegotiatedConditionedWeight");
                    } else if (receiptReferenceWeight.equals("N")) {
                        receiptWeight = (BigDecimal)recordWeight.get_Value("NetWeight");
                    }
                    Optional.ofNullable(receiptWeight).ifPresent(weight -> movementLine.setMovementQty(weight));
                });
            } else if (entity.get_TableName().equals("RM_QualityAnalysis")) {
                MDDFreight freightOrder;
                if ((entity.is_new() || entity.is_ValueChanged("DD_Freight_ID") && entity.get_ValueAsInt("DD_Freight_ID") > 0) && (freightOrder = new MDDFreight(entity.getCtx(), entity.get_ValueAsInt("DD_Freight_ID"), entity.get_TrxName())).get_ValueAsBoolean("IsFarmerAssistanceProgram") && freightOrder.get_ValueAsInt("FAP_Farming_ID") > 0) {
                    MFAPFarming farming = MFAPFarming.getById(freightOrder.getCtx(), freightOrder.get_ValueAsInt("FAP_Farming_ID"), freightOrder.get_TrxName());
                    entity.set_ValueOfColumn("M_Product_ID", (Object)farming.getCategory_ID());
                    entity.set_ValueOfColumn("QualityAnalysis_ID", null);
                }
            } else if (entity.get_TableName().equals("C_Order")) {
                FarmingTechnicalAssistanceUtil.setDefaultFarmerOverdrafCreditLimitFromDocumentType(entity);
            } else if (entity.get_TableName().equals("C_Invoice")) {
                FarmingTechnicalAssistanceUtil.setDefaultFarmerOverdrafCreditLimitFromDocumentType(entity);
            } else if (entity.get_TableName().equals("C_Payment")) {
                FarmingTechnicalAssistanceUtil.setDefaultFarmerOverdrafCreditLimitFromDocumentType(entity);
            }
        } else if (type == 4 && entity.get_TableName().equals("FM_Agreement") && (agreement = (MFMAgreement)entity).get_ValueAsBoolean("IsFarmerAssistanceProgram") && !agreement.isProcessed()) {
            MFAPFarmingDefinition farmingDefinition = new MFAPFarmingDefinition(agreement.getCtx(), agreement.get_ValueAsInt("FAP_FarmingDefinition_ID"), agreement.get_TrxName());
            MFMAccount account = new MFMAccount(agreement);
            account.setC_Currency_ID(farmingDefinition.getC_Currency_ID());
            account.saveEx();
            MFMAccountProduct accountProduct = new MFMAccountProduct(account);
            accountProduct.setFM_Product_ID(farmingDefinition.getFM_Product_ID());
            accountProduct.setValidFrom(agreement.getDateDoc());
            accountProduct.saveEx();
        }
        return null;
    }

    public String docValidate(PO entity, int timing) {
        MFAPFarming farmingReferenced;
        MFMAccount account;
        MFMBatch batch;
        GenericPO recordWeight;
        MDDFreight freightOrder;
        MOrder order;
        if (timing == 1) {
            if (entity.get_TableName().equals("FM_Agreement")) {
                MFMAgreement agreement = (MFMAgreement)entity;
                if (agreement.get_ValueAsBoolean("IsFarmerAssistanceProgram")) {
                    if (MFAPFarmingAllocation.getFarmingListOfAgreement(agreement.getCtx(), agreement.getFM_Agreement_ID(), agreement.get_TrxName()).size() == 0) {
                        throw new AdempiereException("@NoLines@ (@FAP_FarmingAllocation_ID@ @NotFound@)");
                    }
                    BigDecimal farmingArea = Optional.ofNullable((BigDecimal)agreement.get_Value("FarmingArea")).orElse(Env.ZERO);
                    int farmingDefinitionId = agreement.get_ValueAsInt("FAP_FarmingDefinition_ID");
                    if (farmingDefinitionId <= 0) {
                        throw new AdempiereException("@FAP_FarmingDefinition_ID@ @IsMandatory@");
                    }
                    if (!Optional.ofNullable(farmingArea).isPresent()) {
                        throw new AdempiereException("@FarmingArea@ @IsMandatory@");
                    }
                    MFAPFarmingDefinition farmingDefinition = new MFAPFarmingDefinition(agreement.getCtx(), farmingDefinitionId, agreement.get_TrxName());
                    BigDecimal unitAmount = Optional.ofNullable(farmingDefinition.getApprovalAmt()).orElse(Env.ZERO);
                    BigDecimal farmingAmount = unitAmount.multiply(farmingArea);
                    agreement.set_ValueOfColumn("FarmingAmount", (Object)farmingAmount);
                    agreement.set_ValueOfColumn("FarmingApprovedAmount", (Object)farmingAmount);
                    agreement.set_ValueOfColumn("FarmingApprovedArea", (Object)farmingArea);
                    BigDecimal creditLimit = Optional.ofNullable((BigDecimal)agreement.get_Value("FarmerCreditLimit")).orElse(Env.ZERO);
                    BigDecimal creditAvailable = Optional.ofNullable((BigDecimal)agreement.get_Value("FarmerCreditAvailable")).orElse(Env.ZERO);
                    BigDecimal creditUsed = Optional.ofNullable((BigDecimal)agreement.get_Value("FarmerCreditUsed")).orElse(Env.ZERO);
                    if (creditLimit.compareTo(Env.ZERO) == 0) {
                        creditLimit = farmingAmount;
                    }
                    creditAvailable = creditLimit.subtract(creditUsed);
                    agreement.set_ValueOfColumn("FarmerCreditUsed", (Object)creditUsed);
                    agreement.set_ValueOfColumn("FarmerCreditLimit", (Object)creditLimit);
                    agreement.set_ValueOfColumn("FarmerCreditAvailable", (Object)creditAvailable);
                    agreement.saveEx();
                }
            } else if (entity.get_TableName().equals("C_Order")) {
                order = (MOrder)entity;
                FarmingTechnicalAssistanceUtil.setDefaultFinancialAccountFromAgreement((PO)order);
                order.saveEx();
            } else if (entity.get_TableName().equals("C_Invoice")) {
                MInvoice invoice = (MInvoice)entity;
                if (invoice.getC_Order_ID() > 0) {
                    FarmingTechnicalAssistanceUtil.setFinancialReferencesFromDocument((PO)invoice.getC_Order(), (PO)invoice);
                }
                FarmingTechnicalAssistanceUtil.setDefaultFinancialAccountFromAgreement((PO)invoice);
                invoice.saveEx();
            }
            if (entity.get_TableName().equals("DD_Freight")) {
                freightOrder = (MDDFreight)entity;
                FarmingTechnicalAssistanceUtil.setDefaultFinancialAccountFromAgreement((PO)freightOrder);
                freightOrder.saveEx();
            } else if (entity.get_TableName().equals("C_PaySelection")) {
                MPaySelection paymentSelection = (MPaySelection)entity;
                paymentSelection.getLines(true).forEach(paymentSelectionLine -> {
                    if (paymentSelectionLine.getC_Order_ID() > 0) {
                        FarmingTechnicalAssistanceUtil.setFinancialReferencesFromDocument((PO)paymentSelectionLine.getC_Order(), (PO)paymentSelectionLine);
                    } else if (paymentSelectionLine.getC_Invoice_ID() > 0) {
                        FarmingTechnicalAssistanceUtil.setFinancialReferencesFromDocument((PO)paymentSelectionLine.getC_Invoice(), (PO)paymentSelectionLine);
                    }
                    FarmingTechnicalAssistanceUtil.setDefaultFinancialAccountFromAgreement((PO)paymentSelectionLine);
                    paymentSelectionLine.saveEx();
                });
            } else if (entity.get_TableName().equals("C_Payment")) {
                MPayment payment = (MPayment)entity;
                if (payment.getC_Invoice_ID() > 0) {
                    FarmingTechnicalAssistanceUtil.setFinancialReferencesFromDocument((PO)payment.getC_Invoice(), (PO)payment);
                } else if (payment.getC_Order_ID() > 0) {
                    FarmingTechnicalAssistanceUtil.setFinancialReferencesFromDocument((PO)payment.getC_Order(), (PO)payment);
                }
                Optional.ofNullable(MPaySelectionCheck.getOfPayment((Properties)payment.getCtx(), (int)payment.getC_Payment_ID(), (String)payment.get_TrxName())).ifPresent(selectionCheck -> selectionCheck.getPaySelectionLinesAsList(false).stream().filter(paymentSelectionLine -> paymentSelectionLine.get_ValueAsInt("FM_Agreement_ID") > 0).findFirst().ifPresent(paymentSelectionLine -> FarmingTechnicalAssistanceUtil.setFinancialReferencesFromDocument((PO)paymentSelectionLine, (PO)payment)));
                FarmingTechnicalAssistanceUtil.setDefaultFinancialAccountFromAgreement(entity);
                entity.saveEx();
            } else if (entity.get_TableName().equals("FAP_RawMaterialConditioning")) {
                FarmingTechnicalAssistanceUtil.setDefaultFinancialAccountFromAgreement(entity);
                entity.saveEx();
            } else if (entity.get_TableName().equals("DD_RecordWeight")) {
                if (entity.get_ValueAsInt("DD_Freight_ID") > 0) {
                    freightOrder = new MDDFreight(entity.getCtx(), entity.get_ValueAsInt("DD_Freight_ID"), entity.get_TrxName());
                    FarmingTechnicalAssistanceUtil.setFinancialReferencesFromDocument((PO)freightOrder, entity);
                    FarmingTechnicalAssistanceUtil.getQualityAnalysisFromFreightOrder(entity.getCtx(), freightOrder.getDD_Freight_ID(), entity.get_TrxName()).forEach(qualityAnalysys -> {
                        qualityAnalysys.set_ValueOfColumn("DD_RecordWeight_ID", (Object)entity.get_ValueAsInt("DD_RecordWeight_ID"));
                        qualityAnalysys.saveEx();
                    });
                } else if (entity.get_ValueAsInt("C_Order_ID") > 0) {
                    order = new MOrder(entity.getCtx(), entity.get_ValueAsInt("C_Order_ID"), entity.get_TrxName());
                    FarmingTechnicalAssistanceUtil.setFinancialReferencesFromDocument((PO)order, entity);
                    FarmingTechnicalAssistanceUtil.getQualityAnalysisFromPurchaseOrder(entity.getCtx(), order.getC_Order_ID(), entity.get_TrxName()).forEach(qualityAnalysys -> {
                        if (qualityAnalysys.get_ValueAsInt("DD_RecordWeight_ID") == 0) {
                            qualityAnalysys.set_ValueOfColumn("DD_RecordWeight_ID", (Object)entity.get_ValueAsInt("DD_RecordWeight_ID"));
                            qualityAnalysys.saveEx();
                        }
                    });
                }
                FarmingTechnicalAssistanceUtil.setDefaultFinancialAccountFromAgreement(entity);
                entity.saveEx();
                FarmingTechnicalAssistanceUtil.createConditioningWeightCalculation(entity);
            } else if (entity.get_TableName().equals("RM_QualityAnalysis")) {
                if (entity.get_ValueAsInt("DD_RecordWeight_ID") > 0) {
                    recordWeight = new GenericPO("DD_RecordWeight", entity.getCtx(), entity.get_ValueAsInt("DD_RecordWeight_ID"), entity.get_TrxName());
                    FarmingTechnicalAssistanceUtil.setFinancialReferencesFromDocument((PO)recordWeight, entity);
                } else if (entity.get_ValueAsInt("DD_Freight_ID") > 0) {
                    freightOrder = new MDDFreight(entity.getCtx(), entity.get_ValueAsInt("DD_Freight_ID"), entity.get_TrxName());
                    FarmingTechnicalAssistanceUtil.setFinancialReferencesFromDocument((PO)freightOrder, entity);
                }
                FarmingTechnicalAssistanceUtil.setDefaultFinancialAccountFromAgreement(entity);
                entity.saveEx();
            }
        } else if (timing == 7) {
            if (entity.get_TableName().equals("FM_Batch")) {
                batch = (MFMBatch)entity;
                account = MFMAccount.getById((Properties)batch.getCtx(), (int)batch.getFM_Account_ID(), (String)batch.get_TrxName());
                AtomicReference<BigDecimal> totalAmount = new AtomicReference<BigDecimal>(Env.ZERO);
                batch.getLines(true).forEach(transaction -> totalAmount.updateAndGet(transactionAmount -> transactionAmount.add(Optional.ofNullable(transaction.getAmount()).orElse(Env.ZERO))));
                FarmingTechnicalAssistanceUtil.updateFinancialAgreementBalance(account.getFM_Agreement_ID(), totalAmount.get(), !batch.get_ValueAsBoolean("IsFarmerOverdraftCreditLimit"), batch.get_TrxName());
            }
        } else if (timing == 9) {
            if (entity.get_TableName().equals("DD_Freight")) {
                freightOrder = (MDDFreight)entity;
                if (freightOrder.get_ValueAsBoolean("IsFarmerAssistanceProgram") && freightOrder.get_ValueAsInt("FAP_Farming_ID") > 0) {
                    farmingReferenced = MFAPFarming.getById(freightOrder.getCtx(), freightOrder.get_ValueAsInt("FAP_Farming_ID"), freightOrder.get_TrxName());
                    farmingReferenced.updateFreightQuantity();
                    AtomicReference<BigDecimal> freightAmount = new AtomicReference<BigDecimal>(Env.ZERO);
                    freightOrder.getLines().forEach(freightLine -> freightAmount.updateAndGet(freightWeight -> freightWeight.add(Optional.ofNullable(freightLine.getWeight()).orElse(Env.ZERO))));
                    farmingReferenced.setFarmingTransportedQuantity(farmingReferenced.getFarmingTransportedQuantity().add(freightAmount.get()));
                    farmingReferenced.saveEx(freightOrder.get_TrxName());
                }
            } else if (entity.get_TableName().equals("C_Order")) {
                order = (MOrder)entity;
                if (!order.isSOTrx() && order.get_ValueAsBoolean("IsFarmerAssistanceProgram") && order.get_ValueAsInt("FM_Agreement_ID") > 0) {
                    Arrays.asList(order.getLines()).stream().filter(orderLine -> orderLine.get_ValueAsInt("FAP_Farming_ID") > 0).forEach(orderLine -> {
                        MFAPFarming farmingReferenced = MFAPFarming.getById(order.getCtx(), orderLine.get_ValueAsInt("FAP_Farming_ID"), order.get_TrxName());
                        farmingReferenced.updateQuantityOrdered();
                        farmingReferenced.setQtyOrdered(Optional.ofNullable(farmingReferenced.getQtyOrdered()).orElse(Env.ZERO).add(Optional.ofNullable(orderLine.getQtyOrdered()).orElse(Env.ZERO)));
                        farmingReferenced.saveEx(order.get_TrxName());
                    });
                }
            } else if (entity.get_TableName().equals("RM_QualityAnalysis") && entity.get_ValueAsInt("DD_RecordWeight_ID") > 0) {
                recordWeight = new GenericPO("DD_RecordWeight", entity.getCtx(), entity.get_ValueAsInt("DD_RecordWeight_ID"), entity.get_TrxName());
                FarmingTechnicalAssistanceUtil.createConditioningWeightCalculation((PO)recordWeight);
            }
        } else if (timing == 10 || timing == 14 || timing == 13) {
            if (entity.get_TableName().equals("DD_Freight")) {
                freightOrder = (MDDFreight)entity;
                if (freightOrder.get_ValueAsBoolean("IsFarmerAssistanceProgram") && freightOrder.get_ValueAsInt("FAP_Farming_ID") > 0) {
                    farmingReferenced = MFAPFarming.getById(freightOrder.getCtx(), freightOrder.get_ValueAsInt("FAP_Farming_ID"), freightOrder.get_TrxName());
                    farmingReferenced.updateFreightQuantity();
                    AtomicReference<BigDecimal> freightAmount = new AtomicReference<BigDecimal>(Env.ZERO);
                    freightOrder.getLines().forEach(freightLine -> freightAmount.updateAndGet(freightWeight -> freightWeight.add(Optional.ofNullable(freightLine.getWeight()).orElse(Env.ZERO))));
                    farmingReferenced.setFarmingTransportedQuantity(farmingReferenced.getFarmingTransportedQuantity().subtract(freightAmount.get()));
                    farmingReferenced.saveEx(freightOrder.get_TrxName());
                }
            } else if (entity.get_TableName().equals("RM_QualityAnalysis") || entity.get_TableName().equals("DD_RecordWeight")) {
                FarmingTechnicalAssistanceUtil.reverseConditioningReferencesOfRecordWeight(entity);
                if (entity.get_TableName().equals("DD_RecordWeight")) {
                    FarmingTechnicalAssistanceUtil.unlinkQualityAnalysisReferencesOfRecordWeight(entity);
                }
            } else if (entity.get_TableName().equals("FM_Batch")) {
                batch = (MFMBatch)entity;
                account = MFMAccount.getById((Properties)batch.getCtx(), (int)batch.getFM_Account_ID(), (String)batch.get_TrxName());
                AtomicReference<BigDecimal> totalAmount = new AtomicReference<BigDecimal>(Env.ZERO);
                batch.getLines(true).forEach(transaction -> totalAmount.updateAndGet(transactionAmount -> transactionAmount.add(Optional.ofNullable(transaction.getAmount()).orElse(Env.ZERO))));
                FarmingTechnicalAssistanceUtil.updateFinancialAgreementBalance(account.getFM_Agreement_ID(), totalAmount.get().negate(), !batch.get_ValueAsBoolean("IsFarmerOverdraftCreditLimit"), batch.get_TrxName());
            }
        } else if (timing == 2) {
            if (entity.get_TableName().equals("C_Order") && !(order = (MOrder)entity).isSOTrx() && order.get_ValueAsBoolean("IsFarmerAssistanceProgram") && order.get_ValueAsInt("FM_Agreement_ID") > 0) {
                Arrays.asList(order.getLines()).stream().filter(orderLine -> orderLine.get_ValueAsInt("FAP_Farming_ID") > 0).forEach(orderLine -> {
                    MFAPFarming farmingReferenced = MFAPFarming.getById(order.getCtx(), orderLine.get_ValueAsInt("FAP_Farming_ID"), order.get_TrxName());
                    farmingReferenced.updateQuantityOrdered();
                    farmingReferenced.setQtyOrdered(Optional.ofNullable(farmingReferenced.getQtyOrdered()).orElse(Env.ZERO).subtract(Optional.ofNullable(orderLine.getQtyOrdered()).orElse(Env.ZERO)));
                    farmingReferenced.saveEx(order.get_TrxName());
                });
            }
        } else if (timing == 12) {
            if (entity.get_TableName().equals("RM_QualityAnalysis") || entity.get_TableName().equals("DD_RecordWeight")) {
                FarmingTechnicalAssistanceUtil.reverseConditioningReferencesOfRecordWeight(entity);
            }
            if (entity.get_TableName().equals("DD_RecordWeight")) {
                FarmingTechnicalAssistanceUtil.unlinkQualityAnalysisReferencesOfRecordWeight(entity);
            }
        }
        int financialAgreementId = entity.get_ValueAsInt("FM_Agreement_ID");
        if (financialAgreementId <= 0) {
            return null;
        }
        MFMAgreement agreement = MFMAgreement.getById((Properties)entity.getCtx(), (int)financialAgreementId, (String)entity.get_TrxName());
        StringBuffer processMessage = new StringBuffer();
        agreement.getAccountProducts().forEach(accountProduct -> {
            log.fine("Running for Account Product: " + accountProduct.getFM_Product_ID());
            String processMsg = FinancialSetting.get().fireDocValidate(entity, timing, accountProduct.getFM_Product_ID());
            if (!Util.isEmpty((String)processMsg)) {
                if (processMessage.length() > 0) {
                    processMessage.append(Env.NL);
                }
                processMessage.append(processMsg);
            }
        });
        if (processMessage.length() > 0) {
            return processMessage.toString();
        }
        return null;
    }
}

