/*
 * Decompiled with CFR 0.152.
 */
package org.farming.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.farming.model.X_FAP_WeightCalculationType;

public class MFAPWeightCalculationType
extends X_FAP_WeightCalculationType {
    private static final long serialVersionUID = -5831361443495335312L;
    private static CCache<Integer, MFAPWeightCalculationType> calculationTypeCacheIds = new CCache("FAP_WeightCalculationType", 30);
    private static CCache<String, MFAPWeightCalculationType> calculationTypeCacheValues = new CCache("FAP_WeightCalculationType", 30);

    public MFAPWeightCalculationType(Properties ctx, int calculationTypeId, String trxName) {
        super(ctx, calculationTypeId, trxName);
    }

    public MFAPWeightCalculationType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MFAPWeightCalculationType getById(Properties ctx, int weightCalculationTypeId, String trxName) {
        if (weightCalculationTypeId <= 0) {
            return null;
        }
        MFAPWeightCalculationType calculationType = (MFAPWeightCalculationType)calculationTypeCacheIds.get((Object)weightCalculationTypeId);
        if (calculationType != null && calculationType.get_ID() > 0) {
            return calculationType;
        }
        calculationType = (MFAPWeightCalculationType)new Query(ctx, "FAP_WeightCalculationType", "FAP_WeightCalculationType_ID=?", trxName).setClient_ID().setParameters(new Object[]{weightCalculationTypeId}).first();
        if (calculationType != null && calculationType.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + calculationType.getValue();
            calculationTypeCacheValues.put((Object)key, (Object)calculationType);
            calculationTypeCacheIds.put((Object)calculationType.get_ID(), (Object)calculationType);
        }
        return calculationType;
    }

    public static MFAPWeightCalculationType getByValue(Properties ctx, String weightCalculationTypeValue, String trxName) {
        int clientId;
        String key;
        MFAPWeightCalculationType type;
        if (weightCalculationTypeValue == null) {
            return null;
        }
        if (calculationTypeCacheValues.size() == 0) {
            MFAPWeightCalculationType.getAll(ctx, true, trxName);
        }
        if ((type = (MFAPWeightCalculationType)calculationTypeCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + weightCalculationTypeValue))) != null && type.get_ID() > 0) {
            return type;
        }
        type = (MFAPWeightCalculationType)new Query(ctx, "FAP_WeightCalculationType", "Value=?", trxName).setClient_ID().setParameters(new Object[]{weightCalculationTypeValue}).first();
        if (type != null && type.get_ID() > 0) {
            calculationTypeCacheValues.put((Object)key, (Object)type);
            calculationTypeCacheIds.put((Object)type.get_ID(), (Object)type);
        }
        return type;
    }

    public static List<MFAPWeightCalculationType> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || calculationTypeCacheIds.size() > 0) {
            List typeList = new Query(Env.getCtx(), "FAP_WeightCalculationType", null, trxName).setClient_ID().setOrderBy("Name").list();
            typeList.stream().forEach(setting -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + setting.getValue();
                calculationTypeCacheIds.put((Object)setting.getFAP_WeightCalculationType_ID(), setting);
                calculationTypeCacheValues.put((Object)key, setting);
            });
            return typeList;
        }
        List<MFAPWeightCalculationType> typeList = calculationTypeCacheIds.entrySet().stream().map(type -> (MFAPWeightCalculationType)type.getValue()).collect(Collectors.toList());
        return typeList;
    }
}

