/*
 * Decompiled with CFR 0.152.
 */
package org.farming.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.farming.model.MFAPRawMaterialConditioning;
import org.farming.model.X_FAP_WeightCalculation;
import org.spin.rw.model.MDDRecordWeight;

public class MFAPWeightCalculation
extends X_FAP_WeightCalculation {
    private static final long serialVersionUID = -5831361443495335312L;
    private static CCache<Integer, MFAPWeightCalculation> weightCalculationCacheIds = new CCache("FAP_WeightCalculation", 30);
    private static CCache<String, MFAPWeightCalculation> weightCalculationCacheValues = new CCache("FAP_WeightCalculation", 30);

    public MFAPWeightCalculation(Properties ctx, int weightCalculationId, String trxName) {
        super(ctx, weightCalculationId, trxName);
    }

    public MFAPWeightCalculation(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MFAPWeightCalculation getById(Properties ctx, int weightCalculationId, String trxName) {
        if (weightCalculationId <= 0) {
            return null;
        }
        MFAPWeightCalculation weightCalculation = (MFAPWeightCalculation)weightCalculationCacheIds.get((Object)weightCalculationId);
        if (weightCalculation != null && weightCalculation.get_ID() > 0) {
            return weightCalculation;
        }
        weightCalculation = (MFAPWeightCalculation)new Query(ctx, "FAP_WeightCalculation", "FAP_WeightCalculation_ID=?", trxName).setClient_ID().setParameters(new Object[]{weightCalculationId}).first();
        if (weightCalculation != null && weightCalculation.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID((Properties)ctx);
            String key = clientId + "#" + weightCalculation.getValue();
            weightCalculationCacheValues.put((Object)key, (Object)weightCalculation);
            weightCalculationCacheIds.put((Object)weightCalculation.get_ID(), (Object)weightCalculation);
        }
        return weightCalculation;
    }

    public static MFAPWeightCalculation getByValue(Properties ctx, String typeValue, String trxName) {
        int clientId;
        String key;
        MFAPWeightCalculation type;
        if (typeValue == null) {
            return null;
        }
        if (weightCalculationCacheValues.size() == 0) {
            MFAPWeightCalculation.getAll(ctx, true, trxName);
        }
        if ((type = (MFAPWeightCalculation)weightCalculationCacheValues.get((Object)(key = (clientId = Env.getAD_Client_ID((Properties)ctx)) + "#" + typeValue))) != null && type.get_ID() > 0) {
            return type;
        }
        type = (MFAPWeightCalculation)new Query(ctx, "FAP_WeightCalculation", "Value=?", trxName).setClient_ID().setParameters(new Object[]{typeValue}).first();
        if (type != null && type.get_ID() > 0) {
            weightCalculationCacheValues.put((Object)key, (Object)type);
            weightCalculationCacheIds.put((Object)type.get_ID(), (Object)type);
        }
        return type;
    }

    public static MFAPWeightCalculation getOfProductAndUsingType(MFAPRawMaterialConditioning conditioning) {
        MDDRecordWeight recordWeight;
        String usingType = conditioning.getUsingType();
        if (Util.isEmpty((String)usingType)) {
            usingType = "RW";
        }
        String ORDERVALUE = " DESC NULLS LAST";
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuffer orderByClause = new StringBuffer("UsingType").append(ORDERVALUE);
        StringBuffer whereClause = new StringBuffer("UsingType = ?");
        parameters.add(usingType);
        MProduct product = MProduct.get((Properties)conditioning.getCtx(), (int)conditioning.getM_Product_ID());
        whereClause.append(" AND (M_Product_ID = ? OR M_Product_ID IS NULL)");
        orderByClause.append(", M_Product_ID").append(ORDERVALUE);
        parameters.add(product.getM_Product_ID());
        if (product.getM_Product_Category_ID() > 0) {
            whereClause.append(" AND (M_Product_Category_ID = ? OR M_Product_Category_ID IS NULL)");
            parameters.add(product.getM_Product_Category_ID());
            orderByClause.append(", M_Product_Category_ID").append(ORDERVALUE);
        }
        if (product.getM_Product_Class_ID() > 0) {
            whereClause.append(" AND (M_Product_Class_ID = ? OR M_Product_Class_ID IS NULL)");
            parameters.add(product.getM_Product_Class_ID());
            orderByClause.append(", M_Product_Class_ID").append(ORDERVALUE);
        }
        if (product.getM_Product_Classification_ID() > 0) {
            whereClause.append(" AND (M_Product_Classification_ID = ? OR M_Product_Classification_ID IS NULL)");
            parameters.add(product.getM_Product_Classification_ID());
            orderByClause.append(", M_Product_Classification_ID").append(ORDERVALUE);
        }
        if (product.getM_Product_Group_ID() > 0) {
            whereClause.append(" AND (M_Product_Group_ID = ? OR M_Product_Group_ID IS NULL)");
            parameters.add(product.getM_Product_Group_ID());
            orderByClause.append(", M_Product_Group_ID").append(ORDERVALUE);
        }
        if (conditioning.getC_BPartner_ID() > 0) {
            whereClause.append(" AND (C_BPartner_ID = ? OR C_BPartner_ID IS NULL)");
            parameters.add(conditioning.getC_BPartner_ID());
            orderByClause.append(", C_BPartner_ID").append(ORDERVALUE);
        }
        if (conditioning.getDD_RecordWeight_ID() > 0 && (recordWeight = new MDDRecordWeight(conditioning.getCtx(), conditioning.getDD_RecordWeight_ID(), conditioning.get_TrxName())).getM_Warehouse_ID() > 0) {
            whereClause.append(" AND (M_Warehouse_ID = ? OR M_Warehouse_ID IS NULL)");
            parameters.add(recordWeight.getM_Warehouse_ID());
            orderByClause.append(", M_Warehouse_ID").append(ORDERVALUE);
        }
        return (MFAPWeightCalculation)new Query(Env.getCtx(), "FAP_WeightCalculation", whereClause.toString(), null).setParameters(parameters).setClient_ID().setOnlyActiveRecords(true).setOrderBy(orderByClause.toString()).first();
    }

    public static MFAPWeightCalculation getOfProductAndUsingType(Properties ctx, int productId, String usingType, String transactionName) {
        if (Util.isEmpty((String)usingType)) {
            usingType = "RW";
        }
        String ORDERVALUE = " DESC NULLS LAST";
        ArrayList<Object> parameters = new ArrayList<Object>();
        StringBuffer orderByClause = new StringBuffer("UsingType").append(ORDERVALUE);
        StringBuffer whereClause = new StringBuffer("UsingType = ?");
        parameters.add(usingType);
        MProduct product = MProduct.get((Properties)ctx, (int)productId);
        whereClause.append(" AND (M_Product_ID = ? OR M_Product_ID IS NULL)");
        orderByClause.append(", M_Product_ID").append(ORDERVALUE);
        parameters.add(product.getM_Product_ID());
        if (product.getM_Product_Category_ID() > 0) {
            whereClause.append(" AND (M_Product_Category_ID = ? OR M_Product_Category_ID IS NULL)");
            parameters.add(product.getM_Product_Category_ID());
            orderByClause.append(", M_Product_Category_ID").append(ORDERVALUE);
        }
        if (product.getM_Product_Class_ID() > 0) {
            whereClause.append(" AND (M_Product_Class_ID = ? OR M_Product_Class_ID IS NULL)");
            parameters.add(product.getM_Product_Class_ID());
            orderByClause.append(", M_Product_Class_ID").append(ORDERVALUE);
        }
        if (product.getM_Product_Classification_ID() > 0) {
            whereClause.append(" AND (M_Product_Classification_ID = ? OR M_Product_Classification_ID IS NULL)");
            parameters.add(product.getM_Product_Classification_ID());
            orderByClause.append(", M_Product_Classification_ID").append(ORDERVALUE);
        }
        if (product.getM_Product_Group_ID() > 0) {
            whereClause.append(" AND (M_Product_Group_ID = ? OR M_Product_Group_ID IS NULL)");
            parameters.add(product.getM_Product_Group_ID());
            orderByClause.append(", M_Product_Group_ID").append(ORDERVALUE);
        }
        return (MFAPWeightCalculation)new Query(Env.getCtx(), "FAP_WeightCalculation", whereClause.toString(), transactionName).setParameters(parameters).setClient_ID().setOnlyActiveRecords(true).setOrderBy(orderByClause.toString()).first();
    }

    public static List<MFAPWeightCalculation> getOfProduct(Properties ctx, int productId, String trxName) {
        return new Query(Env.getCtx(), "FAP_WeightCalculation", "M_Product_ID = ?", trxName).setParameters(new Object[]{productId}).setClient_ID().setOrderBy("SeqNo").list();
    }

    public static List<MFAPWeightCalculation> getOfProductCategory(Properties ctx, int productCategoryId, String trxName) {
        return new Query(Env.getCtx(), "FAP_WeightCalculation", "M_Product_Category_ID = ?", trxName).setParameters(new Object[]{productCategoryId}).setClient_ID().setOrderBy("SeqNo").list();
    }

    public static List<MFAPWeightCalculation> getOfProductClass(Properties ctx, int productClassId, String trxName) {
        return new Query(Env.getCtx(), "FAP_WeightCalculation", "M_Product_Class_ID = ?", trxName).setParameters(new Object[]{productClassId}).setClient_ID().setOrderBy("SeqNo").list();
    }

    public static List<MFAPWeightCalculation> getOfProductClassification(Properties ctx, int productClassificationId, String trxName) {
        return new Query(Env.getCtx(), "FAP_WeightCalculation", "M_Product_Classification_ID = ?", trxName).setParameters(new Object[]{productClassificationId}).setClient_ID().setOrderBy("SeqNo").list();
    }

    public static List<MFAPWeightCalculation> getOfProductGroup(Properties ctx, int productGroupId, String trxName) {
        return new Query(Env.getCtx(), "FAP_WeightCalculation", "M_Product_Group_ID = ?", trxName).setParameters(new Object[]{productGroupId}).setClient_ID().setOrderBy("SeqNo").list();
    }

    public static List<MFAPWeightCalculation> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || weightCalculationCacheIds.size() > 0) {
            List typeList = new Query(Env.getCtx(), "FAP_WeightCalculation", null, trxName).setClient_ID().setOrderBy("SeqNo").list();
            typeList.stream().forEach(setting -> {
                int clientId = Env.getAD_Client_ID((Properties)ctx);
                String key = clientId + "#" + setting.getValue();
                weightCalculationCacheIds.put((Object)setting.getFAP_WeightCalculation_ID(), setting);
                weightCalculationCacheValues.put((Object)key, setting);
            });
            return typeList;
        }
        List<MFAPWeightCalculation> typeList = weightCalculationCacheIds.entrySet().stream().map(type -> (MFAPWeightCalculation)type.getValue()).collect(Collectors.toList());
        return typeList;
    }

    @Override
    public String toString() {
        return "MFAPWeightCalculation [getClassname()=" + this.getClassname() + ", getFAP_WeightCalculationType_ID()=" + this.getFAP_WeightCalculationType_ID() + ", getName()=" + this.getName() + ", getSeqNo()=" + this.getSeqNo() + ", getUsingType()=" + this.getUsingType() + ", getUUID()=" + this.getUUID() + ", getValue()=" + this.getValue() + "]";
    }
}

