/*
 * Decompiled with CFR 0.152.
 */
package org.farming.model;

import java.sql.ResultSet;
import java.util.Optional;
import java.util.Properties;
import org.compiere.model.Query;
import org.farming.model.MFAPFarming;
import org.farming.model.MFAPFarmingAllocation;
import org.farming.model.X_FAP_TechnicalFormLine;
import org.spin.model.MFMAgreement;

public class MFAPTechnicalFormLine
extends X_FAP_TechnicalFormLine {
    private static final long serialVersionUID = 9174653595964192770L;

    public MFAPTechnicalFormLine(Properties ctx, int FAP_TechnicalFormLine_ID, String trxName) {
        super(ctx, FAP_TechnicalFormLine_ID, trxName);
    }

    public MFAPTechnicalFormLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MFAPTechnicalFormLine get(Properties ctx, int technicalFormLineId, String transactionName) {
        String whereClause = "FAP_TechnicalFormLine_ID=?";
        MFAPTechnicalFormLine retValue = (MFAPTechnicalFormLine)new Query(ctx, "FAP_TechnicalFormLine", "FAP_TechnicalFormLine_ID=?", transactionName).setParameters(new Object[]{technicalFormLineId}).setOnlyActiveRecords(true).first();
        return retValue;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (newRecord || this.is_ValueChanged("FAP_Farming_ID") && this.getFAP_Farming_ID() > 0) {
            MFAPFarming farming = MFAPFarming.getById(this.getCtx(), this.getFAP_Farming_ID(), this.get_TrxName());
            if (!Optional.of(this.getEffectiveArea()).isPresent()) {
                this.setEffectiveArea(farming.getEffectiveArea());
            }
            if (!Optional.ofNullable(this.getStatus()).isPresent()) {
                this.setStatus(farming.getStatus());
            }
            if (!Optional.ofNullable(this.getPlantingStartDate()).isPresent()) {
                this.setPlantingStartDate(farming.getPlantingStartDate());
            }
            if (!Optional.ofNullable(this.getPlantingEndDate()).isPresent()) {
                this.setPlantingEndDate(farming.getPlantingEndDate());
            }
            if (!Optional.ofNullable(this.getHarvestStartDate()).isPresent()) {
                this.setHarvestStartDate(farming.getHarvestStartDate());
            }
            if (!Optional.ofNullable(this.getHarvestEndDate()).isPresent()) {
                this.setHarvestEndDate(farming.getHarvestEndDate());
            }
            if (!Optional.ofNullable(this.getEstimatedYield()).isPresent()) {
                this.setEstimatedYield(farming.getEstimatedYield());
            }
            if (!Optional.ofNullable(this.getEstimatedQty()).isPresent()) {
                this.setEstimatedQty(farming.getEstimatedQty());
            }
            Optional<MFMAgreement> maybeAgreement = MFAPFarmingAllocation.getAgreementListOfFarming(this.getCtx(), farming.getFAP_Farming_ID(), this.get_TrxName()).stream().filter(agreement -> agreement.getDocStatus().equals("CO")).findFirst();
            maybeAgreement.ifPresent(agreement -> this.setFM_Agreement_ID(agreement.getFM_Agreement_ID()));
        }
        return super.beforeSave(newRecord);
    }
}

