/*
 * Decompiled with CFR 0.152.
 */
package org.farming.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.farming.model.MFAPFarm;
import org.farming.model.MFAPFarming;
import org.farming.model.MFAPProductsToApply;
import org.farming.model.MFAPSuggestedProduct;
import org.farming.model.MFAPTechnicalFormLine;
import org.farming.model.X_FAP_TechnicalForm;

public class MFAPTechnicalForm
extends X_FAP_TechnicalForm
implements DocAction,
DocOptions {
    private static final long serialVersionUID = 3057927736413234013L;
    private List<MFAPTechnicalFormLine> lines = null;
    private List<MFAPProductsToApply> productsToApply = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MFAPTechnicalForm(Properties ctx, int FAP_TechnicalForm_ID, String trxName) {
        super(ctx, FAP_TechnicalForm_ID, trxName);
    }

    public MFAPTechnicalForm(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)0);
        return dt.getName() + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    private void createSuggestedProducts() {
        this.getProductToApply(true).stream().filter(productToApply -> !productToApply.isProcessed() && !productToApply.isManual()).forEach(productToApply -> productToApply.deleteEx(true));
        this.getLines(false).forEach(technicalFormLine -> {
            MFAPFarming farming = MFAPFarming.getById(this.getCtx(), technicalFormLine.getFAP_Farming_ID(), this.get_TrxName());
            List<MFAPSuggestedProduct> suggestedProduct = MFAPSuggestedProduct.getMatchingList(this.getCtx(), farming.getFAP_Farming_ID(), technicalFormLine.getFAP_ObservationType_ID(), technicalFormLine.getFAP_FarmingStage_ID(), this.get_TrxName());
            if (suggestedProduct != null && !suggestedProduct.isEmpty()) {
                suggestedProduct.stream().filter(suggested -> suggested.getM_Product_ID() > 0).forEach(suggested -> {
                    MFAPProductsToApply productToApply = new MFAPProductsToApply((MFAPTechnicalFormLine)technicalFormLine);
                    productToApply.setM_Product_ID(suggested.getM_Product_ID());
                    productToApply.setQtySuggested(Optional.ofNullable(productToApply.getQtyDosage()).orElse(Env.ZERO));
                    productToApply.setQtyDosage(Optional.ofNullable(productToApply.getQtyDosage()).orElse(Env.ZERO).multiply(Optional.ofNullable(farming.getArea()).orElse(Env.ZERO)));
                    productToApply.setQty(Optional.ofNullable(productToApply.getQtyDosage()).orElse(Env.ZERO));
                    if (productToApply.getC_UOM_ID() > 0) {
                        productToApply.setC_UOM_ID(productToApply.getC_UOM_ID());
                    } else {
                        MProduct product = MProduct.get((Properties)this.getCtx(), (int)suggested.getM_Product_ID());
                        productToApply.setC_UOM_ID(product.getC_UOM_ID());
                    }
                    productToApply.saveEx(this.get_TrxName());
                });
            }
        });
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        return true;
    }

    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getDateDoc(), (String)dt.getDocBaseType(), (int)this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        this.createSuggestedProducts();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (this.getFAP_Farm_ID() > 0) {
            MFAPFarm farm = MFAPFarm.getById(this.getCtx(), this.getFAP_Farm_ID(), this.get_TrxName());
            if (farm.getC_BPartner_ID() != this.getC_BPartner_ID()) {
                this.m_processMsg = "@FAP_Farm_ID@ @C_BPartner_ID@ @Mismatched@";
            }
            if (this.m_processMsg != null) {
                return "IN";
            }
        }
        if (this.getLines(false).isEmpty()) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        this.updateFarmingStatus();
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void updateFarmingStatus() {
        this.getLines(false).forEach(technicalFormLine -> {
            MFAPFarming farming = MFAPFarming.getById(this.getCtx(), technicalFormLine.getFAP_Farming_ID(), this.get_TrxName());
            Optional.ofNullable(technicalFormLine.getEffectiveArea()).ifPresent(effectiveArea -> farming.setEffectiveArea(technicalFormLine.getEffectiveArea()));
            Optional.ofNullable(technicalFormLine.getStatus()).ifPresent(status -> farming.setStatus((String)status));
            Optional.ofNullable(technicalFormLine.getPlantingStartDate()).ifPresent(plantingStartDate -> farming.setPlantingStartDate((Timestamp)plantingStartDate));
            Optional.ofNullable(technicalFormLine.getPlantingEndDate()).ifPresent(plantingEndDate -> farming.setPlantingEndDate((Timestamp)plantingEndDate));
            Optional.ofNullable(technicalFormLine.getHarvestStartDate()).ifPresent(harvestStartDate -> farming.setHarvestStartDate((Timestamp)harvestStartDate));
            Optional.ofNullable(technicalFormLine.getHarvestEndDate()).ifPresent(harvestEndDate -> farming.setHarvestEndDate((Timestamp)harvestEndDate));
            Optional.ofNullable(technicalFormLine.getEstimatedYield()).ifPresent(estimatedYield -> farming.setEstimatedYield((BigDecimal)estimatedYield));
            Optional.ofNullable(technicalFormLine.getEstimatedQty()).ifPresent(estimatedQty -> farming.setEstimatedQty((BigDecimal)estimatedQty));
            farming.saveEx(this.get_TrxName());
        });
    }

    public static MFAPTechnicalForm getById(Properties context, int technicalFormId, String transactionName) {
        return (MFAPTechnicalForm)new Query(context, "FAP_TechnicalForm", "FAP_TechnicalForm_ID = ?", transactionName).setParameters(new Object[]{technicalFormId}).first();
    }

    private void setDefiniteDocumentNo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete()) {
            String value = null;
            int index = this.p_info.getColumnIndex("C_DocType_ID");
            if (index == -1) {
                index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (index != -1) {
                value = DB.getDocumentNo((int)this.get_ValueAsInt(index), (String)this.get_TrxName(), (boolean)true);
            }
            if (value != null) {
                this.setDocumentNo(value);
            }
        }
    }

    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = this.validReference();
        if (this.m_processMsg != null) {
            return false;
        }
        this.addDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Voided"));
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
        return this.m_processMsg == null;
    }

    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    private String validReference() {
        String m_ReferenceNo = DB.getSQLValueString((String)this.get_TrxName(), (String)"SELECT MAX(o.DocumentNo) FROM C_Order o WHERE o.DocStatus NOT IN('VO', 'RE') AND o.FAP_TechnicalForm_ID = ?", (int)this.getFAP_TechnicalForm_ID());
        if (m_ReferenceNo != null) {
            return "@SQLErrorReferenced@ @C_Order_ID@: " + m_ReferenceNo;
        }
        return null;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(" (#").append(this.getLines(false).size()).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return 0;
    }

    public BigDecimal getApprovalAmt() {
        return null;
    }

    public int getC_Currency_ID() {
        return 0;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    public List<MFAPTechnicalFormLine> getLines(boolean requery) {
        if (this.lines != null && this.lines.size() > 0 && !requery) {
            return this.lines;
        }
        this.lines = new Query(this.getCtx(), "FAP_TechnicalFormLine", "FAP_TechnicalForm_ID=?", this.get_TrxName()).setParameters(new Object[]{this.getFAP_TechnicalForm_ID()}).list();
        return this.lines;
    }

    public List<MFAPProductsToApply> getProductToApply(boolean requery) {
        if (this.productsToApply != null && this.productsToApply.size() > 0 && !requery) {
            return this.productsToApply;
        }
        this.productsToApply = new Query(this.getCtx(), "FAP_ProductsToApply", "FAP_TechnicalForm_ID=?", this.get_TrxName()).setParameters(new Object[]{this.getFAP_TechnicalForm_ID()}).setOrderBy("FAP_TechnicalFormLine_ID").list();
        return this.productsToApply;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() <= 0) {
            return;
        }
        AtomicInteger updatedLines = new AtomicInteger();
        AtomicInteger updatedpProductToApply = new AtomicInteger();
        this.getLines(true).forEach(technicalFormLine -> {
            technicalFormLine.setProcessed(processed);
            technicalFormLine.saveEx(this.get_TrxName());
            updatedLines.incrementAndGet();
        });
        this.getProductToApply(true).forEach(productToApply -> {
            productToApply.setProcessed(processed);
            productToApply.saveEx(this.get_TrxName());
            updatedpProductToApply.incrementAndGet();
        });
        this.log.fine("setProcessed - " + processed + " - Lines=" + updatedLines);
        this.log.fine("setProcessed - " + processed + " - ProductsToApply=" + updatedpProductToApply);
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (AD_Table_ID == Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
            }
        }
        return index;
    }

    @Override
    public String toString() {
        return "MFAPTechnicalForm [getDateDoc()=" + this.getDateDoc() + ", getDocumentNo()=" + this.getDocumentNo() + ", getFAP_TechnicalForm_ID()=" + this.getFAP_TechnicalForm_ID() + "]";
    }
}

