/*
 * Decompiled with CFR 0.152.
 */
package org.farming.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.farming.model.MFAPFarmingStage;
import org.farming.model.X_FAP_SuggestedProduct;

public class MFAPSuggestedProduct
extends X_FAP_SuggestedProduct {
    private static final long serialVersionUID = -5831361443495335312L;
    private static CCache<Integer, MFAPSuggestedProduct> suggestedProductsCacheIds = new CCache("FAP_SuggestedProduct", 30);
    private static CCache<String, List<MFAPSuggestedProduct>> matchingCache = new CCache("FAP_SuggestedProduct", 30);

    public MFAPSuggestedProduct(Properties ctx, int FAP_PlantingCycle_ID, String trxName) {
        super(ctx, FAP_PlantingCycle_ID, trxName);
    }

    public MFAPSuggestedProduct(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MFAPSuggestedProduct getById(Properties ctx, int suggestedProductsId, String trxName) {
        if (suggestedProductsId <= 0) {
            return null;
        }
        MFAPSuggestedProduct suggestedProducts = (MFAPSuggestedProduct)suggestedProductsCacheIds.get((Object)suggestedProductsId);
        if (suggestedProducts != null && suggestedProducts.get_ID() > 0) {
            return suggestedProducts;
        }
        suggestedProducts = (MFAPSuggestedProduct)new Query(ctx, "FAP_SuggestedProduct", "FAP_SuggestedProduct_ID=?", trxName).setClient_ID().setParameters(new Object[]{suggestedProductsId}).first();
        if (suggestedProducts != null && suggestedProducts.get_ID() > 0) {
            suggestedProductsCacheIds.put((Object)suggestedProducts.get_ID(), (Object)suggestedProducts);
        }
        return suggestedProducts;
    }

    public static List<MFAPSuggestedProduct> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || suggestedProductsCacheIds.size() > 0) {
            List typeList = new Query(Env.getCtx(), "FAP_SuggestedProduct", null, trxName).setClient_ID().setOrderBy("Name").list();
            typeList.stream().forEach(setting -> suggestedProductsCacheIds.put((Object)setting.getFAP_SuggestedProduct_ID(), setting));
            return typeList;
        }
        List<MFAPSuggestedProduct> typeList = suggestedProductsCacheIds.entrySet().stream().map(type -> (MFAPSuggestedProduct)type.getValue()).collect(Collectors.toList());
        return typeList;
    }

    public static List<MFAPSuggestedProduct> getMatchingList(Properties ctx, int categoryId, int observationTypeId, int farmingStageId, String transactionName) {
        String key = categoryId + "|" + observationTypeId + "|" + farmingStageId;
        List suggestedProducts = (List)matchingCache.get((Object)key);
        if (suggestedProducts != null && suggestedProducts.size() > 0) {
            return suggestedProducts;
        }
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        StringBuffer whereClause = new StringBuffer();
        if (categoryId > 0) {
            parameters.add(categoryId);
            whereClause.append("(").append("Category_ID").append(" = ?").append(" OR ").append("Category_ID").append(" IS NULL)");
        }
        if (observationTypeId > 0) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            parameters.add(observationTypeId);
            whereClause.append("(").append("FAP_ObservationType_ID").append(" = ?").append(" OR ").append("FAP_ObservationType_ID").append(" IS NULL)");
        }
        if (farmingStageId > 0) {
            MFAPFarmingStage farmingStage = MFAPFarmingStage.getById(ctx, farmingStageId, transactionName);
            Optional.ofNullable(farmingStage.getDayFrom()).ifPresent(dayFrom -> {
                if (whereClause.length() > 0) {
                    whereClause.append(" AND ");
                }
                parameters.add(dayFrom.intValue());
                whereClause.append("(").append("( ? BETWEEN ").append("DayFrom").append(" AND ").append("DayTo").append(")").append(" OR (").append("DayFrom").append(" IS NULL AND ").append("DayTo").append(" IS NULL))");
            });
            Optional.ofNullable(farmingStage.getDayTo()).ifPresent(dayTo -> {
                if (whereClause.length() > 0) {
                    whereClause.append(" AND ");
                }
                parameters.add(dayTo.intValue());
                whereClause.append("(").append("( ? BETWEEN ").append("DayFrom").append(" AND ").append("DayTo").append(")").append(" OR (").append("DayFrom").append(" IS NULL AND ").append("DayTo").append(" IS NULL))");
            });
        }
        if ((suggestedProducts = new Query(ctx, "FAP_SuggestedProduct", whereClause.toString(), transactionName).setClient_ID().setParameters(parameters).list()) != null && suggestedProducts.size() > 0) {
            matchingCache.put((Object)key, (Object)suggestedProducts);
        }
        return suggestedProducts;
    }

    @Override
    public String toString() {
        return "MFAPSuggestedProduct [getFAP_SuggestedProduct_ID()=" + this.getFAP_SuggestedProduct_ID() + ", getName()=" + this.getName() + ", getSeqNo()=" + this.getSeqNo() + "]";
    }
}

