/*
 * Decompiled with CFR 0.152.
 */
package org.farming.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriod;
import org.compiere.model.MTable;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.farming.engine.CategoryEngine;
import org.farming.engine.CategoryEngineFactory;
import org.farming.model.MFAPRawMaterialAttributes;
import org.farming.model.MFAPWeightCalculation;
import org.farming.model.X_FAP_RawMaterialConditioning;
import org.farming.util.FarmingTechnicalAssistanceUtil;

public class MFAPRawMaterialConditioning
extends X_FAP_RawMaterialConditioning
implements DocAction,
DocOptions {
    private static final long serialVersionUID = 20210408L;
    public static final String DocumentBaseType = "FCR";
    private List<MFAPRawMaterialAttributes> lines = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MFAPRawMaterialConditioning(Properties ctx, int FAP_RawMaterialConditioning_ID, String trxName) {
        super(ctx, FAP_RawMaterialConditioning_ID, trxName);
    }

    public MFAPRawMaterialConditioning(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    public void setC_DocType_ID() {
        int documentTypeId = MDocType.getDocType((String)DocumentBaseType);
        if (documentTypeId <= 0) {
            this.log.severe("Not found for AD_Client_ID=" + this.getAD_Client_ID() + ", DocBaseTypeType=" + DocumentBaseType);
        } else {
            this.log.fine("(SO) - FMB");
            this.setC_DocType_ID(documentTypeId);
        }
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getDateDoc(), (String)dt.getDocBaseType(), (int)this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        this.setDefaultValue();
        this.calculateConditionedWeight();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefaultValue() {
        PO recordWeight;
        if (this.getDD_RecordWeight_ID() <= 0) {
            throw new AdempiereException("@DD_RecordWeight_ID@ @IsMandatory@");
        }
        if (this.getC_BPartner_ID() <= 0) {
            throw new AdempiereException("@C_BPartner_ID@ @IsMandatory@");
        }
        if (this.getRM_QualityAnalysis_ID() <= 0) {
            recordWeight = MTable.get((Properties)this.getCtx(), (String)"DD_RecordWeight").getPO(this.getDD_RecordWeight_ID(), this.get_TrxName());
            FarmingTechnicalAssistanceUtil.getQualityAnalysisFromFreightOrder(recordWeight.getCtx(), recordWeight.get_ValueAsInt("DD_Freight_ID"), this.get_TrxName()).forEach(qualityAnalysys -> {
                this.setRM_QualityAnalysis_ID(qualityAnalysys.get_ValueAsInt("RM_QualityAnalysis_ID"));
                this.setM_Product_ID(qualityAnalysys.get_ValueAsInt("M_Product_ID"));
            });
        }
        if (!Optional.ofNullable(this.getDateDoc()).isPresent()) {
            recordWeight = MTable.get((Properties)this.getCtx(), (String)"DD_RecordWeight").getPO(this.getDD_RecordWeight_ID(), this.get_TrxName());
            this.setDateDoc((Timestamp)recordWeight.get_Value("DateDoc"));
        }
        if (Util.isEmpty((String)this.getUsingType())) {
            this.setUsingType("RW");
        }
        this.saveEx();
    }

    public void adddAttribute(String code, Object value, String description) {
        if (!Optional.ofNullable(value).isPresent()) {
            return;
        }
        if (value instanceof BigDecimal) {
            this.addAttribute(code, (BigDecimal)value, null, null, description);
        } else if (value instanceof String) {
            this.addAttribute(code, null, (String)value, null, description);
        } else if (value instanceof Timestamp) {
            this.addAttribute(code, null, null, (Timestamp)value, description);
        }
    }

    private void addAttribute(String code, BigDecimal valueNumber, String valueString, Timestamp valueDate, String description) {
        if (Util.isEmpty((String)code)) {
            return;
        }
        MFAPRawMaterialAttributes attribute = new MFAPRawMaterialAttributes(this.getCtx(), 0, this.get_TrxName());
        attribute.setFAP_RawMaterialConditioning_ID(this.getFAP_RawMaterialConditioning_ID());
        attribute.setCode(code);
        Optional.ofNullable(valueNumber).ifPresent(value -> attribute.setValueNumber((BigDecimal)value));
        Optional.ofNullable(valueString).ifPresent(value -> attribute.setValueString((String)value));
        Optional.ofNullable(valueDate).ifPresent(value -> attribute.setValueDate((Timestamp)value));
        Optional.ofNullable(description).ifPresent(value -> attribute.setDescription((String)value));
        attribute.saveEx();
    }

    private void calculateConditionedWeight() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        this.getLines(true).forEach(attribute -> {
            String key = attribute.getCode();
            Object value = Optional.ofNullable(attribute.get_Value("ValueString")).orElse(Optional.ofNullable(attribute.get_Value("ValueNumber")).orElse(attribute.get_Value("ValueDate")));
            attributes.put(key, value);
        });
        MFAPWeightCalculation calculation = MFAPWeightCalculation.getOfProductAndUsingType(this);
        CategoryEngine engine = CategoryEngineFactory.getInstance().getEngine(calculation);
        if (!Optional.ofNullable(engine).isPresent()) {
            throw new AdempiereException("@FAP_WeightCalculation_ID@ @NotFound@");
        }
        BigDecimal convertedWeight = engine.calculate(this.getCtx(), this.getC_BPartner_ID(), this.getM_Product_ID(), this.getDateDoc(), this.getNetWeight(), attributes, this.get_TrxName());
        BigDecimal conditionedweight = Optional.ofNullable(convertedWeight).orElse(Env.ZERO);
        this.setConditionedWeight(conditionedweight);
        this.set_Value("FAP_WeightCalculation_ID", calculation.getFAP_WeightCalculation_ID());
        this.saveEx();
        engine.getCategoryValues().entrySet().forEach(categoryValue -> this.adddAttribute((String)categoryValue.getKey(), categoryValue.getValue(), ""));
        this.updateRecordWeight();
    }

    private void updateRecordWeight() {
        if (!Optional.of(MTable.get((Properties)this.getCtx(), (String)"DD_RecordWeight")).isPresent() || this.getDD_RecordWeight_ID() <= 0) {
            return;
        }
        PO recordWeight = MTable.get((Properties)this.getCtx(), (String)"DD_RecordWeight").getPO(this.getDD_RecordWeight_ID(), this.get_TrxName());
        if (this.isNegotiatedAttributes()) {
            recordWeight.set_ValueOfColumn("NegotiatedConditionedWeight", (Object)this.getConditionedWeight());
        } else {
            recordWeight.set_ValueOfColumn("ConditionedWeight", (Object)this.getConditionedWeight());
        }
        recordWeight.saveEx();
    }

    public List<MFAPRawMaterialAttributes> getLines(boolean requery) {
        if (this.lines != null && this.lines.size() > 0 && !requery) {
            return this.lines;
        }
        this.lines = new Query(this.getCtx(), "FAP_RawMaterialAttributes", "FAP_RawMaterialConditioning_ID=?", this.get_TrxName()).setParameters(new Object[]{this.getFAP_RawMaterialConditioning_ID()}).list();
        return this.lines;
    }

    @Override
    public void setProcessed(boolean Processed) {
        super.setProcessed(Processed);
        this.getLines(true).forEach(attribute -> {
            attribute.setProcessed(Processed);
            attribute.saveEx(this.get_TrxName());
        });
    }

    private void setDefiniteDocumentNo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete()) {
            String value = null;
            int index = this.p_info.getColumnIndex("C_DocType_ID");
            if (index == -1) {
                index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (index != -1) {
                value = DB.getDocumentNo((int)this.get_ValueAsInt(index), (String)this.get_TrxName(), (boolean)true);
            }
            if (value != null) {
                this.setDocumentNo(value);
            }
        }
    }

    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (AD_Table_ID == Table_ID) {
            if (docStatus.equals("DR") || docStatus.equals("IP") || docStatus.equals("IN")) {
                options[index++] = "PR";
            } else if (docStatus.equals("CO")) {
                options[index++] = "VO";
                options[index++] = "RE";
                options[index++] = "CL";
            } else if (docStatus.equals("CL")) {
                options[index++] = "--";
            }
        }
        return index;
    }

    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        this.addDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Voided"));
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
        return this.m_processMsg == null;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (newRecord && this.getC_DocType_ID() <= 0) {
            this.setC_DocType_ID();
        }
        return super.beforeSave(newRecord);
    }

    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.voidIt();
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return 0;
    }

    public BigDecimal getApprovalAmt() {
        return null;
    }

    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MFAPRawMaterialConditioning[").append(this.getSummary()).append("]");
        return sb.toString();
    }
}

